/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.filter;

import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.filter.AbstractAutoFilter;
import com.kingdee.bos.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import java.util.ArrayList;
import java.util.List;

public class SheetMultipleItemAutoFilter
extends AbstractAutoFilter {
    private SortedObjectArray cellValueModelArray = new SortedObjectArray();

    public SheetMultipleItemAutoFilter(Sheet sheet, int colIndex) {
        super(sheet, colIndex);
    }

    @Override
    public ISheetAutoFilter changedColIndex(int colIndex) {
        ArrayList<CellValueModel> list = new ArrayList<CellValueModel>();
        for (int index = 0; index < this.cellValueModelArray.size(); ++index) {
            list.add((CellValueModel)this.cellValueModelArray.get(index));
        }
        return new SheetMultipleItemAutoFilter(this.sheet, colIndex, list);
    }

    public SheetMultipleItemAutoFilter(Sheet sheet, int colIndex, List<CellValueModel> values) {
        super(sheet, colIndex);
        this.cellValueModelArray.insertAll(values.toArray());
    }

    @Override
    protected boolean matchFilter(Cell cell) {
        CellValueModel model = new CellValueModel(cell);
        return this.cellValueModelArray.search(model) >= 0;
    }

    @Override
    public int getAutoFilterType() {
        return 4;
    }

    public SortedObjectArray getSelectedCellValueModels() {
        return this.cellValueModelArray;
    }

    public boolean containsCellValueModel(CellValueModel model) {
        return this.cellValueModelArray.search(model) >= 0;
    }

    public void addSelectedCellValueModel(CellValueModel model) {
        this.cellValueModelArray.insert(model);
    }
}

