/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util;

public class IntArray {
    private static int MIN_SIZE = 8;
    protected int[] _array;
    protected int _count;

    public IntArray() {
        this._array = null;
        this._count = 0;
    }

    public IntArray(int cap) {
        this._array = new int[Math.max(cap, MIN_SIZE)];
        this._count = 0;
    }

    public String toString() {
        if (this._count == 0) {
            return "[]";
        }
        StringBuffer sb = new StringBuffer(this._count << 3);
        sb.append('[');
        for (int i = 0; i < this._count; ++i) {
            sb.append(this._array[i]);
            sb.append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    public int size() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._array == null || this._count == 0;
    }

    public void clear() {
        this._count = 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this._array.length) {
            int[] oldData = this._array;
            int newCapacity = this._array.length * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._array = new int[newCapacity];
            System.arraycopy(oldData, 0, this._array, 0, this._count);
        }
    }

    public void add(int value) {
        if (this.isEmpty()) {
            if (this._array == null) {
                this._array = new int[MIN_SIZE];
            }
            this._array[0] = value;
            this._count = 1;
        } else {
            if (this._count + 1 > this._array.length) {
                int[] newAI = new int[this._array.length * 3 / 2 + 1];
                System.arraycopy(this._array, 0, newAI, 0, this._count);
                this._array = newAI;
            }
            this._array[this._count] = value;
            ++this._count;
        }
    }

    public int get(int index) {
        return this._array[index];
    }

    public void set(int index, int value) {
        this._array[index] = value;
    }

    public int[] toArray() {
        int[] dest = new int[this._count];
        System.arraycopy(this._array, 0, dest, 0, this._count);
        return dest;
    }

    public boolean contains(int v) {
        return this.indexOf(v) >= 0;
    }

    public int indexOf(int v) {
        for (int i = 0; i < this._count; ++i) {
            if (v != this._array[i]) continue;
            return i;
        }
        return -1;
    }
}

