/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util.profile;

import com.kingdee.bos.ctrl.kds.model.util.profile.IObjectProfileNode;

public abstract class ObjectProfileFilters {
    public static IObjectProfileNode.INodeFilter newSizeFilter(int threshold) {
        return new SizeFilter(threshold);
    }

    public static IObjectProfileNode.INodeFilter newRankFilter(int rank) {
        return new RankFilter(rank);
    }

    public static IObjectProfileNode.INodeFilter newSizeFractionFilter(double threshold) {
        return new SizeFractionFilter(threshold);
    }

    public static IObjectProfileNode.INodeFilter newParentSizeFractionFilter(double threshold) {
        return new ParentSizeFractionFilter(threshold);
    }

    private ObjectProfileFilters() {
    }

    private static final class ParentSizeFractionFilter
    implements IObjectProfileNode.INodeFilter {
        private final double m_threshold;

        @Override
        public boolean accept(IObjectProfileNode node) {
            IObjectProfileNode parent = node.parent();
            if (parent == null) {
                return true;
            }
            return (double)node.size() >= this.m_threshold * (double)parent.size();
        }

        ParentSizeFractionFilter(double threshold) {
            this.m_threshold = threshold;
        }
    }

    private static final class SizeFractionFilter
    implements IObjectProfileNode.INodeFilter {
        private final double m_threshold;

        @Override
        public boolean accept(IObjectProfileNode node) {
            return (double)node.size() >= this.m_threshold * (double)node.root().size();
        }

        SizeFractionFilter(double threshold) {
            this.m_threshold = threshold;
        }
    }

    private static final class RankFilter
    implements IObjectProfileNode.INodeFilter {
        private final int m_threshold;

        @Override
        public boolean accept(IObjectProfileNode node) {
            IObjectProfileNode parent = node.parent();
            if (parent == null) {
                return true;
            }
            IObjectProfileNode[] siblings = parent.children();
            int rLimit = Math.min(siblings.length, this.m_threshold);
            for (int r = 0; r < rLimit; ++r) {
                if (siblings[r] != node) continue;
                return true;
            }
            return false;
        }

        RankFilter(int threshold) {
            this.m_threshold = threshold;
        }
    }

    private static final class SizeFilter
    implements IObjectProfileNode.INodeFilter {
        private final int m_threshold;

        @Override
        public boolean accept(IObjectProfileNode node) {
            return node.size() >= this.m_threshold;
        }

        SizeFilter(int threshold) {
            this.m_threshold = threshold;
        }
    }
}

