function radarTooltipFormatter(params, left, f) {
    var arr = new Array();
    var ret = '';
    if (params.seriesType === 'radar') {
        for (var n = 0 ; n < params.value.length ; n ++) {
            arr.push(params.value[n]);
        }
    } else {
        arr.push(params.value);
    }
    for (var j = 0; j < arr.length; j ++) {
        var value = arr[j];
        var number = formatNumber(value, left);
        var templateFormat = f;
        if (templateFormat != '') {
            templateFormat = templateFormat.replace('{a}', params.seriesName).replace('{b}', params.name).replace('{c}', number);
            if (params.percent) {
                templateFormat = templateFormat.replace('{d}', params.percent + '');
            }
        } else if (params.seriesType === 'radar') {
            ret = ret + params.marker + option.radar.indicator[j].name + ' ' + number;
        } else {
            ret = ret + params.marker + params.seriesName + ' ' + number;
        }
        ret = ret + templateFormat + '<br />';
    }
    if (params.seriesType === 'radar') {
        return params.seriesName + '<br />' + ret;
    }
    return ret;
}
