/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.data;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.modal.CommonQuery;
import com.kingdee.bos.ctrl.data.modal.IDataDef;
import com.kingdee.bos.ctrl.data.modal.io.DataDef2Meta;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.kdf.data.datasource.DSParam;
import com.kingdee.bos.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.bos.ctrl.kdf.data.datasource.ReferencedDataSource;
import com.kingdee.bos.ctrl.kdf.data.upgrade.KdfDataSource2CommonQuery;
import com.kingdee.bos.ctrl.kdf.fd2.data.DefaultDataForBind;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataForBind;
import com.kingdee.bos.ctrl.kdf.fd2.data.IDataManager;
import com.kingdee.bos.ctrl.kdf.fd2.data.IMetaManager;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.QueryChangeListener;
import com.kingdee.bos.ctrl.kdf.fd2.gui.data.QueryManageDialog;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFXmlReader;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class DefaultDataManager
implements IDataManager {
    private DefaultDataForBind data4Bind = new DefaultDataForBind();
    private CommonQuery[] dataObjs;
    private DSParam[] params;
    private QueryManageDialog dialog;

    public void setData(CommonQuery[] data) {
        this.dataObjs = data;
        this.syncDataForBind();
    }

    @Override
    public boolean isEditabled() {
        return true;
    }

    @Override
    public boolean showDataEditor(JComponent owner, IMetaManager metaManager, QueryChangeListener listener) {
        this.dialog = (QueryManageDialog)((Object)WindowUtil.createWindow(QueryManageDialog.class, (Component)owner));
        this.dialog.setQueryChangedListener(listener);
        if (metaManager != null) {
            this.dialog.setMeta(metaManager.getMetaData());
        }
        this.dialog.setData(this.dataObjs, this.params);
        if (this.dialog.showDialog()) {
            this.dataObjs = this.dialog.getData();
            this.params = this.dialog.getParams();
            this.syncDataForBind();
            return true;
        }
        return false;
    }

    private void syncDataForBind() {
        MetaClass[] mcs = new MetaClass[this.dataObjs.length];
        for (int i = 0; i < this.dataObjs.length; ++i) {
            CommonQuery dataObj = this.dataObjs[i];
            mcs[i] = DataDef2Meta.parseDataObject((IDataDef)dataObj);
        }
        this.data4Bind.setDatas(mcs);
    }

    @Override
    public IDataForBind getDataForBind() {
        return this.data4Bind;
    }

    @Override
    public void saveData(KDF kdfdom) {
        if (this.dataObjs == null) {
            return;
        }
        for (int i = 0; i < this.dataObjs.length; ++i) {
            ReferencedDataSource ds = new ReferencedDataSource(this.dataObjs[i].getName());
            if (this.params != null && this.params[i] != null) {
                ds.addParam(this.params[i]);
            }
            kdfdom.addDataSource((DataSource)ds);
            Element eleDss = kdfdom.getReader().getDataSourcesNode();
            eleDss.setAttribute("version", "2.0");
            kdfdom.addDataObject((IDataDef)this.dataObjs[i]);
            Element eleDo = kdfdom.getReader().getDataObjectsNode();
            eleDo.setAttribute("version", "1.0");
        }
    }

    @Override
    public void loadData(KDF kdfdom) {
        Object[] dos = null;
        Element eleDss = kdfdom.getReader().getDataSourcesNode();
        String strVer = eleDss.getAttributeValue("version");
        dos = StringUtil.isEmptyString((String)strVer) ? KdfDataSource2CommonQuery.done((Element)eleDss, (Namespace)KDFXmlReader.NS_COMMON) : kdfdom.getDataObjects();
        DataSource[] dss = kdfdom.getDataSources();
        for (int i = 0; i < dss.length; ++i) {
            DataSource ds = dss[i];
            ArrayList listParams = ds.getParams();
            if (listParams == null || listParams.size() <= 0) continue;
            if (this.params == null) {
                this.params = new DSParam[dss.length];
            }
            this.params[i] = (DSParam)listParams.get(0);
        }
        if (dos != null) {
            this.setData(this.cast((IDataDef[])dos));
        }
    }

    private CommonQuery[] cast(IDataDef[] dos) {
        String tableNameEnd = "." + DataDefType.BOS_QUERY.getName();
        ArrayList<IDataDef> list = new ArrayList<IDataDef>();
        for (int i = 0; i < dos.length; ++i) {
            String tableName;
            IQuery cq = ((CommonQuery)dos[i]).getQuery();
            if (cq.getQueryType() == QueryType.BOS_QUERY && !StringUtil.isEmptyString((String)(tableName = cq.getContent())) && !tableName.endsWith(tableNameEnd)) {
                cq.setContent(tableName + tableNameEnd);
            }
            list.add(dos[i]);
        }
        return list.toArray(new CommonQuery[0]);
    }
}

