/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.data;

import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.util.CtrlClassUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.kdf.fd2.SideLocation;
import com.kingdee.bos.ctrl.kdf.fd2.gui.FormDesigner;
import com.kingdee.bos.ctrl.kdf.fd2.gui.KDFFrame;
import com.kingdee.bos.ctrl.kdf.fd2.gui.util.MsgBox;
import com.kingdee.bos.ctrl.kdf.fd2.icons.Icons;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.AbstractGroup;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.FieldElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.IContainer;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.LoopArea;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Page;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.ReportElement;
import com.kingdee.bos.ctrl.kdf.fd2.reportelement.Table;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class QueryTree
extends KDTree {
    private Object parentObj;
    private Object nodeObj;
    private FormDesigner designer;
    private KDFFrame kdfFrame;
    private boolean isCanDrop = false;
    private ReportElement target;
    private static final String CREATE_FIELD = QueryTree.getMLS("createField", "\u751f\u6210\u65b0");
    private static final String REBIND_FIELD = QueryTree.getMLS("rebindField", "\u66ff\u6362\u62d6\u653e");
    private static final String BIND_FIELD = QueryTree.getMLS("bindField", "\u7ed1\u5b9a\u62d6\u653e");
    private static String res = CtrlClassUtil.getPackageName(QueryTree.class) + ".data";

    public QueryTree(FormDesigner formDesigner) {
        this.init();
        this.designer = formDesigner;
    }

    private void init() {
        this.installListener();
    }

    private void installListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path;
                QueryTree.this.isCanDrop = false;
                if (e.getButton() == 1 && (path = QueryTree.this.getClosestPath(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof DefaultKingdeeTreeNode) {
                    QueryTree.this.nodeObj = ((DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject();
                    QueryTree.this.parentObj = ((DefaultKingdeeTreeNode)path.getParentPath().getLastPathComponent()).getUserObject();
                    QueryTree.this.kdfFrame = QueryTree.this.designer.getKDFFrame();
                    return;
                }
                QueryTree.this.nodeObj = null;
                QueryTree.this.parentObj = null;
                QueryTree.this.kdfFrame = null;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                QueryTree.this.doReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            private Point newP;

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && QueryTree.this.nodeObj != null) {
                    if (QueryTree.this.getCursor() != Icons.CURSOR_MOVEDDROP) {
                        QueryTree.this.setCursor(Icons.CURSOR_MOVEDDROP);
                    }
                    this.newP = SwingUtilities.convertPoint((Component)((Object)QueryTree.this), e.getX(), e.getY(), QueryTree.this.kdfFrame.getPageContainerPanel());
                    QueryTree.this.kdfFrame.showStatusAtMove(this.newP.x, this.newP.y);
                    QueryTree.this.target = QueryTree.this.kdfFrame.searchSelectElement(this.newP.x, this.newP.y);
                    QueryTree.this.isCanDrop = QueryTree.this.isTargetCanDrop(QueryTree.this.target, QueryTree.this.nodeObj);
                    if (QueryTree.this.isCanDrop) {
                        QueryTree.this.kdfFrame.getPageContainerPanel().setCursor(Icons.CURSOR_MOVEDDROP);
                    } else {
                        QueryTree.this.kdfFrame.getPageContainerPanel().setCursor(Icons.CURSOR_FORBID);
                    }
                }
            }
        });
    }

    private boolean isTargetCanDrop(ReportElement targetElm, Object nodeUserObj) {
        if (targetElm != null && nodeUserObj instanceof MetaField && (targetElm.getEleType() == 10 || targetElm.getEleType() == 12 || targetElm.getEleType() == 15 || targetElm.getEleType() == 4)) {
            return true;
        }
        return targetElm != null && nodeUserObj instanceof MetaClass && (targetElm.getEleType() == 10 || targetElm.getEleType() == 12 || targetElm.getEleType() == 15 || targetElm.getEleType() == 11 && ((LoopArea)targetElm).getChildren().size() == 0);
    }

    public Object getDragedNodeObj() {
        return this.nodeObj;
    }

    private void doReleased(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (this.kdfFrame != null) {
            this.kdfFrame.getPageContainerPanel().setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.isCanDrop) {
            Point newP = SwingUtilities.convertPoint((Component)((Object)this), e.getX(), e.getY(), this.kdfFrame.getPageContainerPanel());
            if (this.nodeObj instanceof MetaField) {
                this.dragColumn(newP);
            } else if (this.nodeObj instanceof MetaClass) {
                this.dragQuery(newP);
            }
        }
    }

    private void dragColumn(Point point) {
        String newDS = "";
        if (this.parentObj instanceof MetaClass) {
            newDS = ((MetaClass)this.parentObj).getName();
        }
        IContainer parent = this.target.getEleType() == 4 ? this.target.getParent() : (IContainer)((Object)this.target);
        String currentDS = null;
        String superDS = null;
        if (parent instanceof AbstractGroup) {
            currentDS = ((AbstractGroup)parent).getDataSource();
            if (StringUtil.isEmptyString((String)currentDS)) {
                superDS = ((AbstractGroup)parent).getNearDataSource();
            }
        } else {
            currentDS = ((Page)parent).getDataSource();
        }
        Iterator it = parent.getChildren().iterator();
        boolean hasBoundField = false;
        while (!hasBoundField && it.hasNext()) {
            ReportElement child = (ReportElement)it.next();
            if (child.getEleType() != 4 || StringUtil.isEmptyString((String)((FieldElement)child).getFieldAlias())) continue;
            hasBoundField = true;
        }
        MetaField qryClm = (MetaField)this.nodeObj;
        if (StringUtil.isEmptyString((String)currentDS)) {
            if (hasBoundField) {
                if (StringUtil.equals((String)superDS, (String)newDS)) {
                    this.dealWithField(null, parent, this.target, qryClm, point);
                } else if (this.choiceBindDSHasSuperDSField(parent.getAliasName(), newDS, this.getDoWhat(this.target)) == 0) {
                    this.dealWithField(newDS, parent, this.target, qryClm, point);
                }
            } else {
                this.promptBindDS(parent.getAliasName(), newDS);
                this.dealWithField(newDS, parent, this.target, qryClm, point);
            }
        } else if (StringUtil.equals((String)newDS, (String)currentDS)) {
            this.dealWithField(null, parent, this.target, qryClm, point);
        } else if (hasBoundField) {
            if (this.choiceChangeDSHasBoundField(parent.getAliasName(), currentDS, newDS, this.getDoWhat(this.target)) == 0) {
                this.dealWithField(newDS, parent, this.target, qryClm, point);
            }
        } else if (this.choiceChangeDS(parent.getAliasName(), currentDS, newDS, this.getDoWhat(this.target)) == 0) {
            this.dealWithField(newDS, parent, this.target, qryClm, point);
        }
    }

    private void dragQuery(Point point) {
        LoopArea loopArea = (LoopArea)this.kdfFrame.insertReportElement((IContainer)((Object)this.target), 11, point.x, point.y);
        Table tableGroup = (Table)this.kdfFrame.insertReportElement(loopArea, 10, -1, -1);
        MetaClass scm = (MetaClass)this.nodeObj;
        List fields = scm.getFields();
        int colNum = fields.size();
        colNum = colNum == 0 ? 1 : colNum;
        tableGroup.setDataSource(scm.getName());
        tableGroup.setRowCount(1);
        tableGroup.setColumnCount(colNum);
        SideLocation left = tableGroup.getLocation().getSideLocation(0);
        SideLocation right = tableGroup.getLocation().getSideLocation(1);
        SideLocation top = tableGroup.getLocation().getSideLocation(2);
        SideLocation bottom = tableGroup.getLocation().getSideLocation(3);
        left.setType(0);
        left.setRelativeObjectID(loopArea.getName());
        left.setContextValue(0);
        left.setValue(0);
        right.setType(0);
        right.setRelativeObjectID(loopArea.getName());
        right.setContextValue(1);
        right.setValue(0);
        top.setType(0);
        top.setRelativeObjectID(loopArea.getName());
        top.setContextValue(2);
        top.setValue(0);
        bottom.setType(0);
        bottom.setRelativeObjectID(tableGroup.getName());
        bottom.setContextValue(2);
        bottom.setValue((int)(loopArea.getHeightLom() > 100 ? 100.0 : (double)loopArea.getHeightLom() * 0.618));
        tableGroup.setLocation(tableGroup.getLocation());
        List fds = scm.getFields();
        for (int i = 0; i < fds.size(); ++i) {
            MetaField qryClm = (MetaField)fds.get(i);
            FieldElement field = (FieldElement)this.kdfFrame.insertReportElement(tableGroup, 4, -1, -1);
            field.setField(qryClm);
        }
        this.kdfFrame.setSelectedElement(loopArea);
    }

    private void dealWithField(String ds, IContainer parent, ReportElement re, MetaField clm, Point p) {
        this.setParentDS(ds, parent);
        if (this.getDoWhat(re) == CREATE_FIELD) {
            FieldElement field = (FieldElement)this.kdfFrame.insertReportElement(parent, 4, p.x, p.y);
            field.setField(clm);
        } else {
            ((FieldElement)re).setField(clm);
        }
        this.kdfFrame.repaint();
        if (this.designer.getElementPropertiesDialog().isVisible()) {
            this.designer.getElementPropertiesDialog().updateSelection();
        }
    }

    private void setParentDS(String ds, IContainer parent) {
        if (StringUtil.isEmptyString((String)ds)) {
            return;
        }
        if (parent instanceof AbstractGroup) {
            ((AbstractGroup)parent).setDataSource(ds);
        } else if (((ReportElement)((Object)parent)).getEleType() == 15) {
            ((Page)parent).setDataSource(ds);
        }
    }

    private String getDoWhat(ReportElement re) {
        if (re.getEleType() == 4) {
            if (StringUtil.isEmptyString((String)((FieldElement)re).getFieldAlias())) {
                return BIND_FIELD;
            }
            return REBIND_FIELD;
        }
        return CREATE_FIELD;
    }

    private void promptBindDS(String containerName, String dsName) {
        StringBuffer prompt = new StringBuffer();
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("autoBindDS", " \u81ea\u52a8\u7ed1\u5b9a\u6570\u636e\u6e90 "));
        prompt.append(this.dsName2Alias(dsName));
        prompt.append(QueryTree.getMLS("fullStop", "\u3002"));
        MsgBox.show((Component)((Object)this.designer), prompt.toString(), QueryTree.getMLS("promptTitle", "\u91d1\u8776\u63d0\u793a"), 33);
    }

    private int choiceBindDSHasSuperDSField(String containerName, String dsName, String doWhat) {
        StringBuffer prompt = new StringBuffer();
        prompt.append(QueryTree.getMLS("want", "\u60a8\u662f\u5426\u5e0c\u671b "));
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("autoBindDS", " \u81ea\u52a8\u7ed1\u5b9a\u6570\u636e\u6e90 "));
        prompt.append(this.dsName2Alias(dsName));
        prompt.append(QueryTree.getMLS("interrogation", "\uff1f"));
        prompt.append("\r\n");
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("hasSuperDSField", " \u4e2d\u5df2\u6709\u5b57\u6bb5\u901a\u8fc7\u4e0a\u7ea7\u6570\u636e\u6e90\u8fdb\u884c\u7ed1\u5b9a\uff0c"));
        prompt.append(QueryTree.getMLS("choicePrompt", "\u9009\u201c\u662f\u201d\uff0c\u5c06\u6e05\u9664\u8fd9\u4e9b\u5df2\u7ed1\u5b9a\u7684\u5b57\u6bb5\uff1b\u9009\u201c\u5426\u201d\uff0c\u5219\u4e0d\u80fd"));
        prompt.append(doWhat);
        prompt.append(QueryTree.getMLS("field", "\u5b57\u6bb5"));
        prompt.append(QueryTree.getMLS("fullStop", "\u3002"));
        return MsgBox.show((Component)((Object)this.designer), prompt.toString(), QueryTree.getMLS("promptTitle", "\u91d1\u8776\u63d0\u793a"), 68);
    }

    private int choiceChangeDS(String containerName, String currentDS, String newDS, String doWhat) {
        StringBuffer prompt = new StringBuffer();
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("hasBoundDS", " \u5df2\u7ed1\u5b9a\u6570\u636e\u6e90 "));
        prompt.append(this.dsName2Alias(currentDS));
        prompt.append(QueryTree.getMLS("wantToChange", "\uff0c\u662f\u5426\u5e0c\u671b\u6539\u4e3a "));
        prompt.append(this.dsName2Alias(newDS));
        prompt.append(QueryTree.getMLS("and", " \u5e76"));
        prompt.append(doWhat);
        prompt.append(QueryTree.getMLS("field", "\u5b57\u6bb5"));
        prompt.append(QueryTree.getMLS("interrogation", "\uff1f"));
        return MsgBox.show((Component)((Object)this.designer), prompt.toString(), QueryTree.getMLS("promptTitle", "\u91d1\u8776\u63d0\u793a"), 68);
    }

    private int choiceChangeDSHasBoundField(String containerName, String currentDS, String newDS, String doWhat) {
        StringBuffer prompt = new StringBuffer();
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("hasBoundDS", " \u5df2\u7ed1\u5b9a\u6570\u636e\u6e90 "));
        prompt.append(this.dsName2Alias(currentDS));
        prompt.append(QueryTree.getMLS("wantToChange", "\uff0c\u662f\u5426\u5e0c\u671b\u6539\u4e3a "));
        prompt.append(this.dsName2Alias(newDS));
        prompt.append(QueryTree.getMLS("interrogation", "\uff1f"));
        prompt.append("\r\n");
        prompt.append(containerName);
        prompt.append(QueryTree.getMLS("hasBoundField", " \u4e2d\u5df2\u6709\u7ed1\u5b9a\u5b57\u6bb5\uff0c"));
        prompt.append(QueryTree.getMLS("choicePrompt", "\u9009\u201c\u662f\u201d\uff0c\u5c06\u6e05\u9664\u8fd9\u4e9b\u5df2\u7ed1\u5b9a\u7684\u5b57\u6bb5\uff1b\u9009\u201c\u5426\u201d\uff0c\u5219\u4e0d\u80fd"));
        prompt.append(doWhat);
        prompt.append(QueryTree.getMLS("field", "\u5b57\u6bb5"));
        prompt.append(QueryTree.getMLS("fullStop", "\u3002"));
        return MsgBox.show((Component)((Object)this.designer), prompt.toString(), QueryTree.getMLS("promptTitle", "\u91d1\u8776\u63d0\u793a"), 68);
    }

    private String dsName2Alias(String name) {
        try {
            return this.kdfFrame.getReport().getDataManager().getDataForBind().getData(name).getAliasName();
        }
        catch (NullPointerException ex) {
            return name;
        }
    }

    private static String getMLS(String key, String defaultValue) {
        return LanguageManager.getLangMessage((String)key, (String)res, (String)defaultValue);
    }
}

