/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kdf.fd2.gui.util;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.Timer;

public class SplashFrame
extends JDialog {
    private Image splashImage;
    private BufferedImage screenShot;
    private BufferedImage screenMix;
    private BufferedImage srcImage;
    private BufferedImage mixImage;
    private BufferedImage tempImage;
    private Timer timer;
    private int timeout;
    private int timecount;
    private int interval = 70;
    private int imageWidth;
    private int imageHeight;
    private Robot robot;
    private int fade = 0;

    public SplashFrame(JFrame parent, Image splashImage) {
        this(parent, splashImage, 3000);
    }

    public SplashFrame(JFrame parent, Image splashImage, int timeout) {
        this(parent, splashImage, timeout, 400, 300);
    }

    public SplashFrame(JFrame parent, Image splashImage, int timeout, int width, int height) {
        super(parent);
        this.init(splashImage, timeout, width, height);
    }

    public SplashFrame(JDialog parent, Image splashImage) {
        this(parent, splashImage, 3000);
    }

    public SplashFrame(JDialog parent, Image splashImage, int timeout) {
        this(parent, splashImage, timeout, 400, 300);
    }

    public SplashFrame(JDialog parent, Image splashImage, int timeout, int width, int height) {
        super(parent);
        this.init(splashImage, timeout, width, height);
    }

    private void init(Image splashImage, int timeout, int width, int height) {
        this.setUndecorated(true);
        this.splashImage = splashImage;
        this.timeout = timeout;
        this.timecount = 0;
        this.imageWidth = width;
        this.imageHeight = height;
        this.initialize();
    }

    private void initialize() {
        this.timer = new Timer(this.interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SplashFrame.this.timecount > SplashFrame.this.timeout / 2) {
                    if (SplashFrame.this.timecount > SplashFrame.this.timeout) {
                        SplashFrame.this.timer.stop();
                        return;
                    }
                    if (SplashFrame.this.fade == 2) {
                        SplashFrame.this.timecount = SplashFrame.this.timecount + SplashFrame.this.interval;
                        SplashFrame.this.getContentPane().getGraphics().drawImage(SplashFrame.this.screenMix, 0, 0, SplashFrame.this.getContentPane());
                        SplashFrame.this.getContentPane().getGraphics().drawRect(0, 0, SplashFrame.this.imageWidth - 1, SplashFrame.this.imageHeight - 1);
                        return;
                    }
                }
                SplashFrame.this.timecount = SplashFrame.this.timecount + SplashFrame.this.interval;
                SplashFrame.this.getContentPane().getGraphics().drawImage(SplashFrame.this.mixImage, 0, 0, SplashFrame.this.getContentPane());
                SplashFrame.this.getContentPane().getGraphics().drawRect(0, 0, SplashFrame.this.imageWidth - 1, SplashFrame.this.imageHeight - 1);
            }
        });
        Dimension scsize = this.getScreenSize(this);
        this.setSize(this.imageWidth, this.imageHeight);
        this.setLocation((scsize.width - this.imageWidth) / 2, (scsize.height - this.imageHeight) / 2);
        try {
            this.robot = new Robot();
            this.screenMix = new BufferedImage(this.imageWidth, this.imageHeight, 2);
            this.srcImage = new BufferedImage(this.imageWidth, this.imageHeight, 2);
            this.mixImage = new BufferedImage(this.imageWidth, this.imageHeight, 2);
            this.tempImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            this.screenShot = this.srcImage;
            int x = (this.splashImage.getWidth(null) - this.imageWidth) / 2;
            int y = (this.splashImage.getHeight(null) - this.imageHeight) / 2;
            int w = Math.min(this.splashImage.getWidth(null), this.imageWidth);
            int h = Math.min(this.splashImage.getHeight(null), this.imageHeight);
            int srcxoff = x > 0 ? x : 0;
            int srcyoff = y > 0 ? y : 0;
            int desxoff = x > 0 ? 0 : -x;
            int desyoff = y > 0 ? 0 : -y;
            this.srcImage.getGraphics().drawImage(this.splashImage, desxoff, desyoff, desxoff + w, desyoff + h, srcxoff, srcyoff, srcxoff + w, srcyoff + h, this);
            this.mixImage.getGraphics().drawImage(this.srcImage, 0, 0, null);
            int alpha = 0x30FFFFFF;
            for (int i = 0; i < this.imageWidth; ++i) {
                for (int j = 0; j < this.imageHeight; ++j) {
                    this.mixImage.setRGB(i, j, alpha & this.mixImage.getRGB(i, j));
                }
            }
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paint(Graphics g) {
        this.tempImage.getGraphics().drawImage(this.screenShot, 0, 0, null);
        if (this.fade == 0 || this.timecount > this.timeout) {
            this.tempImage.getGraphics().drawImage(this.srcImage, 0, 0, null);
        }
        this.getContentPane().getGraphics().drawImage(this.tempImage, 0, 0, this.getContentPane());
        this.getContentPane().getGraphics().drawRect(0, 0, this.imageWidth - 1, this.imageHeight - 1);
    }

    private void prepareShow() {
        this.screenShot = this.robot.createScreenCapture(new Rectangle(this.getLocation().x, this.getLocation().y, this.imageWidth, this.imageHeight));
        this.screenMix.getGraphics().drawImage(this.screenShot, 0, 0, null);
        int alpha = 0x30FFFFFF;
        for (int i = 0; i < this.imageWidth; ++i) {
            for (int j = 0; j < this.imageHeight; ++j) {
                this.screenMix.setRGB(i, j, alpha & this.screenMix.getRGB(i, j));
            }
        }
    }

    public void showSplash() {
        this.fade = 0;
        this.prepareShow();
        this.show();
    }

    public void showFadeIn() {
        this.fade = 1;
        this.prepareShow();
        this.timer.start();
        this.show();
    }

    public void showFadeInOut() {
        this.fade = 2;
        this.prepareShow();
        this.timer.start();
        this.show();
    }

    public void stop() {
        this.timer.stop();
        this.hide();
    }

    public Dimension getScreenSize(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        screenSize.width = screenSize.width - insets.left - insets.right;
        screenSize.height = screenSize.height - insets.top - insets.bottom;
        return screenSize;
    }
}

