/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.modal.io;

import com.kingdee.bos.ctrl.reportone.data.modal.io.ExecDef;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Content;
import org.jdom2.Element;

public class ExecDefIO {
    public static final String T_EXEC = "Exec";
    public static final String T_ARGS = "Args";
    public static final String T_ARG = "Arg";
    public static final String A_NAME = "name";
    public static final String A_INDEX = "index";
    public static final String A_URI = "uri";
    public static final String A_DESC = "desc";

    public static final Element makeExec(ExecDef execDef) {
        Map args;
        String desc;
        Element xml = new Element(T_EXEC);
        String url = execDef.getUri();
        if (url != null) {
            xml.setAttribute(A_URI, url);
        }
        if ((desc = execDef.getDesc()) != null) {
            xml.setAttribute(A_DESC, desc);
        }
        if ((args = execDef.getArgs()) != null) {
            xml.addContent((Content)ExecDefIO.makeArgs(args));
        }
        return xml;
    }

    public static final Element makeArgs(Map args) {
        Element xml = new Element(T_ARGS);
        for (Map.Entry ent : args.entrySet()) {
            xml.addContent((Content)ExecDefIO.makeArg((String)ent.getKey(), ent.getValue()));
        }
        return xml;
    }

    public static final Element makeArg(String name, Object value) {
        Element xml = new Element(T_ARG);
        xml.setAttribute(A_NAME, name);
        if (value != null) {
            xml.addContent(value.toString());
        }
        return xml;
    }

    public static final ExecDef parseExec(Element xml) {
        ExecDef execDef = new ExecDef();
        execDef.setUri(xml.getAttributeValue(A_URI));
        execDef.setDesc(xml.getAttributeValue(A_DESC));
        Element xmlArgs = xml.getChild(T_ARGS);
        if (xmlArgs != null) {
            execDef.setArgs(ExecDefIO.parseArgs(xmlArgs));
        }
        return execDef;
    }

    public static final HashMap parseArgs(Element xml) {
        HashMap args = new HashMap();
        Iterator itr = xml.getChildren(T_ARG).iterator();
        while (itr.hasNext()) {
            ExecDefIO.parseArg((Element)itr.next(), args);
        }
        return args;
    }

    public static final void parseArg(Element xml, Map args) {
        String name = xml.getAttributeValue(A_NAME);
        String text = xml.getText();
        args.put(name, text);
    }
}

