/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.data.wizard.xmeta;

import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.MultiLangUI;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.DataDefType;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.TableMultiLangUI;
import com.kingdee.bos.ctrl.reportone.data.wizard.xmeta.MetaImportSelector;
import com.kingdee.bos.ctrl.reportone.data.wizard.xmeta.XmetaResource;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jdom2.Element;

public class XMetaPanel
extends KDPanel {
    private static final int COL_NAME = 0;
    private static final int COL_ALIAS = 1;
    private static final int COL_TYPE = 2;
    private static final DataDefType[] META_TYPES = new DataDefType[]{DataDefType.DB_TABLE, DataDefType.DB_VIEW, DataDefType.DB_CODE, DataDefType.BOS_QUERY, DataDefType.BOS_ENTITY, DataDefType.BOS_TABLE};
    private MetaClass mc;
    private boolean isChanged = false;
    private KDTextField txtName;
    private KDMultiLangBox mlbAlias;
    private KDComboBox cbxType;
    private KDPromptBox f7Expr;
    private KDMultiLangBox mlbDesc;
    private KDTable tblFields;
    private KDWorkButton btnUp;
    private KDWorkButton btnDown;
    private KDWorkButton btnInsert;
    private KDWorkButton btnDelete;
    private KDRadioButton radFieldsFromBos;
    private KDRadioButton radFieldsCustom;
    private MetaImportSelector dlgFromBos;

    public XMetaPanel(MetaImportSelector dlg) {
        this.dlgFromBos = dlg;
        this.init();
    }

    private void init() {
        this.txtName = new KDTextField();
        this.mlbAlias = MultiLangUI.newKDMultiLangBox();
        this.cbxType = new KDComboBox();
        this.f7Expr = new KDPromptBox();
        this.mlbDesc = MultiLangUI.newKDMultiLangBox();
        this.radFieldsFromBos = new KDRadioButton(XmetaResource.getString("res_13"));
        this.radFieldsCustom = new KDRadioButton(XmetaResource.getString("res_14"));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.radFieldsFromBos);
        bg.add((AbstractButton)this.radFieldsCustom);
        this.btnUp = new KDWorkButton((Icon)Resource.ICON_MOVE_TOP);
        this.btnDown = new KDWorkButton((Icon)Resource.ICON_MOVE_DOWN);
        this.btnInsert = new KDWorkButton((Icon)Resource.ICON_INSERT);
        this.btnDelete = new KDWorkButton((Icon)Resource.ICON_DELETE);
        this.btnUp.setToolTipText(XmetaResource.getString("res_1"));
        this.btnDown.setToolTipText(XmetaResource.getString("res_2"));
        this.btnInsert.setToolTipText(XmetaResource.getString("res_3"));
        this.btnUp.setMinimumSize(new Dimension(26, 19));
        this.btnDown.setMinimumSize(new Dimension(26, 19));
        this.btnInsert.setMinimumSize(new Dimension(26, 19));
        this.btnDelete.setMinimumSize(new Dimension(26, 19));
        for (int i = 0; i < META_TYPES.length; ++i) {
            this.cbxType.addItem((Object)META_TYPES[i]);
        }
        this.cbxType.setSelectedItem((Object)DataDefType.BOS_QUERY);
        this.cbxType.setEnabled(false);
        this.dlgFromBos.setTitle(XmetaResource.getString("res_13"));
        this.f7Expr.setSelector((KDPromptSelector)this.dlgFromBos);
        this.f7Expr.setEditable(false);
        this.initTable();
        this.initFieldsFormMode(true);
        this.installListener();
        TableLayout layout = TableLayout.splitRow((int)6);
        this.setLayout((LayoutManager)layout);
        layout.defaultStyle().setMarginBottom(5);
        layout.rowStyle(0).setHeight(50);
        layout.rowStyle(2).setMarginBottom(20);
        layout.rowStyle(5).setPriY(1);
        Table t0 = layout.cell(4).split(2, 3);
        t0.colStyle(0).setPriX(1);
        t0.colStyle(2).setPriX(1);
        t0.colStyle(1).setWidth(40);
        t0.rowStyle(0).setMarginBottom(5);
        TableLayout tlFields = TableLayout.splitRow((int)2);
        tlFields.rowStyle(0).setHeight(19);
        tlFields.rowStyle(0).setMarginBottom(3);
        tlFields.rowStyle(1).setPriY(1);
        Table t2 = tlFields.cell(0).splitCol(5);
        t2.colStyle(0).setPriX(1);
        t2.colStyle(1).setMarginRight(3);
        t2.colStyle(2).setMarginRight(3);
        t2.colStyle(3).setMarginRight(3);
        KDPanel panFields = new KDPanel((LayoutManager)tlFields);
        panFields.add((Component)new KDLabel(XmetaResource.getString("res_9")), (Object)t2.cell(0));
        panFields.add((Component)this.btnInsert, (Object)t2.cell(1));
        panFields.add((Component)this.btnDelete, (Object)t2.cell(2));
        panFields.add((Component)this.btnUp, (Object)t2.cell(3));
        panFields.add((Component)this.btnDown, (Object)t2.cell(4));
        panFields.add((Component)this.tblFields, (Object)tlFields.cell(1));
        KDTextArea txaPrompt = new KDTextArea();
        txaPrompt.setEnabled(false);
        txaPrompt.setBorder(null);
        txaPrompt.setText(XmetaResource.getString("res_15"));
        this.add((Component)txaPrompt, layout.cell(0));
        this.add((Component)this.radFieldsFromBos, layout.cell(1));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.f7Expr, (String)XmetaResource.getString("res_7"), (int)80), layout.cell(2));
        this.add((Component)this.radFieldsCustom, layout.cell(3));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.txtName, (String)XmetaResource.getString("res_4"), (int)80), t0.cell(0, 0));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.cbxType, (String)XmetaResource.getString("res_6"), (int)80), t0.cell(0, 2));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbAlias, (String)XmetaResource.getString("res_5"), (int)80), t0.cell(1, 0));
        this.add((Component)CtrlSwingUtilities.createLabelContainer((JComponent)this.mlbDesc, (String)XmetaResource.getString("res_8"), (int)80), t0.cell(1, 2));
        this.add((Component)panFields, layout.cell(5));
    }

    private void installListener() {
        this.radFieldsCustom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.updateFieldsFormMode(true);
            }
        });
        this.radFieldsFromBos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.updateFieldsFormMode(false);
            }
        });
        this.btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.rowUp();
            }
        });
        this.btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.rowDown();
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.insertRow();
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XMetaPanel.this.deleteRow();
            }
        });
        this.tblFields.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStopped(KDTEditEvent e) {
                if (e.getValue() != null && !e.getValue().equals(e.getOldValue()) || e.getValue() == null && e.getOldValue() != null) {
                    XMetaPanel.this.setChanged(true);
                }
            }
        });
        this.tblFields.getActionMap().remove("Copy");
        this.tblFields.getActionMap().remove("Cut");
        this.tblFields.getActionMap().remove("Paste");
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    private void rowUp() {
        KDTSelectBlock sel = this.tblFields.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == 0) {
            return;
        }
        this.setChanged(true);
        IRow selRow = this.tblFields.removeRow(idx);
        this.tblFields.addRow(idx - 1, selRow);
        this.tblFields.getSelectManager().select(idx - 1, 0);
    }

    private void rowDown() {
        KDTSelectBlock sel = this.tblFields.getSelectManager().get();
        if (sel == null) {
            return;
        }
        int idx = sel.getBeginRow();
        if (idx == this.tblFields.getRowCount() - 1) {
            return;
        }
        this.setChanged(true);
        IRow selRow = this.tblFields.removeRow(idx);
        this.tblFields.addRow(idx + 1, selRow);
        this.tblFields.getSelectManager().select(idx + 1, 0);
    }

    private void insertRow() {
        int idx;
        IRow newRow;
        if (this.tblFields.getSelectManager().get() == null) {
            newRow = this.tblFields.addRow();
            idx = this.tblFields.getRowCount() - 1;
        } else {
            idx = this.tblFields.getSelectManager().get().getBeginRow();
            newRow = this.tblFields.addRow(idx);
        }
        newRow.getCell(2).setValue((Object)DataType.STRING);
        this.tblFields.getEditManager().editCellAt(idx, 0);
    }

    private void deleteRow() {
        KDTSelectBlock sel = this.tblFields.getSelectManager().get();
        if (sel == null) {
            return;
        }
        if (!WindowUtil.msgboxYesNo((Component)((Object)this), (Object)XmetaResource.getString("res_10"), (String)XmetaResource.getString("res_11"))) {
            return;
        }
        this.setChanged(true);
        int selBegin = sel.getBeginRow();
        int selEnd = sel.getEndRow();
        for (int i = selBegin; i <= selEnd; ++i) {
            this.tblFields.removeRow(i);
        }
        this.tblFields.getSelectManager().setActiveRowIndex(selBegin);
    }

    private void initTable() {
        this.tblFields = new KDTable();
        this.tblFields.getSelectManager().setSelectMode(10);
        KDComboBox typeEditor = new KDComboBox();
        for (int i = 0; i < DataType.ALL_TYPES.length; ++i) {
            typeEditor.addItem((Object)DataType.ALL_TYPES[i]);
        }
        KDMultiLangBox mlb = MultiLangUI.newKDMultiLangBox();
        mlb.putClientProperty((Object)"All_Modal", (Object)Boolean.TRUE);
        KDTDefaultCellEditor kdtMlb = new KDTDefaultCellEditor((JComboBox)mlb);
        this.tblFields.addColumns(3);
        this.tblFields.getColumn(0).setWidth(200);
        IColumn col = this.tblFields.getColumn(1);
        col.setWidth(200);
        col.setEditor((ICellEditor)kdtMlb);
        col = this.tblFields.getColumn(2);
        col.setWidth(120);
        col.setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)typeEditor));
        IRow row = this.tblFields.addHeadRow();
        row.getCell(0).setValue((Object)XmetaResource.getString("res_4"));
        row.getCell(1).setValue((Object)XmetaResource.getString("res_5"));
        row.getCell(2).setValue((Object)XmetaResource.getString("res_6"));
    }

    private void addField2Row(MetaField mf) {
        IRow row = this.tblFields.addRow();
        row.getCell(0).setValue((Object)mf.getName());
        row.getCell(2).setValue((Object)mf.getType());
        row.getCell(1).setValue((Object)TableMultiLangUI.toMultiLangItemList(mf.getProperties(), "alias"));
    }

    public MetaClass makeMetaClass() {
        MetaClass mc = new MetaClass();
        String extName = ((DataDefType)this.cbxType.getSelectedItem()).getName();
        mc.setName(FullPath.cutCategory((String)this.txtName.getText()) + "." + extName);
        mc.setType(extName);
        if (this.radFieldsFromBos.isSelected()) {
            mc.setExpr(this.f7Expr.getText());
        }
        MultiLangUI.fromKDMultiLangBox((KDMultiLangBox)this.mlbAlias, (Map)mc.getProperties(), (String)"alias");
        MultiLangUI.fromKDMultiLangBox((KDMultiLangBox)this.mlbDesc, (Map)mc.getProperties(), (String)"desc");
        this.makeFields(mc);
        return mc;
    }

    private void makeFields(MetaClass mc) {
        int z = this.tblFields.getRowCount();
        for (int i = 0; i < z; ++i) {
            MetaField mf = this.makeField(this.tblFields.getRow(i));
            if (mf == null) continue;
            mc.addField(mf);
        }
    }

    private MetaField makeField(IRow row) {
        String fieldName = (String)row.getCell(0).getValue();
        if (fieldName == null || fieldName.trim().length() == 0) {
            return null;
        }
        MetaField mf = new MetaField();
        mf.setName(fieldName.trim());
        mf.setType((DataType)row.getCell(2).getValue());
        TableMultiLangUI.fromKDTableCellValue(row.getCell(1).getValue(), mf.getProperties(), "alias");
        return mf;
    }

    public void setMetaClass(MetaClass metaClass) {
        this.mc = metaClass;
        this.txtName.setText(FullPath.cutCategory((String)this.mc.getName()));
        this.cbxType.setSelectedItem((Object)DataDefType.fromName((String)this.mc.getType()));
        MultiLangUI.toKDMultiLangBox((KDMultiLangBox)this.mlbAlias, (Map)this.mc.getProperties(), (String)"alias");
        MultiLangUI.toKDMultiLangBox((KDMultiLangBox)this.mlbDesc, (Map)this.mc.getProperties(), (String)"desc");
        this.tblFields.removeRows();
        Iterator itr = this.mc.getFields().iterator();
        while (itr.hasNext()) {
            this.addField2Row((MetaField)itr.next());
        }
        boolean isCustom = this.mc.getExpr() == null || !this.mc.getExpr().startsWith("::");
        this.initFieldsFormMode(isCustom);
    }

    private void initFieldsFormMode(boolean isCustom) {
        if (isCustom) {
            this.f7Expr.setText("");
            this.updateFieldsFormMode(true);
            this.radFieldsCustom.setSelected(true);
        } else {
            this.f7Expr.setText(this.mc.getExpr());
            this.updateFieldsFormMode(false);
            this.radFieldsFromBos.setSelected(true);
        }
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        MetaClass mc = new MetaClass();
        mc.setName("TestMC");
        mc.setAlias("Test Meta-Class");
        mc.setType(DataDefType.BOS_QUERY.getName());
        mc.setExpr("bos.query.test");
        mc.setDesc("Test BOS-Query MetaClass");
        MetaField mf = new MetaField();
        mf.setName("TestMC");
        mf.setAlias("Test Meta-Class");
        mf.setType(DataType.STRING);
        mf.setExpr("bos.query.test");
        mf.setDesc("Test BOS-Query MetaClass");
        MetaField mf2 = new MetaField();
        mf2.setName("TestMC2");
        mf2.setAlias("Test Meta-Class 2");
        mf2.setType(DataType.INTEGER);
        mf2.setExpr("bos.query.test2");
        mf2.setDesc("Test BOS-Query MetaClass 2");
        mc.addField(mf);
        mc.addField(mf2);
        XMetaPanel xmp = new XMetaPanel(null);
        xmp.setMetaClass(mc);
        SimpleDialog dlg = new SimpleDialog();
        dlg.setComponent((Component)((Object)xmp));
        dlg.showDialog();
        MetaClass mc2 = xmp.makeMetaClass();
        Element xml = Meta2Xml.makeClass((MetaClass)mc2, null);
        XmlUtil.printElement((Element)xml);
    }

    private void updateFieldsFormMode(boolean isCustom) {
        this.f7Expr.setEnabled(!isCustom);
        this.txtName.setEnabled(isCustom);
        this.mlbAlias.setEnabled(isCustom);
        this.mlbDesc.setEnabled(isCustom);
        this.tblFields.setEnabled(isCustom);
        this.btnUp.setEnabled(isCustom);
        this.btnDown.setEnabled(isCustom);
        this.btnInsert.setEnabled(isCustom);
        this.btnDelete.setEnabled(isCustom);
    }
}

