/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas;

import com.kingdee.bos.ctrl.bizshare.EnumType;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class Eas_ObjectSelectorFilterPanel
extends KDPanel {
    private KDCheckBox cbUseNameFilter;
    private KDTextField txtNameFilter;
    private KDCheckBox cbUseF7Filter;
    private KDCheckBox cbUseAliasFilter;
    private KDTextField txtAliasFilter;
    private KDCheckBox cbUseCategoryFilter;
    private KDTree treeCategoires;
    private FilterModelChangedListener externalListener;
    private FilterModel filterModel;

    public Eas_ObjectSelectorFilterPanel() {
        this.initComponents();
        this.initActionListeners();
    }

    private void initComponents() {
        this.cbUseNameFilter = new KDCheckBox("\u8d44\u6e90\u540d\u5b57\u5339\u914d");
        this.txtNameFilter = new KDTextField();
        this.cbUseF7Filter = new KDCheckBox("\u8fc7\u6ee4\u6389\u540d\u5b57\u4e2d\u5e26'F7'\u7684\u5bf9\u8c61");
        this.cbUseAliasFilter = new KDCheckBox("\u8d44\u6e90\u522b\u540d\u5339\u914d");
        this.txtAliasFilter = new KDTextField();
        this.cbUseCategoryFilter = new KDCheckBox("\u8d44\u6e90\u7c7b\u578b\u5339\u914d");
        this.treeCategoires = new KDTree();
        this.treeCategoires.setShowCheckBox(true);
        this.treeCategoires.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        TableLayout layout = TableLayout.split((int)4, (int)1);
        this.setLayout((LayoutManager)layout);
        layout.style().setMargin(4, 4, 7, 4);
        Table nameArea = layout.cell(0).splitRow(2);
        this.add((Component)this.cbUseNameFilter, nameArea.cell(0));
        this.add((Component)this.txtNameFilter, nameArea.cell(1));
        nameArea.rowStyle(1).setMarginLeft(4);
        Table aliasArea = layout.cell(1).splitRow(2);
        this.add((Component)this.cbUseAliasFilter, aliasArea.cell(0));
        this.add((Component)this.txtAliasFilter, aliasArea.cell(1));
        aliasArea.rowStyle(1).setMarginLeft(4);
        Table typeArea = layout.cell(2).splitRow(2);
        this.add((Component)this.cbUseCategoryFilter, typeArea.cell(0));
        this.add((Component)this.treeCategoires, typeArea.cell(1));
        typeArea.rowStyle(1).setMarginLeft(4);
        typeArea.rowStyle(1).setPriY(1);
        typeArea.rowStyle(1).setMarginBottom(4);
        layout.rowStyle(2).setPriY(1);
        this.add((Component)this.cbUseF7Filter, layout.cell(3));
    }

    private void initActionListeners() {
        KDCheckBox[] checkBoxes = new KDCheckBox[]{this.cbUseCategoryFilter, this.cbUseF7Filter, this.cbUseNameFilter, this.cbUseAliasFilter};
        for (int i = 0; i < checkBoxes.length; ++i) {
            checkBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDCheckBox cb = (KDCheckBox)e.getSource();
                    boolean enable = cb.isSelected();
                    boolean needFire = true;
                    if (cb == Eas_ObjectSelectorFilterPanel.this.cbUseNameFilter) {
                        Eas_ObjectSelectorFilterPanel.this.txtNameFilter.setEnabled(enable);
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filterName = enable;
                        if (StringUtil.isEmptyString((String)Eas_ObjectSelectorFilterPanel.this.txtNameFilter.getText())) {
                            needFire = false;
                        }
                    }
                    if (cb == Eas_ObjectSelectorFilterPanel.this.cbUseAliasFilter) {
                        Eas_ObjectSelectorFilterPanel.this.txtAliasFilter.setEnabled(enable);
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filterAlias = enable;
                        if (StringUtil.isEmptyString((String)Eas_ObjectSelectorFilterPanel.this.txtAliasFilter.getText())) {
                            needFire = false;
                        }
                    }
                    if (cb == Eas_ObjectSelectorFilterPanel.this.cbUseCategoryFilter) {
                        Eas_ObjectSelectorFilterPanel.this.treeCategoires.setEnabled(enable);
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filterCategory = enable;
                    }
                    if (cb == Eas_ObjectSelectorFilterPanel.this.cbUseF7Filter) {
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filterF7 = enable;
                    }
                    if (needFire) {
                        Eas_ObjectSelectorFilterPanel.this.fireFilterModelChanged();
                    }
                }
            });
        }
        KDTextField[] txts = new KDTextField[]{this.txtNameFilter, this.txtAliasFilter};
        for (int i = 0; i < txts.length; ++i) {
            txts[i].addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyReleased(KeyEvent e) {
                    super.keyReleased(e);
                    if (e.getSource() == Eas_ObjectSelectorFilterPanel.this.txtNameFilter) {
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filter_namePattern = ((KDTextField)e.getSource()).getText();
                    } else {
                        ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filter_aliasPattern = ((KDTextField)e.getSource()).getText();
                    }
                    Eas_ObjectSelectorFilterPanel.this.fireFilterModelChanged();
                }
            });
        }
        this.treeCategoires.addTreeNodeStateChangeListener(new TreeNodeStateChangeListener(){

            public void nodeStateChange(TreeNodeStateChangeEvent event) {
                DefaultKingdeeTreeNode[] nodes = TreeUtil.getCheckedNodes((KDTree)Eas_ObjectSelectorFilterPanel.this.treeCategoires);
                EnumType[] tmp = new EnumType[nodes.length];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = (EnumType)nodes[i].getUserObject();
                }
                ((Eas_ObjectSelectorFilterPanel)Eas_ObjectSelectorFilterPanel.this).filterModel.filter_categories = tmp;
                Eas_ObjectSelectorFilterPanel.this.fireFilterModelChanged();
            }
        });
    }

    public void setFilterModelChangedListener(FilterModelChangedListener externalListener) {
        this.externalListener = externalListener;
    }

    public void fireFilterModelChanged() {
        if (this.externalListener != null) {
            this.externalListener.afterModelChanged();
        }
    }

    private boolean findET(EnumType[] ets, EnumType et) {
        for (int i = 0; i < ets.length; ++i) {
            if (ets[i] != et) continue;
            return true;
        }
        return false;
    }

    public void setModel(FilterModel model) {
        this.cbUseNameFilter.setSelected(model.filterName);
        this.txtNameFilter.setEnabled(model.filterName);
        this.txtNameFilter.setText(model.filter_namePattern);
        this.cbUseF7Filter.setSelected(model.filterF7);
        this.cbUseAliasFilter.setSelected(model.filterAlias);
        this.txtAliasFilter.setEnabled(model.filterAlias);
        this.txtAliasFilter.setText(model.filter_aliasPattern);
        this.cbUseCategoryFilter.setSelected(model.filterCategory);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeCategoires.getModel().getRoot();
        this.treeCategoires.removeAllChildrenFromParent((MutableTreeNode)root);
        if (model.categories != null) {
            for (int i = 0; i < model.categories.length; ++i) {
                DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)model.categories[i]);
                node.setText(model.categories[i].getAlias());
                node.setCheckBoxEnabled(true);
                node.setCustomIcon((Icon)NonIcon.getInstance());
                if (this.findET(model.filter_categories, model.categories[i])) {
                    node.setChecked(true);
                }
                this.treeCategoires.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)root, i);
            }
            this.treeCategoires.expandAllNodes(true, (TreeNode)root);
            this.treeCategoires.setRootVisible(false);
        }
        this.treeCategoires.setEnabled(model.filterCategory);
        this.filterModel = model;
    }

    public FilterModel getModel() {
        return this.filterModel;
    }

    public static class FilterModel
    implements Serializable {
        public boolean filterName;
        public String filter_namePattern;
        public boolean filterAlias;
        public String filter_aliasPattern;
        public boolean filterF7;
        public boolean filterCategory;
        public EnumType[] categories;
        public EnumType[] filter_categories;
    }

    public static interface FilterModelChangedListener {
        public void afterModelChanged();
    }
}

