/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.restree.ResObjectNode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ImportExportDialog;
import com.kingdee.bos.ctrl.reportone.forapp.eas.maintenance.ZipSpaceProvider;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.BizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.storage.BizStorageTreeCtrl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class ImportExportUI
extends KDPanel {
    public static final Logger log = LogUtil.getPackageLogger(ImportExportUI.class);
    public static final String START_PATH = "/EAS_Report.kdrs";
    private boolean isImport;
    private FileSelectorPanel selector;
    private TreeUI treeUI;
    private Cell treeUICell;
    private Cell labelCell;
    private IBizContent bizContent;

    public ImportExportUI(boolean isImport) {
        this.isImport = isImport;
        this.initCtrls();
    }

    void initCtrls() {
        this.selector = new FileSelectorPanel();
        this.treeUI = new TreeUI();
        TableLayout layout = TableLayout.splitRow((int)3);
        this.setLayout((LayoutManager)layout);
        KDLabelContainer lbc = new KDLabelContainer();
        lbc.setBoundEditor((JComponent)((Object)this.selector));
        lbc.setBoundLabelText(this.isImport ? "\u6307\u5b9a\u6e90\u6587\u4ef6" : "\u6307\u5b9a\u5bfc\u51fa\u76ee\u6807\u6587\u4ef6");
        lbc.setBoundLabelLength(this.isImport ? 100 : 140);
        lbc.setBoundLabelUnderline(true);
        if (this.isImport) {
            this.add((Component)lbc, layout.cell(0));
            this.labelCell = layout.cell(1);
            this.treeUICell = layout.cell(2);
            layout.rowStyle(0).setMarginBottom(6);
            layout.rowStyle(1).setMarginBottom(3);
            layout.rowStyle(2).setPriY(1);
        } else {
            this.add((Component)new KDLabel("\u9009\u62e9\u8981\u5bfc\u51fa\u7684\u8d44\u6e90:"), layout.cell(0));
            this.add((Component)this.treeUI, layout.cell(1));
            this.add((Component)lbc, layout.cell(2));
            layout.rowStyle(0).setMarginBottom(3);
            layout.rowStyle(1).setMarginBottom(6);
            layout.rowStyle(1).setPriY(1);
        }
    }

    public void setSource(IBizContent bizContent) {
        if (this.treeUICell != null) {
            this.add((Component)new KDLabel("\u9009\u62e9\u8981\u5bfc\u5165\u7684\u8d44\u6e90:"), this.labelCell);
            this.add((Component)this.treeUI, this.treeUICell);
            this.validate();
            this.repaint();
            this.treeUICell = null;
            this.labelCell = null;
        }
        BizContentTreeCtrl ctrl = new BizContentTreeCtrl(BizStorageTreeCtrl.loadTypeDefs(ZipSpaceProvider.class, "content_restree.xml"), bizContent, null);
        ctrl.setEnableMenus(false);
        ctrl.setBizStorage(bizContent);
        ctrl.initTreeUI(this.treeUI);
        this.treeUI.setRealtimeSelect(true);
        this.treeUI.setSelectionPathText(START_PATH);
        TreeUINode oldRoot = this.treeUI.getRootNode();
        TreeUINode newRoot = this.treeUI.getSelectionNode();
        newRoot.setHook(oldRoot.getHook());
        newRoot.setParent(null);
        this.treeUI.setRootNode(newRoot);
        ctrl.setRelativeRoot(START_PATH);
        this.treeUI.expandRoot();
        this.treeUI.setSelectionNode(newRoot);
        KDTree tree = this.treeUI.getTree();
        tree.setShowsRootHandles(false);
        tree.setShowCheckBox(true);
        tree.setSyncChecked(true);
        this.bizContent = bizContent;
    }

    public String[] getPathx() {
        ArrayList<String> list = new ArrayList<String>();
        TreeModel model = this.treeUI.getTree().getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)model.getRoot();
        Enumeration e = root.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            ResObjectNode node = (ResObjectNode)e.nextElement();
            if (!node.isChecked()) continue;
            list.add(node.getResPath());
        }
        String[] pathx = new String[list.size()];
        Arrays.sort(list.toArray(pathx));
        return pathx;
    }

    public File getFile() {
        return new File(this.selector.txtField.getText());
    }

    public final IBizContent getSource() {
        return this.bizContent;
    }

    class FileSelectorPanel
    extends KDPanel {
        KDTextField txtField = new KDTextField();

        FileSelectorPanel() {
            KDWorkButton btSelector = new KDWorkButton("\u9009\u62e9");
            TableLayout layout = TableLayout.splitCol((int)2);
            this.setLayout((LayoutManager)layout);
            this.add((Component)this.txtField, layout.cell(0));
            this.add((Component)btSelector, layout.cell(1));
            layout.colStyle(0).setPriX(1);
            layout.colStyle(1).setMarginLeft(3);
            layout.colStyle(1).setWidth(60);
            this.txtField.setEditable(false);
            btSelector.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KDFileChooser chooser = new KDFileChooser();
                    FileFilter[] ff = chooser.getChoosableFileFilters();
                    for (int i = 0; i < ff.length; ++i) {
                        chooser.removeChoosableFileFilter(ff[i]);
                    }
                    chooser.setFileFilter(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            return "kdrs".equals(CtrlUtil.File.getExtension((File)f)) || !f.isFile();
                        }

                        @Override
                        public String getDescription() {
                            return "*.kdrs";
                        }
                    });
                    int r = ImportExportUI.this.isImport ? chooser.showOpenDialog((Component)((Object)ImportExportUI.this)) : chooser.showSaveDialog((Component)((Object)ImportExportUI.this));
                    if (r == 0) {
                        String filePath = chooser.getSelectedFile().getAbsolutePath();
                        try {
                            if (ImportExportUI.this.isImport) {
                                IBizContent bizCnt = ImportExportDialog.makeLocalContent(new File(filePath));
                                ImportExportUI.this.setSource(bizCnt);
                            } else {
                                if (!"kdrs".equals(CtrlUtil.File.getExtension((String)filePath))) {
                                    filePath = filePath + ".kdrs";
                                }
                                CtrlUtil.File.createFile((String)filePath);
                            }
                            FileSelectorPanel.this.txtField.setText(filePath);
                        }
                        catch (Exception ex) {
                            log.error((Object)"\u9009\u62e9\u6587\u4ef6\u5931\u8d25", (Throwable)ex);
                            if (ex instanceof IOException || ex instanceof KDRSException) {
                                WindowUtil.msgboxError((Object)"\u60a8\u9009\u62e9\u7684\u6587\u4ef6\u4e0d\u662f\u6b63\u786e\u7684\u5bfc\u51fa\u683c\u5f0f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u4e00\u4e2a\u3002", (String)"\u9009\u62e9\u6587\u4ef6", (Component)((Object)ImportExportUI.this));
                            }
                            WindowUtil.showException((String)"\u9009\u62e9\u6587\u4ef6\u9519\u8bef", (Throwable)ex, (String)"\u9009\u62e9\u6587\u4ef6", (Component)((Object)ImportExportUI.this));
                        }
                    }
                }
            });
        }
    }
}

