/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.meta;

import com.kingdee.bos.ctrl.common.FullPath;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaPackage;
import com.kingdee.bos.ctrl.reportone.data.framework.bos.BosUtil;
import com.kingdee.bos.ctrl.reportone.data.meta.io.Bmd2Meta;
import com.kingdee.bos.ctrl.reportone.forapp.eas.meta.Eas_MetaClass;
import com.kingdee.bos.ctrl.reportone.forapp.eas.meta.Eas_MetaEnv;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;

public class Eas_MetaPackage
extends MetaPackage {
    private Eas_MetaEnv env;
    private IBriefViewTreeNode bmdNode;

    public Eas_MetaPackage(Eas_MetaEnv data) {
        this.env = data;
    }

    public final IBriefViewTreeNode getBmdNode() {
        return this.bmdNode;
    }

    public final void setBmdNode(IBriefViewTreeNode bmdNode) {
        this.bmdNode = bmdNode;
    }

    protected void init() {
        super.init();
        if (this.env.getBizContent() != null) {
            this.initKdrs();
        }
        if (this.bmdNode != null) {
            this.initBmd();
        }
    }

    private void initKdrs() {
        HashMap attrs;
        String resPath = this.env.makeResPath(this.getFullName());
        try {
            attrs = this.env.getBizContent().list(resPath, Eas_MetaEnv.LIST_ATTRS);
        }
        catch (KDRSException e) {
            e.printStackTrace();
            return;
        }
        String[] names = (String[])attrs.get("name");
        String[] alias = (String[])attrs.get("alias");
        String[] types = (String[])attrs.get("type");
        INodeFilter filter = this.env.getNodeFilter();
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            String category = FullPath.getCategory((String)name);
            if (category != null) {
                if (filter != null && !filter.isVisibleCategory((Object)category)) continue;
                Eas_MetaClass mc = new Eas_MetaClass(this.env);
                mc.setNamex(FullPath.cutCategory((String)name, (String)category), category);
                mc.setAlias(alias[i]);
                this.addClass(mc);
                continue;
            }
            if (!StorageCategory.FOLDER.getName().equals(types[i])) continue;
            Eas_MetaPackage mp = new Eas_MetaPackage(this.env);
            mp.setName(names[i]);
            mp.setAlias(alias[i]);
            this.addPackage(mp);
        }
    }

    private void initBmd() {
        INodeFilter filter = this.env.getNodeFilter();
        int z = this.bmdNode.getChildCount();
        for (int i = 0; i < z; ++i) {
            String category;
            IBriefViewTreeNode childNode = (IBriefViewTreeNode)this.bmdNode.getChildAt(i);
            BOSObjectType bosObjType = childNode.getMetaDataType();
            if (childNode.isPackage()) {
                Eas_MetaPackage mp = (Eas_MetaPackage)this.getPackage(childNode.getName());
                if (mp == null) {
                    mp = new Eas_MetaPackage(this.env);
                    mp.setName(childNode.getName());
                    mp.setAlias(childNode.getAlias());
                    this.addPackage(mp);
                }
                mp.setBmdNode(childNode);
                continue;
            }
            if (bosObjType != MetaDataTypeList.JOINQUERY && bosObjType != MetaDataTypeList.UNIONQUERY && bosObjType != MetaDataTypeList.DATATABLE && bosObjType != MetaDataTypeList.ENTITY || filter != null && !filter.isVisibleCategory((Object)(category = Bmd2Meta.toDataDefType(bosObjType).getName()))) continue;
            Eas_MetaClass mc = new Eas_MetaClass(this.env);
            Bmd2Meta.parseBriefClass(childNode, mc);
            mc.setBmdNode(childNode);
            this.addClass(mc);
        }
    }

    public MetaClass findClass(String clsPath) {
        BOSObjectType bosType;
        MetaClass mc = super.findClass(clsPath);
        if (mc == null && (bosType = Bmd2Meta.toBOSObjectType(FullPath.getCategory((String)clsPath))) != null) {
            FullPath fp = FullPath.parse((String)clsPath);
            IObjectValue bosObj = BosUtil.getMetaDataLoader().get(bosType, (IMetaDataPK)new MetaDataPK(fp.getDots()));
            return Bmd2Meta.parseBmdObject(bosObj);
        }
        return mc;
    }
}

