/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.forapp.eas.perm;

import com.kingdee.bos.ctrl.common.ui.tree.TreeUI;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUINode;
import com.kingdee.bos.ctrl.common.ui.tree.TreeUtil;
import com.kingdee.bos.ctrl.reportone.forapp.kdrs.content.ui.ClassicBizContentTreeCtrl;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.ContentCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.content.IBizContent;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.eas.basedata.org.OrgType;
import java.util.HashMap;
import java.util.List;
import javax.swing.tree.TreePath;

public class ReportTreeCtrl
extends ClassicBizContentTreeCtrl {
    private TreeUI treeUI = this.getTreeUI();
    private List visiableOrgTypes;

    public ReportTreeCtrl(IBizContent bizContent) {
        super(bizContent);
        this.treeUI.getTree().setShowCheckBox(true);
        this.setRelativeRoot("/EAS_Report.kdrs");
        this.treeUI.expandRoot();
        this.treeUI.getRootNode().setCheckBoxVisible(false);
    }

    public void setVisiableOrgTypes(List orgTypes) {
        this.visiableOrgTypes = orgTypes;
    }

    @Override
    protected void initPopupMenu() {
    }

    @Override
    protected boolean initNode(TreePath treePath) throws Exception {
        TreeUINode node = (TreeUINode)treePath.getLastPathComponent();
        String pathText = this.makePathText(treePath);
        this.initFolderNode(pathText, node);
        return true;
    }

    public String[] getSelectedReportIds() {
        DefaultKingdeeTreeNode[] nodes = TreeUtil.getCheckedNodes((KDTree)this.getTreeUI().getTree());
        String[] ids = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            ids[i] = (String)nodes[i].getUserObject();
        }
        return ids;
    }

    private void initFolderNode(String pathText, TreeUINode node) throws Exception {
        HashMap attr_keys = (HashMap)LIST_ATTRS.clone();
        attr_keys.put("eas-report-id", null);
        attr_keys.put("easOrgType", null);
        HashMap rv = this.getBizContent().list(pathText, attr_keys);
        node.setUserObject((Object)rv);
        String[] names = (String[])rv.get("name");
        String[] alias = (String[])rv.get("alias");
        String[] categories = (String[])rv.get("category");
        String[] rptIds = (String[])rv.get("eas-report-id");
        String[] rptOrgTypes = (String[])rv.get("easOrgType");
        for (int i = 0; i < names.length; ++i) {
            if (categories[i] == null) continue;
            Object category = null;
            boolean isFolder = false;
            if ("folder".equals(categories[i])) {
                category = StorageCategory.FOLDER;
                isFolder = true;
            } else {
                OrgType orgType;
                category = ContentCategory.fromName(categories[i]);
                if (category == null || !"r1-form".equals(categories[i]) && !"r1-argui".equals(categories[i]) || rptIds[i] == null || this.visiableOrgTypes != null && ((orgType = OrgType.getEnum((String)rptOrgTypes[i])) == null || !this.visiableOrgTypes.contains(orgType))) continue;
            }
            TreeUINode tcnSub = this.newTreeNode(category, names[i], alias[i], isFolder);
            tcnSub.setCustomIcon(super.getCategoryIcon(category));
            if (category == StorageCategory.FOLDER) {
                tcnSub.setCheckBoxVisible(false);
            } else {
                tcnSub.setUserObject((Object)rptIds[i]);
            }
            this.treeUI.addChildNode(tcnSub, node);
        }
    }
}

