/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.kdrs.biz.storage;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.PathUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.KdrsResource;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.BizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.IBizStorage;
import com.kingdee.bos.ctrl.reportone.kdrs.biz.storage.StorageCategory;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyExistsException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.kdrs.storage.fs.FSStorage;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BizStorageUtil {
    private static Logger log = LogUtil.getPackageLogger(BizStorageUtil.class);
    public static final int MAX_BLOCK_SIZE = 65536;
    public static final HashMap SET_FOLDER_TYPE = new HashMap();
    public static final HashMap SET_FILE_TYPE = new HashMap();
    public static final HashMap LIST_NAME_TYPE = new HashMap();
    public static final HashMap LIST_NAME = new HashMap();
    public static final IResourceCreator OVERWRITE_EXIST;
    public static final IResourceCreator SKIP_EXIST;

    public static void create(IBizStorage sto, String pathText, HashMap atts) throws KDRSException {
        Object policy = atts.get("create_policy");
        if (policy == null) {
            atts.put("create_policy", String.valueOf(16));
        }
        sto.create(pathText, atts);
        if (policy == null) {
            atts.remove("create_policy");
        }
    }

    public static byte[] readFile(IBizStorage sto, String pathText) throws KDRSException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        int offset = 0;
        while (true) {
            byte[] data = sto.readFile(pathText, offset, 65536);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readFile(" + offset + ", " + 65536 + "); return " + data.length));
            }
            try {
                buf.write(data);
            }
            catch (IOException ex) {
                throw KDRSException.makeException(KdrsResource.getString("res_17"), ex);
            }
            if (data.length < 65536) break;
            offset += data.length;
        }
        return buf.toByteArray();
    }

    public static void writeFile(IBizStorage sto, String pathText, byte[] data) throws KDRSException {
        sto.writeFile(pathText, -1, data);
    }

    public static IBizStorage newFileStorage(String rootPath) throws KDRSException {
        return new BizStorage(new FSStorage(rootPath));
    }

    public static void outputPath(IBizStorage sto, String path, String type, OutputStream out) throws IOException {
        if ("Folder".equals(type)) {
            try {
                HashMap rv = sto.list(path, LIST_NAME_TYPE);
                String[] names = (String[])rv.get("name");
                String[] types = (String[])rv.get("type");
                out.write(("path:" + path + ", type:" + type + ", children:" + names.length + "\r\n").getBytes());
                for (int i = 0; i < names.length; ++i) {
                    String childPath = PathUtil.makeChildPath((String)path, (String)names[i]);
                    BizStorageUtil.outputPath(sto, childPath, types[i], out);
                }
            }
            catch (KDRSException ex) {
                ex.printStackTrace();
                throw new IOException("call failed!");
            }
        } else {
            out.write(("path:" + path + ", type:" + type + "\r\n").getBytes());
        }
    }

    public static void copyFile(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
        int offset = 0;
        while (true) {
            byte[] data = fromSto.readFile(fromPath, offset, 65536);
            if (log.isDebugEnabled()) {
                log.debug((Object)("readFile(" + offset + ", " + 65536 + "); return " + data.length));
            }
            toSto.writeFile(toPath, offset == 0 ? -1 : offset, data);
            if (data.length < 65536) break;
            offset += data.length;
        }
    }

    public static void copyFolder(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, IResourceCreator creator) throws KDRSException {
        HashMap rv = fromSto.list(fromPath, LIST_NAME);
        String[] names = (String[])rv.get("name");
        for (int i = 0; i < names.length; ++i) {
            String childName = names[i];
            String fromChild = PathUtil.makeChildPath((String)fromPath, (String)childName);
            String toChild = PathUtil.makeChildPath((String)toPath, (String)childName);
            BizStorageUtil.copy(fromSto, fromChild, toSto, toChild, creator);
        }
    }

    public static HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, int createPolicy) throws KDRSException {
        HashMap atts = fromSto.getAttributes(fromPath, null);
        atts.remove("name");
        atts.remove("size");
        atts.remove("time");
        atts.remove("creator");
        atts.remove("last-access");
        atts.remove("last-modified");
        atts.remove("eas-report-id");
        atts.remove("eas-menu-pk");
        atts.remove("eas_template_relation_orgs");
        if (1 != createPolicy) {
            atts.put("create_policy", new Integer(createPolicy));
        }
        toSto.create(toPath, atts);
        return atts;
    }

    public static void copy(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath, IResourceCreator creator) throws KDRSException {
        HashMap atts;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Copy " + fromPath + " -> " + toPath));
        }
        if ((atts = creator.create(fromSto, fromPath, toSto, toPath)) == null) {
            return;
        }
        String type = (String)atts.get("type");
        if (StorageCategory.FILE.getName().equals(type)) {
            BizStorageUtil.copyFile(fromSto, fromPath, toSto, toPath);
        } else {
            BizStorageUtil.copyFolder(fromSto, fromPath, toSto, toPath, creator);
        }
    }

    public static Object getAttribute(IBizStorage bizSto, String pathText, String attrName) throws KDRSException {
        String[] keys = new String[]{attrName};
        HashMap attrs = bizSto.getAttributes(pathText, keys);
        return attrs.get(attrName);
    }

    public static void setAttribute(IBizStorage bizSto, String pathText, String attrName, String attrVal) throws KDRSException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(attrName, attrVal);
        bizSto.setAttributes(pathText, attrs);
    }

    static {
        SET_FOLDER_TYPE.put("type", StorageCategory.FOLDER.getName());
        SET_FILE_TYPE.put("type", StorageCategory.FILE.getName());
        LIST_NAME_TYPE.put("name", null);
        LIST_NAME_TYPE.put("type", null);
        LIST_NAME.put("name", null);
        OVERWRITE_EXIST = new IResourceCreator(){

            @Override
            public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
                return BizStorageUtil.create(fromSto, fromPath, toSto, toPath, 16);
            }
        };
        SKIP_EXIST = new IResourceCreator(){

            @Override
            public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
                try {
                    return BizStorageUtil.create(fromSto, fromPath, toSto, toPath, 2);
                }
                catch (AlreadyExistsException ex) {
                    return null;
                }
            }
        };
    }

    public static class PromptExist
    implements IResourceCreator {
        private Component owner;
        private String title;

        public PromptExist(Component owner, String title) {
            this.owner = owner;
            this.title = title;
        }

        @Override
        public HashMap create(IBizStorage fromSto, String fromPath, IBizStorage toSto, String toPath) throws KDRSException {
            try {
                return BizStorageUtil.create(fromSto, fromPath, toSto, toPath, 2);
            }
            catch (AlreadyExistsException ex) {
                switch (WindowUtil.msgboxYesNoCancel((Component)this.owner, (Object)(toPath + KdrsResource.getString("res_18")), (String)this.title)) {
                    case 1: {
                        return null;
                    }
                    case 2: {
                        throw new UserCancelException();
                    }
                }
                return BizStorageUtil.create(fromSto, fromPath, toSto, toPath, 16);
            }
        }
    }

    public static interface IResourceCreator {
        public HashMap create(IBizStorage var1, String var2, IBizStorage var3, String var4) throws KDRSException;
    }

    public static class CopyPathFilter
    extends APathFilter {
        private HashMap paths;

        public CopyPathFilter(HashMap paths) {
            this.paths = paths;
        }

        @Override
        boolean copy(String fromPath, String toPath) {
            if (this.paths.containsKey(fromPath)) {
                this.paths.put(fromPath, toPath);
                return true;
            }
            return false;
        }
    }

    public static abstract class APathFilter {
        boolean copy(String fromPath, String toPath) {
            return false;
        }
    }
}

