/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IElement;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.ReportObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.EditorEvent;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.event.EditorListener;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.IReportUI;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard.IR1Clipboard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard.R1Clipboard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.clipboard.StyleClipboard;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.DataTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.IKeyboardOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PopupMenuManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.StructureTree;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.Toolbox;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClick;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IDoubleClickEditor;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.editor.IScroll;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.IMouseOperate;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.mouseoperate.MouseOperateState;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.DefaultPropertyPanelProvider;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.IPropertyPanelProvider;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.HRuler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.IR1Ruler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.RulerMark;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.ruler.VRuler;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.undo.UndoHelper;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.IR1Page;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportSelectionModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlReaderWriterFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.IR1XmlWriter;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.operate.OperatingRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.selection.SelectionRenderer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.ContainerUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.IConfigFileCreator;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ComboPanel
implements IReportUI {
    public static final String PROPERTY_TITLE = "title";
    private KDPanel _panel;
    private EventListenerList _listenerList = new EventListenerList();
    private KDSplitPane _sppDivider;
    private KDTabbedPane _tabNavigation;
    private Toolbox _toolbox;
    private DataTree _dataTree;
    private StructureTree _structureTree;
    private KDPanel _panContainRuler;
    private PageContainer _pageContainer;
    private KDScrollPane _scrollPane;
    private IR1Ruler _hRuler;
    private IR1Ruler _vRuler;
    private LazyStyleDesigner _styleDlg;
    private String _title;
    private ReportModel _model;
    private MouseOperateState _state = new MouseOperateState();
    private IPropertyPanelProvider _propertyPanelProvider;
    private ReportObjectFactory _objectFactory = new ReportObjectFactory();
    private ModelInnerChangeHandler _modelInnerChangeHandler = new ModelInnerChangeHandler();
    private UndoHelper _undoHelper;
    private IObjectSelector _dataSelector;
    private MetaClass _systemParams;
    private IR1XmlReaderWriterFactory _xmlReaderWriterFactory;
    private IConfigFileCreator _popupMenuConfigCreator;
    private IR1Clipboard _clipboard;
    private StyleClipboard _styleClipboard;
    private double scale = 1.0;

    public ComboPanel() {
        this.init();
    }

    public KDPanel getPanel() {
        if (this._panel == null) {
            this._panel = new KDPanel((LayoutManager)new BorderLayout());
            this._panel.add((Component)this._sppDivider, (Object)"Center");
        }
        return this._panel;
    }

    private void init() {
        this.initComponent();
        this.installListener();
    }

    private void initComponent() {
        this._panContainRuler = new KDPanel((LayoutManager)new BorderLayout());
        this._pageContainer = new PageContainer(this);
        this._scrollPane = new KDScrollPane((Component)this._pageContainer);
        this._scrollPane.setBorder(null);
        this._hRuler = new HRuler(this);
        this._vRuler = new VRuler(this);
        this._hRuler.setZeroOffset(this._pageContainer.getPaperPos().x);
        this._vRuler.setZeroOffset(this._pageContainer.getPaperPos().y);
        KDLabel labTemp = new KDLabel(){

            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.BLACK);
                g.drawLine(this.getWidth() - 1, this.getHeight() - 1, this.getWidth() - 1, this.getHeight() - 1);
            }
        };
        labTemp.setOpaque(true);
        labTemp.setBackground(Color.WHITE);
        labTemp.setPreferredSize(new Dimension(20, 20));
        KDPanel panHRuler = new KDPanel((LayoutManager)new BorderLayout());
        panHRuler.add((Component)labTemp, (Object)"West");
        panHRuler.add((Component)this._hRuler.getCtrl(), (Object)"Center");
        this._vRuler.getCtrl().setPreferredSize(new Dimension(20, 20));
        this._panContainRuler.add((Component)panHRuler, (Object)"North");
        this._panContainRuler.add((Component)this._vRuler.getCtrl(), (Object)"West");
        this._panContainRuler.add((Component)this._scrollPane, (Object)"Center");
        this._sppDivider = new KDSplitPane(1);
        this._toolbox = new Toolbox(this._objectFactory);
        this._tabNavigation = new KDTabbedPane();
        this._tabNavigation.setForcedHide(true);
        KDPanel panToolbox = this._toolbox.getPanel();
        panToolbox.setPreferredSize(new Dimension(36, 100));
        panToolbox.setMinimumSize(new Dimension(0, 0));
        KDSplitPane sppTemp = new KDSplitPane(1);
        sppTemp.setDividerLocation(60);
        sppTemp.setLeftComponent((Component)panToolbox);
        sppTemp.setRightComponent((Component)this._panContainRuler);
        this._sppDivider.setLeftComponent((Component)this._tabNavigation);
        this._sppDivider.setRightComponent((Component)sppTemp);
        this._sppDivider.setDividerLocation(220);
        this._structureTree = new StructureTree(this);
        this._tabNavigation.addTab(MultiLanguageUtil.getMLS("core.ComboPanel.report", ""), (Component)this._structureTree.getCtrl());
        this._dataTree = new DataTree(this);
        JComponent dataCtrl = this._dataTree.getCtrl();
        this._tabNavigation.addTab(MultiLanguageUtil.getMLS("core.ComboPanel.data", ""), (Component)dataCtrl);
    }

    private void installListener() {
        ScaledMouseHandler mouseHandler = new ScaledMouseHandler();
        this._pageContainer.addMouseListener(mouseHandler);
        this._pageContainer.addMouseMotionListener(mouseHandler);
        this._toolbox.setButtonSelectedChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ComboPanel.this._toolbox.updateMouseOperateState(ComboPanel.this._state);
            }
        });
        this._scrollPane.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ComboPanel.this._hRuler.setScrollOffset(e.getValue());
                ComboPanel.this._hRuler.getCtrl().repaint();
                ComboPanel.this._pageContainer.repaint();
            }
        });
        this._scrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                ComboPanel.this._vRuler.setScrollOffset(e.getValue());
                ComboPanel.this._vRuler.getCtrl().repaint();
            }
        });
    }

    @Override
    public ReportModel getModel() {
        return this._model;
    }

    public void setModel(ReportModel model) {
        if (this._model != model) {
            this._model = model;
            this._model.getDataManager().setSystemParams(this._systemParams);
            this._model.addChangeListener(this._modelInnerChangeHandler);
            this._model.updateFieldInfo();
            this._pageContainer.removeAll();
            this._pageContainer.setCurrentPage(this._model.getPage());
            this._pageContainer.setDataManager(this._model.getDataManager());
            this._structureTree.update();
            this.setSelection(new ElementPath(this._model.getPage()));
            this._dataTree.update();
            this._model.setDirty(false);
        }
    }

    public PageContainer getPageContainer() {
        return this._pageContainer;
    }

    public ReportSelectionModel getSelectionModel() {
        return this._pageContainer.getSelectionModel();
    }

    public void setSelection(ElementPath elementPath) {
        this._pageContainer.getSelectionModel().set(elementPath);
        this._structureTree.selectNode();
        this.fireSelectionChangeListener();
        this.syncRulerMark();
    }

    public void setSelection(ElementPath[] elementPaths) {
        this._pageContainer.getSelectionModel().set(elementPaths);
        this._structureTree.selectNode();
        this.fireSelectionChangeListener();
        this.syncRulerMark();
    }

    private void addSelection(ElementPath elementPath) {
        this._pageContainer.getSelectionModel().add(elementPath);
        this._structureTree.selectNode();
        this.fireSelectionChangeListener();
        this.syncRulerMark();
    }

    private void addSelection(ElementPath[] elementPaths) {
        this._pageContainer.getSelectionModel().add(elementPaths);
        this._structureTree.selectNode();
        this.fireSelectionChangeListener();
        this.syncRulerMark();
    }

    private void syncRulerMark() {
        ElementPath ep;
        IReportObject ro;
        Rectangle rect = null;
        if (this._pageContainer.getSelectionModel().size() == 1 && !((ro = (IReportObject)(ep = this._pageContainer.getSelectionModel().getCurrent()).getRootPathComponent()) instanceof IR1Page)) {
            IElement ele = (IElement)ep.getLastPathComponent();
            Point roAtPage = ContainerUtil.getPointAtPage(ro);
            if (ro instanceof ICompositeObject && ele != ro) {
                ICompositeObject co = (ICompositeObject)((Object)ro);
                rect = co.getSubElementRectangle(ele);
                rect.translate(roAtPage.x, roAtPage.y);
            } else {
                rect = ro.getRectAtPage();
            }
        }
        RulerMark hRulerMark = null;
        RulerMark vRulerMark = null;
        if (rect != null) {
            hRulerMark = RulerMark.createHorizontal(rect);
            vRulerMark = RulerMark.createVertical(rect);
        }
        this._hRuler.setMarkPosition(hRulerMark);
        this._vRuler.setMarkPosition(vRulerMark);
    }

    public void deleteSelection() {
        this.storeUndoState(MultiLanguageUtil.getMLS("core.ComboPanel.delete", ""));
        ReportSelectionModel selectionModel = this._pageContainer.getSelectionModel();
        ElementPath parent = null;
        for (int i = selectionModel.size() - 1; i >= 0; --i) {
            ElementPath ep = selectionModel.get(i);
            IReportObject roToDel = (IReportObject)ep.getRootPathComponent();
            if (roToDel instanceof IR1Page) {
                return;
            }
            ElementPath tempParent = this.deleteElement(ep);
            if (tempParent == null) continue;
            selectionModel.remove(ep);
            if (parent != null) continue;
            parent = tempParent;
        }
        this.afterDeleteElement(parent);
    }

    public void deleteAppointed(ElementPath ep) {
        ElementPath newEp = this.deleteElement(ep);
        this.afterDeleteElement(newEp);
    }

    private ElementPath deleteElement(ElementPath ep) {
        boolean isDeleted;
        IReportObject roToDel = (IReportObject)ep.getRootPathComponent();
        if (roToDel instanceof IR1Page) {
            return null;
        }
        IElement ele = (IElement)ep.getLastPathComponent();
        ElementPath tempParent = null;
        if (ele instanceof IReportObject) {
            tempParent = ((IReportObject)ele).getParent();
            isDeleted = this.getModel().removeReportObject((IReportObject)ele);
        } else {
            tempParent = new ElementPath(roToDel);
            isDeleted = this.getModel().removeElement((ICompositeObject)((Object)roToDel), ele);
        }
        if (isDeleted) {
            return tempParent;
        }
        if (ele instanceof IKeyboardOperate) {
            ((IKeyboardOperate)((Object)ele)).keyboardDeletePressed();
        }
        return null;
    }

    private void afterDeleteElement(ElementPath newSelection) {
        if (newSelection != null) {
            if (newSelection.getLastPathComponent() instanceof ICompositeObject) {
                this.updateTreeNode((IReportObject)newSelection.getLastPathComponent());
            }
            this.setSelection(newSelection);
            IReportObject temp = (IReportObject)newSelection.getRootPathComponent();
            ContainerUtil.layoutChildren(temp);
        }
        this._state.setOperate(0);
        this._pageContainer.repaint();
    }

    private void removeSelection(ElementPath elementPath) {
        this._pageContainer.getSelectionModel().remove(elementPath);
        this.fireSelectionChangeListener();
    }

    public void setPropertyPanelProvier(IPropertyPanelProvider provider) {
        this._propertyPanelProvider = provider;
    }

    public IPropertyPanelProvider getPropertyPanelProvider() {
        if (this._propertyPanelProvider == null) {
            this._propertyPanelProvider = new DefaultPropertyPanelProvider();
        }
        return this._propertyPanelProvider;
    }

    public void updateTreeNode(IReportObject ro) {
        this._structureTree.updateNode(ro);
    }

    private void removeScrollBar(Object ele) {
        block8: {
            block7: {
                if (ele instanceof IScroll) {
                    IScroll scr = (IScroll)ele;
                    if (scr.getHScrollBar() != null) {
                        this._pageContainer.remove((Component)scr.getHScrollBar().getCtrl());
                    }
                    if (scr.getVScrollBar() != null) {
                        this._pageContainer.remove((Component)scr.getVScrollBar().getCtrl());
                    }
                }
                if (!(ele instanceof IContainer)) break block7;
                IContainer ctn = (IContainer)ele;
                if (ctn.getChildrenCount() <= 0) break block8;
                Iterator it = ctn.getChildren().iterator();
                while (it.hasNext()) {
                    this.removeScrollBar((IReportObject)it.next());
                }
                break block8;
            }
            if (ele instanceof ICompositeContainer) {
                IContainer[] ctns = ((ICompositeContainer)ele).getSubContainers();
                for (int i = 0; i < ctns.length; ++i) {
                    if (ctns[i].getChildrenCount() <= 0) continue;
                    Iterator it = ctns[i].getChildren().iterator();
                    while (it.hasNext()) {
                        this.removeScrollBar((IReportObject)it.next());
                    }
                }
            }
        }
    }

    private void showNavigationData() {
        if (this._dataTree.getCtrl() != this._tabNavigation.getSelectedComponent()) {
            this._tabNavigation.setSelectedComponent((Component)this._dataTree.getCtrl());
        }
    }

    public void addSelectionChangeListener(ChangeListener l) {
        this._listenerList.add(ChangeListener.class, l);
    }

    public void removeSelectionChangeListener(ChangeListener l) {
        this._listenerList.remove(ChangeListener.class, l);
    }

    protected void fireSelectionChangeListener() {
        Object[] lst = this._listenerList.getListenerList();
        ChangeEvent evt = null;
        for (int i = lst.length - 2; i >= 0; i -= 2) {
            if (lst[i] != ChangeListener.class) continue;
            if (evt == null) {
                evt = new ChangeEvent(this);
            }
            ((ChangeListener)lst[i + 1]).stateChanged(evt);
        }
    }

    @Override
    public void setTitle(String title) {
        this._title = title;
        this.fireChangeEvent(PROPERTY_TITLE, null, this.getModel().isDirty());
    }

    public String getTitle() {
        return this._title;
    }

    public Toolbox getToolBox() {
        return this._toolbox;
    }

    public List getXmlTransChain() {
        return this._objectFactory.getXmlTransTrain();
    }

    public void setXmlReaderWriterFactory(IR1XmlReaderWriterFactory factory) {
        this._xmlReaderWriterFactory = factory;
    }

    public IR1XmlReader createXmlReader() {
        IR1XmlReader reader = this._xmlReaderWriterFactory.createXmlReader();
        reader.setXmlTransChain(this.getXmlTransChain());
        return reader;
    }

    public IR1XmlWriter createXmlWriter() {
        IR1XmlWriter writer = this._xmlReaderWriterFactory.createXmlWriter();
        writer.setXmlTransChain(this.getXmlTransChain());
        return writer;
    }

    public void addChangeListener(PropertyChangeListener l) {
        this._listenerList.add(PropertyChangeListener.class, l);
    }

    public void removeChangeListener(PropertyChangeListener l) {
        this._listenerList.remove(PropertyChangeListener.class, l);
    }

    protected void fireChangeEvent(String name, Object oldValue, Object newValue) {
        Object[] list = this._listenerList.getListenerList();
        PropertyChangeEvent evt = null;
        for (int i = list.length - 2; i >= 0; i -= 2) {
            if (list[i] != PropertyChangeListener.class) continue;
            if (evt == null) {
                evt = new PropertyChangeEvent(this, name, oldValue, newValue);
            }
            ((PropertyChangeListener)list[i + 1]).propertyChange(evt);
        }
    }

    public void setDataSelector(IObjectSelector dataSelector) {
        this._dataSelector = dataSelector;
    }

    public IObjectSelector getDataSelector() {
        return this._dataSelector;
    }

    public DataTree getDataTree() {
        return this._dataTree;
    }

    public void setSystemParams(MetaClass systemParams) {
        this._systemParams = systemParams;
    }

    public UndoHelper getUndoHelper() {
        if (this._undoHelper == null) {
            this._undoHelper = new UndoHelper(this);
        }
        return this._undoHelper;
    }

    public LazyStyleDesigner getStyleDialog() {
        if (this._styleDlg == null) {
            this._styleDlg = (LazyStyleDesigner)WindowUtil.createWindow(LazyStyleDesigner.class, (Component)this.getPanel());
        }
        return this._styleDlg;
    }

    public void setPopupMenuConfigCreator(IConfigFileCreator c) {
        this._popupMenuConfigCreator = c;
    }

    public IConfigFileCreator getPopupMenuConfigCreator() {
        return this._popupMenuConfigCreator;
    }

    public IR1Ruler getRuler(int type) {
        if (0 == type) {
            return this._hRuler;
        }
        if (1 == type) {
            return this._vRuler;
        }
        return null;
    }

    public void storeUndoState(String prompt) {
        this.getUndoHelper().store(prompt);
    }

    public void setClipboard(IR1Clipboard clipboard) {
        this._clipboard = clipboard;
        this._clipboard.setCore(this);
    }

    public IR1Clipboard getClipboard() {
        if (this._clipboard == null) {
            this._clipboard = new R1Clipboard();
            this._clipboard.setCore(this);
        }
        return this._clipboard;
    }

    public void setStyleClipboard(StyleClipboard styleClipboard) {
        this._styleClipboard = styleClipboard;
        this._styleClipboard.setCore(this);
    }

    public StyleClipboard getStyleClipboard() {
        if (this._styleClipboard == null) {
            this._styleClipboard = new StyleClipboard();
            this._styleClipboard.setCore(this);
        }
        return this._styleClipboard;
    }

    public String getPromptTitle() {
        return MultiLanguageUtil.getMLS("core.ComboPanel.title", "");
    }

    public void addNavigation(String title, JComponent ctrl) {
        this._tabNavigation.addTab(title, (Component)ctrl);
    }

    public StructureTree getStructureTree() {
        return this._structureTree;
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    class EditorHandler
    implements EditorListener {
        private JComponent addedCtrl;

        EditorHandler() {
        }

        public void setAddedCtrl(JComponent c) {
            this.addedCtrl = c;
        }

        @Override
        public void cancelEdit(EditorEvent evt) {
            this.quitEdit((IDoubleClickEditor)evt.getSource());
        }

        @Override
        public void acceptEdit(EditorEvent evt) {
            this.quitEdit((IDoubleClickEditor)evt.getSource());
            ComboPanel.this.getModel().setDirty(true);
        }

        private void quitEdit(IDoubleClickEditor editor) {
            editor.removeEditorListener(this);
            ComboPanel.this._pageContainer.remove(this.addedCtrl);
            ComboPanel.this._pageContainer.revalidate();
            ComboPanel.this._pageContainer.repaint();
        }
    }

    class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private Point dragStartPoint;
        private Rectangle lastDragRect;
        private OperatingRenderer renderer = new OperatingRenderer();
        private ElementPath operateTarget;
        private IReportObject createTarget;
        private IDoubleClickEditor editor;
        private EditorHandler editorHandler = new EditorHandler();
        private boolean isMoved;
        private IReportObject virtualCreateTarget;
        private String virtualTargetKey;
        private PopupMenuManager popupMenuManager;

        MouseHandler() {
        }

        private Graphics getGraphicsOfPage() {
            Graphics g = ComboPanel.this._pageContainer.getGraphics();
            g.translate(((ComboPanel)ComboPanel.this)._pageContainer.getPagePos().x, ((ComboPanel)ComboPanel.this)._pageContainer.getPagePos().y);
            return g;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.popupMenu(e);
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            ElementPath elePath = null;
            if (ComboPanel.this._state.isExtend()) {
                elePath = ComboPanel.this._state.getExtendOwner().getSelection(e.getPoint());
                this.clearState();
            }
            if (elePath == null) {
                elePath = ComboPanel.this._pageContainer.searchTopElement(e.getPoint());
            }
            if (elePath != null) {
                this.selecting(e, elePath);
                if (e.getClickCount() == 2) {
                    this.doubleClick(e, elePath);
                }
                ComboPanel.this._pageContainer.repaint();
            }
        }

        private void selecting(MouseEvent e, ElementPath elePath) {
            if (e.isShiftDown()) {
                ElementPath[] eles;
                Object objRoot = elePath.getRootPathComponent();
                if (objRoot instanceof IMouseOperate && ComboPanel.this.getSelectionModel().isCanAdd(elePath) && (eles = ((IMouseOperate)objRoot).getSelection(ComboPanel.this.getSelectionModel(), elePath)) != null) {
                    ComboPanel.this.addSelection(eles);
                }
            } else if (e.isControlDown()) {
                if (ComboPanel.this.getSelectionModel().contains(elePath)) {
                    if (ComboPanel.this.getSelectionModel().size() > 1) {
                        ComboPanel.this.removeSelection(elePath);
                    }
                } else if (ComboPanel.this.getSelectionModel().isCanAdd(elePath)) {
                    ComboPanel.this.addSelection(elePath);
                }
            } else {
                ComboPanel.this.setSelection(elePath);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            IReportObject ro;
            ElementPath ep;
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.dragStartPoint = e.getPoint();
            this.isMoved = false;
            if (!(!ComboPanel.this._state.isNone() || (ep = ComboPanel.this._pageContainer.searchTopElement(e.getPoint())) == null || ep.getPathCount() != 1 || ep.getLastPathComponent() instanceof IR1Page || (ro = (IReportObject)ep.getRootPathComponent()).isLocked() || ro.isHorizontalFill() && ro.isVerticalFill())) {
                this.operateTarget = ep;
                ComboPanel.this._state.setOperate(1);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (ComboPanel.this._state.isResize()) {
                ComboPanel.this.storeUndoState(MultiLanguageUtil.getMLS("core.ComboPanel.resize", ""));
                IReportObject resizeTarget = this.resizing(e, true);
                ComboPanel.this.getModel().setDirty(true);
                if (resizeTarget instanceof IR1Page) {
                    ((IR1Page)resizeTarget).syncModelWhenResized(ComboPanel.this.getModel());
                }
                ContainerUtil.layoutChildren(resizeTarget);
                ComboPanel.this._pageContainer.repaint();
            } else if (ComboPanel.this._state.isMove() && this.isMoved) {
                ComboPanel.this.storeUndoState(MultiLanguageUtil.getMLS("core.ComboPanel.move", ""));
                if (this.moving(e, true)) {
                    ComboPanel.this.getModel().setDirty(true);
                    ComboPanel.this._pageContainer.repaint();
                }
            } else {
                if (ComboPanel.this._state.isToCreate()) {
                    return;
                }
                if (ComboPanel.this._state.isCanCreate()) {
                    return;
                }
                if (ComboPanel.this._state.isCreating()) {
                    this.resizing(e, true, this.createTarget);
                    ContainerUtil.layoutChildren((IReportObject)this.createTarget.getParent().getRootPathComponent());
                    ComboPanel.this.setSelection(new ElementPath(this.createTarget));
                    ComboPanel.this._pageContainer.repaint();
                    if (e.isControlDown()) {
                        ComboPanel.this._state.setOperate(3);
                        return;
                    }
                } else if (ComboPanel.this._state.isExtend()) {
                    ComboPanel.this._state.getExtendOwner().mouseReleased(this.getGraphicsOfPage(), e, this.dragStartPoint, ComboPanel.this.getUndoHelper());
                    ComboPanel.this._pageContainer.repaint();
                    ComboPanel.this.getModel().setDirty(true);
                    return;
                }
            }
            this.clearState();
        }

        private void clearState() {
            this.dragStartPoint = null;
            this.lastDragRect = null;
            this.operateTarget = null;
            this.createTarget = null;
            this.virtualTargetKey = null;
            ComboPanel.this._state.setOperate(0);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (ComboPanel.this._state.isResize()) {
                this.resizing(e, false);
            } else if (ComboPanel.this._state.isMove()) {
                if (this.operateTarget != null && !ComboPanel.this._pageContainer.getSelectionModel().contains(this.operateTarget)) {
                    ComboPanel.this.setSelection(this.operateTarget);
                }
                this.moving(e, false);
                this.isMoved = true;
            } else if (ComboPanel.this._state.isCanCreate()) {
                ComboPanel.this.storeUndoState(MultiLanguageUtil.getMLS("core.ComboPanel.create", ""));
                this.createTarget = this.create();
                ComboPanel.this._state.setOperate(5);
                ComboPanel.this._state.setResizeDirection(5);
            } else if (ComboPanel.this._state.isCreating()) {
                this.resizing(e, false, this.createTarget);
            } else if (ComboPanel.this._state.isExtend()) {
                ComboPanel.this._state.getExtendOwner().mouseDragged(this.getGraphicsOfPage(), e, this.dragStartPoint, ComboPanel.this._hRuler, ComboPanel.this._vRuler);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (ComboPanel.this._state.isToCreate() && !StringUtil.equals((String)this.virtualTargetKey, (String)ComboPanel.this._state.getCreateType())) {
                this.virtualCreateTarget = ComboPanel.this._objectFactory.create(ComboPanel.this._state.getCreateType());
            }
            if (ComboPanel.this._state.isToCreate() || ComboPanel.this._state.isCanCreate()) {
                ElementPath ep = ComboPanel.this._pageContainer.searchTopElement(e.getPoint());
                if (ep != null && ep.getLastPathComponent() instanceof IContainer) {
                    Object objParent = ep.getRootPathComponent();
                    IContainer ctn = (IContainer)ep.getLastPathComponent();
                    int insetX = Util.lom2Pixel(ctn.getInsetsXLom());
                    int insetY = Util.lom2Pixel(ctn.getInsetsYLom());
                    int insetW = Util.lom2Pixel(ctn.getInsetsWidthLom());
                    int insetH = Util.lom2Pixel(ctn.getInsetsHeightLom());
                    Point ptAtPage = ComboPanel.this._pageContainer.getPointAtPage(e);
                    Point roAtPage = ContainerUtil.getPointAtPage((IReportObject)objParent);
                    Point ptAtCtn = new Point(ptAtPage);
                    ptAtCtn.translate(-roAtPage.x, -roAtPage.y);
                    if (objParent instanceof ICompositeContainer) {
                        ICompositeContainer cc = (ICompositeContainer)objParent;
                        Point eleAtCc = cc.getRelativePosition((IElement)((Object)ctn));
                        ptAtCtn.translate(-eleAtCc.x, -eleAtCc.y);
                        insetW = Util.lom2Pixel(cc.getSubContainerInsetsWidthLom(ctn));
                        insetH = Util.lom2Pixel(cc.getSubContainerInsetsHeightLom(ctn));
                    }
                    if (ComboPanel.this.getClipboard().checkCanAddChild(ep, this.virtualCreateTarget, ptAtCtn) == null && ptAtCtn.x > insetX && ptAtCtn.x < insetX + insetW && ptAtCtn.y > insetY && ptAtCtn.y < insetY + insetH) {
                        ComboPanel.this._state.setOperate(4);
                        RulerMark hRulerMark = new RulerMark(ptAtPage.x, ptAtPage.x);
                        ComboPanel.this._hRuler.setMarkPosition(hRulerMark);
                        RulerMark vRulerMark = new RulerMark(ptAtPage.y, ptAtPage.y);
                        ComboPanel.this._vRuler.setMarkPosition(vRulerMark);
                    } else {
                        ComboPanel.this._state.setOperate(3);
                        ComboPanel.this._hRuler.setMarkPosition(null);
                        ComboPanel.this._vRuler.setMarkPosition(null);
                    }
                } else {
                    ComboPanel.this._state.setOperate(3);
                    ComboPanel.this._hRuler.setMarkPosition(null);
                    ComboPanel.this._vRuler.setMarkPosition(null);
                }
            } else {
                int dir = ComboPanel.this._pageContainer.getDirectionByPoint(e.getPoint());
                if (dir > 0) {
                    if (dir == 10) {
                        ComboPanel.this._state.setOperate(1);
                    } else {
                        ComboPanel.this._state.setOperate(2);
                        ComboPanel.this._state.setResizeDirection(dir);
                    }
                } else {
                    ComboPanel.this._state.setOperate(0);
                    ElementPath epSelected = ComboPanel.this._pageContainer.getSelectionModel().getCurrent();
                    ElementPath ep = ComboPanel.this._pageContainer.searchTopElement(e.getPoint());
                    if (ep != null && !ep.equals(epSelected)) {
                        ep = ComboPanel.this._pageContainer.searchTopElementWidthExt(e.getPoint(), SelectionRenderer.BLOCK_WIDTH + 2);
                    }
                    if (ep != null && ep.getRootPathComponent() instanceof IMouseOperate) {
                        Point ptAtPage;
                        IMouseOperate co = (IMouseOperate)ep.getRootPathComponent();
                        if (epSelected != null && co == epSelected.getRootPathComponent() && co.mouseMoved(e, ptAtPage = ComboPanel.this._pageContainer.getPointAtPage(e.getPoint()))) {
                            ComboPanel.this._state.setOperate(10);
                            ComboPanel.this._state.setExtendOwner(co);
                        }
                    } else if (dir == 0) {
                        ComboPanel.this._state.setOperate(1);
                    }
                }
            }
            ComboPanel.this._pageContainer.setCursor(ComboPanel.this._state.getCursor());
        }

        private Point getDelta(MouseEvent e, IReportObject ro, MouseOperateState state) {
            Point delta = e.getPoint();
            delta.translate(-this.dragStartPoint.x, -this.dragStartPoint.y);
            MouseOperateState.limitAdjustValue(ro, delta, state);
            return delta;
        }

        private IReportObject create() {
            Point startXYAtPage = ComboPanel.this._pageContainer.getPointAtPage(this.dragStartPoint);
            ElementPath ep = ComboPanel.this._pageContainer.searchTopElement(this.dragStartPoint);
            IContainer ctn = (IContainer)ep.getLastPathComponent();
            IReportObject parentObj = (IReportObject)ep.getRootPathComponent();
            Point parentObjAtPage = ContainerUtil.getPointAtPage(parentObj);
            Point startXYAtParent = new Point(startXYAtPage);
            startXYAtParent.translate(-parentObjAtPage.x, -parentObjAtPage.y);
            if (parentObj instanceof ICompositeObject) {
                Point parentAtParentObj = ((ICompositeObject)((Object)parentObj)).getRelativePosition((IElement)((Object)ctn));
                startXYAtParent.translate(-parentAtParentObj.x, -parentAtParentObj.y);
            }
            startXYAtParent.translate(-Util.lom2Pixel(ctn.getInsetsXLom()), -Util.lom2Pixel(ctn.getInsetsYLom()));
            int xLom = Util.pixel2Lom(startXYAtParent.x);
            int yLom = Util.pixel2Lom(startXYAtParent.y);
            IReportObject ro = ComboPanel.this._objectFactory.create(ComboPanel.this._state.getCreateType());
            ro.setXLom(xLom);
            ro.setYLom(yLom);
            String layoutParm = ctn.getLayoutParm(startXYAtParent);
            ICompositeContainer compositeContainer = null;
            if (parentObj instanceof ICompositeContainer) {
                compositeContainer = (ICompositeContainer)((Object)parentObj);
            }
            ComboPanel.this.getModel().addReportObject(compositeContainer, ctn, ro, layoutParm);
            Util.addingRequestFill(ctn, ro);
            return ro;
        }

        private IReportObject resizing(MouseEvent e, boolean isEnd) {
            Object ele = ComboPanel.this._pageContainer.getSelectionModel().getCurrent().getLastPathComponent();
            if (ele instanceof IReportObject) {
                IReportObject ro = (IReportObject)ele;
                this.resizing(e, isEnd, ro);
                return ro;
            }
            return null;
        }

        private void resizing(MouseEvent e, boolean isEnd, IReportObject ro) {
            Point delta = this.getDelta(e, ro, ComboPanel.this._state);
            Rectangle rect = null;
            if (!isEnd) {
                rect = MouseOperateState.getOperatingRect(ro, delta, ComboPanel.this._state);
            }
            this.renderer.draw(ComboPanel.this._pageContainer.getGraphicsOfPage(), this.lastDragRect, rect);
            this.lastDragRect = rect;
            if (isEnd) {
                ro.adjust(delta, ComboPanel.this._state);
            }
            if (rect != null) {
                RulerMark hRulerMark = RulerMark.createHorizontal(rect);
                ComboPanel.this._hRuler.setMarkPosition(hRulerMark);
                RulerMark vRulerMark = RulerMark.createVertical(rect);
                ComboPanel.this._vRuler.setMarkPosition(vRulerMark);
            }
        }

        private boolean moving(MouseEvent e, boolean isEnd) {
            int selectSize = ComboPanel.this._pageContainer.getSelectionModel().size();
            if (selectSize == 0) {
                return false;
            }
            Object ele = ComboPanel.this._pageContainer.getSelectionModel().get(0).getLastPathComponent();
            if (ele instanceof IR1Page || !(ele instanceof IReportObject)) {
                return false;
            }
            IReportObject ro = (IReportObject)ele;
            Point delta = this.getDelta(e, ro, ComboPanel.this._state);
            for (int i = selectSize - 1; i >= 0; --i) {
                ele = ComboPanel.this._pageContainer.getSelectionModel().get(i).getLastPathComponent();
                if (!(ele instanceof IReportObject)) continue;
                ro = (IReportObject)ele;
                Rectangle rect = null;
                if (!isEnd) {
                    rect = MouseOperateState.getOperatingRect(ro, delta, ComboPanel.this._state);
                }
                this.renderer.draw(ComboPanel.this._pageContainer.getGraphicsOfPage(), this.lastDragRect, rect);
                this.lastDragRect = rect;
                if (isEnd) {
                    ro.adjust(delta, ComboPanel.this._state);
                }
                if (i != 0 || rect == null) continue;
                RulerMark hRulerMark = RulerMark.createHorizontal(rect);
                ComboPanel.this._hRuler.setMarkPosition(hRulerMark);
                RulerMark vRulerMark = RulerMark.createVertical(rect);
                ComboPanel.this._vRuler.setMarkPosition(vRulerMark);
            }
            return true;
        }

        private void doubleClick(MouseEvent e, ElementPath clickTarget) {
            Rectangle rect;
            IElement ele = (IElement)clickTarget.getLastPathComponent();
            if (!(ele instanceof IDoubleClick)) {
                return;
            }
            if (!((IDoubleClick)((Object)ele)).isCanEdit()) {
                return;
            }
            ComboPanel.this.storeUndoState(MultiLanguageUtil.getMLS("core.ComboPanel.change", ""));
            Rectangle bound = ((IDoubleClick)((Object)ele)).getEditorBound();
            if (bound != null) {
                rect = bound;
            } else {
                Object obj = clickTarget.getRootPathComponent();
                if (obj instanceof ICompositeObject) {
                    rect = ((ICompositeObject)obj).getSubElementRectangle(ele);
                    Point objAtPage = ContainerUtil.getPointAtPage((IReportObject)obj);
                    rect.translate(objAtPage.x - 1, objAtPage.y - 1);
                    rect.width += 3;
                    rect.height += 3;
                } else {
                    rect = ((IReportObject)obj).getRectAtPage();
                }
            }
            rect.translate(((ComboPanel)ComboPanel.this)._pageContainer.getPagePos().x, ((ComboPanel)ComboPanel.this)._pageContainer.getPagePos().y);
            rect.setBounds((int)Math.round(rect.getX() * ComboPanel.this.scale), (int)Math.round(rect.getY() * ComboPanel.this.scale), (int)Math.round(rect.getWidth() * ComboPanel.this.scale), (int)Math.round(rect.getHeight() * ComboPanel.this.scale));
            this.editor = ((IDoubleClick)((Object)ele)).getEditor();
            this.editor.addEditorListener(this.editorHandler);
            JComponent ctrl = this.editor.getEditorCtrl();
            KDScrollPane scrollPane = this.editor.getScrollPane();
            if (scrollPane != null) {
                scrollPane.getViewport().add(ctrl);
                this.editorHandler.setAddedCtrl((JComponent)scrollPane);
                ComboPanel.this._pageContainer.add((Component)scrollPane);
                scrollPane.setBounds(rect);
            } else {
                this.editorHandler.setAddedCtrl(ctrl);
                ComboPanel.this._pageContainer.add(ctrl);
                ctrl.setBounds(rect);
            }
            ComboPanel.this._pageContainer.validate();
            ctrl.requestFocus();
        }

        private void popupMenu(MouseEvent evt) {
            KDPopupMenu popupMenu;
            if (this.popupMenuManager == null) {
                this.popupMenuManager = new PopupMenuManager(ComboPanel.this.getPopupMenuConfigCreator());
            }
            if ((popupMenu = this.popupMenuManager.updateMenu(null, ComboPanel.this)) != null) {
                popupMenu.show((Component)ComboPanel.this._pageContainer, evt.getX() + 3, evt.getY() + 3);
            }
        }
    }

    class ScaledMouseHandler
    extends MouseHandler {
        ScaledMouseHandler() {
        }

        private MouseEvent scale(MouseEvent e) {
            return new MouseEvent(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), (int)Math.round((double)e.getX() / ComboPanel.this.scale), (int)Math.round((double)e.getY() / ComboPanel.this.scale), e.getXOnScreen(), e.getYOnScreen(), e.getClickCount(), e.isPopupTrigger(), e.getButton());
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                super.mouseClicked(e);
            } else {
                MouseEvent scaledE = this.scale(e);
                super.mouseClicked(scaledE);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            MouseEvent scaledE = this.scale(e);
            super.mousePressed(scaledE);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MouseEvent scaledE = this.scale(e);
            super.mouseReleased(scaledE);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            MouseEvent scaledE = this.scale(e);
            super.mouseDragged(scaledE);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            MouseEvent scaledE = this.scale(e);
            super.mouseMoved(scaledE);
        }
    }

    class ModelInnerChangeHandler
    implements PropertyChangeListener {
        ModelInnerChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String pn = evt.getPropertyName();
            if (pn == "dirty") {
                ComboPanel.this.fireChangeEvent(ComboPanel.PROPERTY_TITLE, evt.getOldValue(), evt.getNewValue());
            } else if (pn == "addElement") {
                ComboPanel.this._structureTree.updateAddNode((ElementPath)evt.getNewValue());
            } else if (pn == "delElement") {
                ElementPath ep = (ElementPath)evt.getNewValue();
                ComboPanel.this._structureTree.updateRemoveNode(ep);
                ComboPanel.this.removeScrollBar(ep.getLastPathComponent());
            } else if (pn == "renElement") {
                ComboPanel.this._structureTree.updateNodeText((ElementPath)evt.getSource());
            } else if (pn == "add") {
                DataExtend ext = (DataExtend)((Object)evt.getNewValue());
                Object data = ComboPanel.this.getModel().getDataManager().getObject(ext.getName());
                ComboPanel.this._dataTree.addData(ext, data);
                ComboPanel.this.showNavigationData();
            } else if (pn == "insert") {
                DataExtend ext = (DataExtend)((Object)evt.getNewValue());
                int idx = 0;
                Object objIdx = ext.getProperty("index");
                if (objIdx instanceof Integer) {
                    idx = (Integer)objIdx;
                }
                Object data = ComboPanel.this.getModel().getDataManager().getObject(ext.getName());
                ComboPanel.this._dataTree.insertDataNode(ext, data, idx);
                ComboPanel.this.showNavigationData();
            } else if (pn == "delete") {
                DataExtend ext = (DataExtend)((Object)evt.getNewValue());
                ComboPanel.this._dataTree.removeData(ext);
            } else if (pn == "rename" || pn == "realias") {
                DataExtend ext = (DataExtend)((Object)evt.getNewValue());
                ComboPanel.this._dataTree.renameData(ext);
            } else if (pn == "report param") {
                ComboPanel.this._dataTree.updateReportParam();
            } else if (pn == "page") {
                ComboPanel.this._pageContainer.setCurrentPage(ComboPanel.this._model.getPage());
                ComboPanel.this._structureTree.update();
                ComboPanel.this.setSelection(new ElementPath(ComboPanel.this._model.getPage()));
            }
        }
    }
}

