/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.element;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.kdf.util.BMPReader;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ICompositeObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.IReportObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.AbstractR1FormObjectWithData;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.renderer.PictureRenderer;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;

public class PictureObject
extends AbstractR1FormObjectWithData {
    public static final String[] STYLE_PANELS = new String[]{"digitFormat", "alignment", "font", "interior"};
    public static final Logger log = LogUtil.getLogger(PictureObject.class);
    private static PictureRenderer _renderer = new PictureRenderer();
    public static final int ZOOM_NONE = 1;
    public static final int ZOOM_SCALE = 2;
    private String imageExpression;
    private byte[] imageContent;
    private Image img = null;
    private int scale = 1;
    private boolean isLinked = false;

    @Override
    public String getIdPrefix() {
        return "picture";
    }

    @Override
    public void initTreeNode(DefaultKingdeeTreeNode node) {
        node.setCustomIcon((Icon)Icons.SEC_PIC);
    }

    @Override
    public String getTypePrompt() {
        return MultiLanguageUtil.getMLS("picture", "");
    }

    @Override
    protected IReportObjectRenderer createRenderer() {
        return _renderer;
    }

    @Override
    public String[] getStylePanelKeys() {
        return STYLE_PANELS;
    }

    public String getImageExpression() {
        return this.imageExpression;
    }

    public void setImageExpression(String imageExpression) {
        this.imageExpression = imageExpression;
        this.syncExprToContent(imageExpression);
    }

    public byte[] getImageContent() {
        return this.imageContent;
    }

    public void setImageContent(byte[] imageBytes) {
        this.imageContent = imageBytes;
        this.syncBytesToImage(this.imageContent, null);
    }

    public Image getImage() {
        return this.img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncExprToContent(String expr) {
        String filePath = expr;
        if (expr.startsWith("file://")) {
            filePath = expr.substring(7);
        }
        InputStream in = null;
        byte[] cotenet = null;
        String extName = null;
        if (filePath.length() > 4) {
            extName = filePath.substring(filePath.length() - 3);
        }
        try {
            in = new FileInputStream(new File(filePath));
            cotenet = StreamUtil.readInputStream((InputStream)in);
        }
        catch (FileNotFoundException e) {
            log.error((Object)("The file below is not found: " + filePath), (Throwable)e);
            this.setImageContent(null);
            return;
        }
        catch (IOException e1) {
            log.error((Object)"Read Picture I/O error.", (Throwable)e1);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.imageContent = cotenet;
        this.syncBytesToImage(cotenet, extName);
    }

    private void syncBytesToImage(byte[] content, String extName) {
        if (content == null) {
            this.img = null;
        } else {
            byte[] c = content;
            if ("bmp".equalsIgnoreCase(extName) || "dib".equalsIgnoreCase(extName)) {
                c = PictureObject.readBmp(content);
                this.imageContent = c;
            }
            this.img = new ImageIcon(c).getImage();
        }
    }

    public boolean isLinked() {
        return this.isLinked;
    }

    public void setLinked(boolean isLinked) {
        this.isLinked = isLinked;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getType() {
        return "Image";
    }

    private static byte[] readBmp(byte[] contenet) {
        Image image = BMPReader.loadBitMap((byte[])contenet);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    @Override
    protected String[] propertyPanelKeys(ICompositeObject co) {
        return new String[]{"pictureSet"};
    }
}

