/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_QuerySelector;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.MainF7SelectObject;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.form.widget.MainF7Model;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.eas.basedata.org.OrgType;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PanelMainF7Select
extends AbstractPropertyPanel {
    private KDTextField txtUIAddress;
    private KDPromptBox bosQueryName;
    private KDComboBox cmbDisFormat;
    private KDComboBox cmbSubmitFormat;
    private KDCheckBox isEditable;
    private KDComboBox cmbEditFormat;
    private KDCheckBox isMultiSelection;
    private KDComboBox cmbOrgType;
    private KDComboBox cmbValueFormat;
    private Eas_QuerySelector metaChooser;
    private MetaClass metaClass;
    private String strMetaName;
    private String oldExp;
    static OrgType[] orgTypes = new OrgType[]{OrgType.Company, OrgType.ControlUnit, OrgType.CostCenter, OrgType.HRO, OrgType.ProfitCenter, OrgType.Purchase, OrgType.Sale, OrgType.Storage, OrgType.UnionDebt, OrgType.Admin};
    static String[] orgTypeQuery = new String[]{"com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery", "com.kingdee.eas.basedata.org.app.CUQuery", "com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery", "com.kingdee.eas.basedata.org.app.HROrgUnitQuery", "com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery", "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery", "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery", "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery", "com.kingdee.eas.basedata.org.app.UnionVersionQuery]", "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery"};
    private ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            KDComboBox cmb;
            if (e.getStateChange() == 1 && !((cmb = (KDComboBox)e.getSource()).getSelectedItem() instanceof String)) {
                MetaField metaField = (MetaField)cmb.getSelectedItem();
                String str = "$" + metaField.getName() + "$";
                cmb.setSelectedItem((Object)str);
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = e.getSource();
            if (obj.equals(PanelMainF7Select.this.isEditable)) {
                if (PanelMainF7Select.this.isEditable.isSelected()) {
                    PanelMainF7Select.this.cmbEditFormat.setEnabled(true);
                    PanelMainF7Select.this.cmbSubmitFormat.setEnabled(true);
                } else {
                    PanelMainF7Select.this.cmbSubmitFormat.setEnabled(false);
                    PanelMainF7Select.this.cmbEditFormat.setEnabled(false);
                }
            }
        }
    };

    public static String paserOrtType2Query(OrgType type) {
        for (int i = 0; i < orgTypes.length; ++i) {
            if (type != orgTypes[i]) continue;
            return orgTypeQuery[i];
        }
        return null;
    }

    public PanelMainF7Select() {
        this.init();
        this.installListener();
    }

    private void clearItems() {
        this.cmbDisFormat.removeAllItems();
        this.cmbValueFormat.removeAllItems();
        this.cmbSubmitFormat.removeAllItems();
        this.cmbEditFormat.removeAllItems();
    }

    private void reload(MetaClass metaClass) {
        List list;
        this.clearItems();
        if (StringUtil.isEmptyString((String)this.strMetaName)) {
            this.strMetaName = metaClass.getExpr();
            this.bosQueryName.setData((Object)this.strMetaName);
        }
        if ((list = metaClass.getFields()) != null) {
            for (int i = 0; i < list.size(); ++i) {
                MetaField metaField = (MetaField)list.get(i);
                this.cmbDisFormat.addItem((Object)metaField);
                this.cmbValueFormat.addItem((Object)metaField);
                this.cmbSubmitFormat.addItem((Object)metaField);
                this.cmbEditFormat.addItem((Object)metaField);
            }
            this.cmbDisFormat.setSelectedIndex(-1);
            this.cmbValueFormat.setSelectedIndex(-1);
            this.cmbSubmitFormat.setSelectedIndex(-1);
            this.cmbEditFormat.setSelectedIndex(-1);
        }
    }

    private void init() {
        this.txtUIAddress = new KDTextField();
        this.metaChooser = new Eas_QuerySelector();
        this.bosQueryName = new KDPromptBox();
        this.bosQueryName.setEditable(true);
        this.bosQueryName.setSelector((KDPromptSelector)this.metaChooser);
        this.isEditable = new KDCheckBox(MultiLanguageUtil.getMLS("allowEdit", ""));
        this.isEditable.addActionListener(this.actionListener);
        this.isMultiSelection = new KDCheckBox(MultiLanguageUtil.getMLS("allowMultiSelection", ""));
        this.cmbDisFormat = new KDComboBox();
        this.cmbDisFormat.addItemListener(this.itemListener);
        this.cmbDisFormat.setEditable(true);
        this.cmbSubmitFormat = new KDComboBox();
        this.cmbSubmitFormat.setEditable(true);
        this.cmbSubmitFormat.addItemListener(this.itemListener);
        this.cmbEditFormat = new KDComboBox();
        this.cmbEditFormat.setEditable(true);
        this.cmbEditFormat.addItemListener(this.itemListener);
        this.cmbValueFormat = new KDComboBox();
        this.cmbValueFormat.addItemListener(this.itemListener);
        this.cmbValueFormat.setEditable(true);
        this.cmbOrgType = new KDComboBox();
        this.cmbOrgType.addItems((Object[])orgTypes);
        this.cmbOrgType.setSelectedIndex(-1);
        if (!this.isEditable.isSelected()) {
            this.cmbEditFormat.setEnabled(false);
            this.cmbSubmitFormat.setEnabled(false);
        }
        KDLabelContainer lbcUiAddress = CtrlSwingUtilities.createLabelContainer((JComponent)this.txtUIAddress, (String)MultiLanguageUtil.getMLS("uiAddress", ""), (int)100);
        KDLabelContainer lbcQueryName = CtrlSwingUtilities.createLabelContainer((JComponent)this.bosQueryName, (String)MultiLanguageUtil.getMLS("bosQueryName", ""), (int)100);
        KDLabelContainer lbcDisFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbDisFormat, (String)MultiLanguageUtil.getMLS("displayFormat", ""), (int)100);
        KDLabelContainer lbcSubmitFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbSubmitFormat, (String)MultiLanguageUtil.getMLS("submitFormat", ""), (int)100);
        KDLabelContainer lbcEditFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbEditFormat, (String)MultiLanguageUtil.getMLS("editFormat", ""), (int)100);
        KDLabelContainer lbcValueFormat = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbValueFormat, (String)MultiLanguageUtil.getMLS("valueFormat", ""), (int)100);
        KDLabelContainer lbcOrgType = CtrlSwingUtilities.createLabelContainer((JComponent)this.cmbOrgType, (String)MultiLanguageUtil.getMLS("ortType", ""), (int)100);
        TableLayout tl = TableLayout.split((int)10, (int)1);
        tl.getStyle().setMargin(4, 8, 8, 8);
        tl.rowStyle(0).setMargin(4, 0, 0, 3);
        tl.rowStyle(1).setMargin(4, 0, 0, 3);
        tl.rowStyle(2).setMargin(4, 0, 0, 3);
        tl.rowStyle(3).setMargin(4, 0, 0, 3);
        tl.rowStyle(4).setMargin(4, 0, 0, 3);
        tl.rowStyle(5).setMargin(0, 0, 0, 0);
        tl.rowStyle(6).setMargin(25, 0, 0, 3);
        tl.rowStyle(7).setMargin(25, 0, 0, 3);
        tl.rowStyle(8).setMargin(0, 0, 0, 3);
        tl.rowStyle(9).setPriY(1);
        Table t = tl.cell(0).split(1, 2);
        t.colStyle(0).setWidth(300);
        t.colStyle(0).setMarginRight(5);
        t.colStyle(1).setPriX(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)lbcOrgType, t.cell(0));
        this.add((Component)lbcQueryName, tl.cell(1, 0));
        this.add((Component)lbcUiAddress, tl.cell(2, 0));
        this.add((Component)lbcDisFormat, tl.cell(3, 0));
        this.add((Component)lbcValueFormat, tl.cell(4, 0));
        this.add((Component)this.isEditable, tl.cell(5, 0));
        this.add((Component)lbcEditFormat, tl.cell(6, 0));
        this.add((Component)lbcSubmitFormat, tl.cell(7, 0));
        this.add((Component)this.isMultiSelection, tl.cell(8, 0));
    }

    private void installListener() {
        this.cmbOrgType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OrgType orgType;
                String str;
                Object o = PanelMainF7Select.this.cmbOrgType.getSelectedItem();
                if (o instanceof OrgType && !StringUtil.isEmptyString((String)(str = PanelMainF7Select.paserOrtType2Query(orgType = (OrgType)o)))) {
                    PanelMainF7Select.this.metaClass = Eas_QuerySelector.getMetaClass(str);
                    PanelMainF7Select.this.bosQueryName.setData((Object)PanelMainF7Select.this.metaClass);
                    PanelMainF7Select.this.bosQueryName.setText(str);
                    PanelMainF7Select.this.oldExp = str;
                    if (PanelMainF7Select.this.metaClass == null) {
                        return;
                    }
                    PanelMainF7Select.this.reload(PanelMainF7Select.this.metaClass);
                }
            }
        });
        this.bosQueryName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                String str;
                if (PanelMainF7Select.this.metaChooser.getData() instanceof MetaClass) {
                    PanelMainF7Select.this.metaClass = (MetaClass)PanelMainF7Select.this.metaChooser.getData();
                    if (PanelMainF7Select.this.metaClass != null) {
                        PanelMainF7Select.this.reload(PanelMainF7Select.this.metaClass);
                    }
                }
                if (PanelMainF7Select.this.bosQueryName.getData() instanceof String && !StringUtil.isEmptyString((String)PanelMainF7Select.this.bosQueryName.getData().toString()) && !StringUtil.equals((String)(str = PanelMainF7Select.this.bosQueryName.getData().toString()), (String)PanelMainF7Select.this.oldExp)) {
                    try {
                        PanelMainF7Select.this.metaClass = Eas_QuerySelector.getMetaClass(str);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (PanelMainF7Select.this.metaClass == null) {
                        return;
                    }
                    PanelMainF7Select.this.reload(PanelMainF7Select.this.metaClass);
                }
            }
        });
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        MainF7SelectObject ro = (MainF7SelectObject)elePath.getLastPathComponent();
        MainF7Model model = new MainF7Model();
        if (this.cmbOrgType.getSelectedItem() != null) {
            if (this.cmbOrgType.getSelectedItem() instanceof OrgType) {
                model.setOrgType((OrgType)this.cmbOrgType.getSelectedItem());
            } else {
                model.setOrgType(null);
            }
        }
        if (this.bosQueryName.getData() instanceof String) {
            model.setQueryInfo((String)this.bosQueryName.getData());
        } else if (this.bosQueryName.getData() instanceof MetaClass) {
            model.setQueryInfo(((MetaClass)this.bosQueryName.getData()).getExpr());
        }
        if (this.cmbDisFormat.getSelectedItem() != null) {
            model.setDisplayFormat(this.cmbDisFormat.getSelectedItem().toString());
        }
        if (this.cmbValueFormat.getSelectedItem() != null) {
            model.setValueFormat(this.cmbValueFormat.getSelectedItem().toString());
        }
        if (this.isEditable.isSelected()) {
            model.setEditable(true);
            if (this.cmbSubmitFormat.getSelectedItem() != null) {
                model.setCommitFormat(this.cmbSubmitFormat.getSelectedItem().toString());
            }
            if (null != this.cmbEditFormat.getSelectedItem()) {
                model.setEditFormat(this.cmbEditFormat.getSelectedItem().toString());
            }
        } else {
            model.setEditable(false);
        }
        if (null != this.txtUIAddress.getText()) {
            model.setUIClassName(this.txtUIAddress.getText());
        }
        if (this.isMultiSelection.isSelected()) {
            model.setMultiSelectable(true);
        } else {
            model.setMultiSelectable(false);
        }
        ro.setModel(model);
    }

    @Override
    public String getTitle() {
        return MultiLanguageUtil.getMLS("mainf7Select", "");
    }

    private void setEditFormatEnable(boolean flag) {
        this.isEditable.setSelected(flag);
        this.cmbEditFormat.setEnabled(flag);
        this.cmbSubmitFormat.setEnabled(flag);
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eles) {
        MainF7SelectObject ele = (MainF7SelectObject)eles[0].getLastPathComponent();
        MainF7Model model = ele.getModel();
        if (model != null) {
            if (!StringUtil.isEmptyString((String)model.getQueryInfo())) {
                this.metaClass = Eas_QuerySelector.getMetaClass(model.getQueryInfo());
            }
            if (this.metaClass != null) {
                this.reload(this.metaClass);
            } else {
                this.bosQueryName.setData((Object)model.getQueryInfo());
            }
            if (model.getOrgType() != null) {
                this.cmbOrgType.setSelectedItem((Object)model.getOrgType());
            }
            if (model.getDisplayFormat() != null) {
                this.cmbDisFormat.setSelectedItem((Object)model.getDisplayFormat());
            }
            if (model.getValueFormat() != null) {
                this.cmbValueFormat.setSelectedItem((Object)model.getValueFormat());
            }
            if (model.isEditable()) {
                this.setEditFormatEnable(true);
                this.cmbEditFormat.setSelectedItem((Object)model.getEditFormat());
                this.cmbSubmitFormat.setSelectedItem((Object)model.getCommitFormat());
            } else {
                this.setEditFormatEnable(false);
            }
            if (!StringUtil.isEmptyString((String)model.getUIClassName())) {
                this.txtUIAddress.setText(model.getUIClassName());
            }
            if (model.isMultiSelectable()) {
                this.isMultiSelection.setSelected(true);
            } else {
                this.isMultiSelection.setSelected(false);
            }
        }
    }

    @Override
    public boolean verify() {
        if (this.cmbValueFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbValueFormat.getSelectedItem().toString())) {
            WindowUtil.msgboxError((Object)"\u8fd4\u56de\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.bosQueryName.getData() == null) {
            WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("bosQueryNull", ""), (String)this.getTitle(), (Component)((Object)this));
            return false;
        }
        if (this.isEditable.isSelected()) {
            if (this.cmbSubmitFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbSubmitFormat.getSelectedItem().toString())) {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("submitFormatNull", ""), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
            if (this.cmbEditFormat.getSelectedItem() == null || StringUtil.isEmptyString((String)this.cmbEditFormat.getSelectedItem().toString())) {
                WindowUtil.msgboxError((Object)MultiLanguageUtil.getMLS("editFormatNull", ""), (String)this.getTitle(), (Component)((Object)this));
                return false;
            }
        }
        return true;
    }
}

