/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.cell;

import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.Field;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDataGridCell;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.CellField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.ICellValue;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.StatField;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.cellvalue.Text;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.common.RadioButtonGroup;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.cell.FieldCellPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.cell.StaticCellPanel;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.property.cell.TextCellPanel;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class PanelCellBasic
extends AbstractPropertyPanel {
    protected KDPanel selfPanel;
    private KDRadioButton radDefault;
    private KDRadioButton radText;
    private KDRadioButton radField;
    private KDRadioButton radStatic;
    private TextCellPanel textCellPanel;
    private FieldCellPanel fieldCellPanel;
    private StaticCellPanel staticCellPanel;
    private AbstractDataGrid grid;
    private AbstractDataGridCell tempCell;
    boolean isMultiSelected;
    private ComboPanel core;

    public PanelCellBasic() {
        this.init();
    }

    private void init() {
        this.selfPanel = new KDPanel();
        this.radDefault = new KDRadioButton("\u9ed8\u8ba4");
        this.radText = new KDRadioButton("\u6587\u672c");
        this.radField = new KDRadioButton("\u5b57\u6bb5");
        this.radStatic = new KDRadioButton("\u7edf\u8ba1");
        RadioButtonGroup gp = new RadioButtonGroup();
        gp.add(this.radDefault);
        gp.add(this.radText);
        gp.add(this.radField);
        gp.add(this.radStatic);
        KDPanel radPanel = new KDPanel();
        radPanel.setBorder((Border)BorderFactory.createTitledBorder("\u5355\u5143\u683c\u7c7b\u578b"));
        TableLayout tp = TableLayout.split((int)1, (int)5);
        tp.rowStyle(0).setMargin(16, 16, 8, 8);
        tp.colStyle(0).setMarginRight(6);
        tp.colStyle(1).setMarginRight(6);
        tp.colStyle(2).setMarginRight(6);
        tp.colStyle(4).setPriX(1);
        radPanel.setLayout((LayoutManager)tp);
        radPanel.add((Component)this.radText, (Object)tp.cell(0, 0));
        radPanel.add((Component)this.radField, (Object)tp.cell(0, 1));
        radPanel.add((Component)this.radStatic, (Object)tp.cell(0, 2));
        radPanel.add((Component)this.radDefault, (Object)tp.cell(0, 3));
        TableLayout tl = TableLayout.split((int)3, (int)1);
        tl.style().setMargin(8, 8, 8, 8);
        tl.rowStyle(0).setHeight(50);
        tl.rowStyle(0).setMarginBottom(6);
        tl.rowStyle(1).setMarginBottom(3);
        tl.rowStyle(1).setPriY(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)radPanel, tl.cell(0, 0));
        this.add((Component)this.selfPanel, tl.cell(1, 0));
        this.installListener();
    }

    private void installListener() {
        this.radDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCellBasic.this.selfPanel.removeAll();
                PanelCellBasic.this.selfPanel.validate();
                PanelCellBasic.this.repaint();
            }
        });
        this.radText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCellBasic.this.selfPanel.removeAll();
                PanelCellBasic.this.selfPanel.setLayout((LayoutManager)new BorderLayout());
                if (PanelCellBasic.this.textCellPanel == null) {
                    PanelCellBasic.this.textCellPanel = new TextCellPanel();
                }
                PanelCellBasic.this.selfPanel.add((Component)((Object)PanelCellBasic.this.textCellPanel), (Object)"Center");
                PanelCellBasic.this.selfPanel.validate();
                PanelCellBasic.this.repaint();
            }
        });
        this.radField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCellBasic.this.selfPanel.removeAll();
                PanelCellBasic.this.selfPanel.setLayout((LayoutManager)new BorderLayout());
                if (PanelCellBasic.this.fieldCellPanel == null) {
                    PanelCellBasic.this.fieldCellPanel = new FieldCellPanel();
                }
                PanelCellBasic.this.selfPanel.add((Component)((Object)PanelCellBasic.this.fieldCellPanel), (Object)"Center");
                PanelCellBasic.this.selfPanel.validate();
                PanelCellBasic.this.repaint();
                PanelCellBasic.this.bindField(PanelCellBasic.this.fieldCellPanel.getCmbField(), PanelCellBasic.this.grid);
                if (PanelCellBasic.this.tempCell != null) {
                    PanelCellBasic.this.prepareMerge(PanelCellBasic.this.fieldCellPanel.getMergePanel().getCkIsMerge(), PanelCellBasic.this.grid, PanelCellBasic.this.tempCell);
                }
            }
        });
        this.radStatic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCellBasic.this.selfPanel.removeAll();
                PanelCellBasic.this.selfPanel.setLayout((LayoutManager)new BorderLayout());
                if (PanelCellBasic.this.staticCellPanel == null) {
                    PanelCellBasic.this.staticCellPanel = new StaticCellPanel();
                }
                PanelCellBasic.this.selfPanel.add((Component)((Object)PanelCellBasic.this.staticCellPanel), (Object)"Center");
                PanelCellBasic.this.selfPanel.validate();
                PanelCellBasic.this.repaint();
                PanelCellBasic.this.bindField(PanelCellBasic.this.staticCellPanel.getCmbField(), PanelCellBasic.this.grid);
                if (PanelCellBasic.this.tempCell != null) {
                    PanelCellBasic.this.prepareMerge(PanelCellBasic.this.staticCellPanel.getMergePanel().getCkIsMerge(), PanelCellBasic.this.grid, PanelCellBasic.this.tempCell);
                }
            }
        });
    }

    private void updateMerge(KDCheckBox checkbox, AbstractDataGridCell cell) {
        if (checkbox.isSelected()) {
            cell.setExectuedMerge(true);
        } else {
            cell.setExectuedMerge(false);
        }
        cell.setExectuedMerge(checkbox.isSelected());
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
        Object obj = elePath.getLastPathComponent();
        if (obj instanceof AbstractDataGridCell) {
            AbstractDataGridCell cell = (AbstractDataGridCell)obj;
            if (this.radText.isSelected()) {
                if (StringUtil.isEmptyString((String)cell.getValue().toString())) {
                    cell.setValue(new Text("\u6587\u672c"));
                }
                if (!this.isMultiSelected) {
                    cell.setValue(new Text(this.textCellPanel.getTxtCell().getText()));
                }
            } else if (this.radField.isSelected()) {
                this.updateMerge(this.fieldCellPanel.getMergePanel().getCkIsMerge(), cell);
                cell.setValue(new CellField());
                Object objSelected = this.fieldCellPanel.getCmbField().getSelectedItem();
                if (objSelected == null) {
                    cell.setValue(null);
                } else {
                    CellField field = CellField.create((Field)objSelected);
                    cell.setValue(field);
                }
            } else if (this.radStatic.isSelected()) {
                this.updateMerge(this.staticCellPanel.getMergePanel().getCkIsMerge(), cell);
                cell.setValue(new StatField());
                Field fieldSelected = (Field)this.staticCellPanel.getCmbField().getSelectedItem();
                StatField sf = (StatField)cell.getValue();
                if (this.staticCellPanel.getRadGroupSubtotal().isSelected()) {
                    sf.setRange(18);
                } else if (this.staticCellPanel.getRadAreaSubtotal().isSelected()) {
                    sf.setRange(17);
                } else if (this.staticCellPanel.getRadSubtotal().isSelected()) {
                    sf.setRange(16);
                }
                sf.setField(fieldSelected);
                sf.setType(this.staticCellPanel.getStatTypeGroup().getSelectedStatType());
            } else {
                cell.setValue(null);
            }
        }
    }

    @Override
    public String getTitle() {
        return "\u5355\u5143\u683c";
    }

    private void prepareMerge(KDCheckBox checkBox, AbstractDataGrid grid, AbstractDataGridCell cell) {
        if (cell.isExectuedMerge()) {
            checkBox.setSelected(true);
        } else {
            checkBox.setSelected(false);
        }
        checkBox.setSelected(cell.isExectuedMerge());
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        AbstractDataGridCell cell;
        Object objRoot = eps[0].getRootPathComponent();
        if (!(objRoot instanceof AbstractDataGrid)) {
            return;
        }
        this.grid = (AbstractDataGrid)objRoot;
        Object obj = eps[0].getLastPathComponent();
        this.isMultiSelected = eps.length > 1;
        this.tempCell = cell = (AbstractDataGridCell)obj;
        ICellValue value = cell.getValue();
        if (value instanceof Text) {
            this.radText.setSelected(true);
            this.selfPanel.removeAll();
            this.selfPanel.setLayout((LayoutManager)new BorderLayout());
            if (this.textCellPanel == null) {
                this.textCellPanel = new TextCellPanel();
            }
            this.selfPanel.add((Component)((Object)this.textCellPanel), (Object)"Center");
            this.selfPanel.validate();
            this.repaint();
            this.textCellPanel.getTxtCell().setText(cell.getValue().toString());
            if (this.isMultiSelected) {
                this.textCellPanel.getTxtCell().setEnabled(false);
            } else {
                this.textCellPanel.getTxtCell().setEnabled(true);
            }
        } else if (value instanceof CellField) {
            this.radField.setSelected(true);
            this.selfPanel.removeAll();
            this.selfPanel.setLayout((LayoutManager)new BorderLayout());
            if (this.fieldCellPanel == null) {
                this.fieldCellPanel = new FieldCellPanel();
            }
            this.prepareMerge(this.fieldCellPanel.getMergePanel().getCkIsMerge(), this.grid, cell);
            this.selfPanel.add((Component)((Object)this.fieldCellPanel), (Object)"Center");
            this.selfPanel.validate();
            this.repaint();
            this.bindField(this.fieldCellPanel.getCmbField(), this.grid);
            if (value instanceof Field) {
                this.fieldCellPanel.getCmbField().setSelectedItem((Object)((Field)((Object)value)));
            } else {
                this.fieldCellPanel.getCmbField().setSelectedItem(null);
            }
        } else if (value instanceof StatField) {
            this.radField.setSelected(true);
            this.radStatic.setSelected(true);
            this.selfPanel.removeAll();
            this.selfPanel.setLayout((LayoutManager)new BorderLayout());
            if (this.staticCellPanel == null) {
                this.staticCellPanel = new StaticCellPanel();
            }
            this.prepareMerge(this.staticCellPanel.getMergePanel().getCkIsMerge(), this.grid, cell);
            this.selfPanel.add((Component)((Object)this.staticCellPanel), (Object)"Center");
            this.selfPanel.validate();
            this.repaint();
            StatField sf = (StatField)value;
            this.bindField(this.staticCellPanel.getCmbField(), this.grid);
            this.staticCellPanel.getCmbField().setSelectedItem((Object)sf.getField());
            if (sf.getRange() == 18) {
                this.staticCellPanel.getRadGroupSubtotal().setSelected(true);
            } else if (sf.getRange() == 17) {
                this.staticCellPanel.getRadAreaSubtotal().setSelected(true);
            } else if (sf.getRange() == 16) {
                this.staticCellPanel.getRadSubtotal().setSelected(true);
            }
            int statType = ((StatField)value).getType();
            this.staticCellPanel.getStatTypeGroup().setSelectedStatType(statType);
        } else {
            this.radField.setSelected(false);
            this.radDefault.setSelected(true);
        }
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this.core = core;
    }

    private void bindField(KDComboBox combbox, AbstractDataGrid grid) {
        combbox.removeAllItems();
        combbox.addItem(null);
        String dsName = grid.getDataSource().getDs();
        MetaClass ds = (MetaClass)this.core.getModel().getDataManager().getObject(dsName);
        if (ds != null) {
            MetaField[] mfs = ds.getFields().toArray(new MetaField[0]);
            for (int i = 0; i < mfs.length; ++i) {
                MetaField mf = mfs[i];
                Field f = Field.fromMetaField(mf);
                combbox.addItem((Object)f);
            }
        }
    }
}

