/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.toolbox;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.factory.IAnObjectFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractColumn;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractGrid;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.toolbox.AbstractToolboxItem;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.xmltrans.IObjectXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.Util;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.element.grid.datagrid.FormDataGrid;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.icon.Icons;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.model.xmltrans.grid.FormDataGridXmlTrans;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.LoadKDStyleUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.util.MultiLanguageUtil;
import java.awt.Color;
import javax.swing.Icon;

public class ToolboxDataGrid
extends AbstractToolboxItem {
    @Override
    protected String getDefaultKey() {
        return "DataGrid";
    }

    @Override
    protected Icon getButtonIcon() {
        return Icons.createIcon("toolbox/toolbox_datagrid.gif");
    }

    @Override
    protected String getButtonTooltips() {
        return MultiLanguageUtil.getMLS("dataGrid", "");
    }

    @Override
    protected IAnObjectFactory createAnObjectFactory() {
        return new ObjectFactory();
    }

    public static void initStyle(AbstractGrid grid, AbstractRow row, boolean isHead) {
        LoadKDStyleUtil.tableStyleFromCtrl(row, isHead);
        StyleAttributes sa = row.getStyleAttribute();
        if (!isHead) {
            sa.setBackground(Color.WHITE);
        }
        ToolboxDataGrid.makeBorder(sa);
        row.setStyleAttribute(sa);
        grid.applySubElementStyle(row, sa);
    }

    private static void makeBorder(StyleAttributes sa) {
        sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.SINGLE_LINE);
        sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.SINGLE_LINE);
        sa.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
        sa.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
        sa.setBorderColor(Styles.Position.LEFT, Color.GRAY);
        sa.setBorderColor(Styles.Position.RIGHT, Color.GRAY);
        sa.setBorderColor(Styles.Position.TOP, Color.GRAY);
        sa.setBorderColor(Styles.Position.BOTTOM, Color.GRAY);
    }

    public static void initStyle(FormDataGrid grid, AbstractColumn col) {
        KDTable kdt = new KDTable();
        kdt.addHeadRow();
        IRow kdtableHead = kdt.getHeadRow(0);
        StyleAttributes saHead = Styles.getSA((StyleAttributes)kdtableHead.getStyleAttributes());
        ToolboxDataGrid.makeBorder(saHead);
        kdt.addRow();
        IRow kdtableRow = kdt.getRow(0);
        StyleAttributes saRow = Styles.getSA((StyleAttributes)kdtableRow.getStyleAttributes());
        saRow.setBackground(Color.WHITE);
        ToolboxDataGrid.makeBorder(saRow);
        int headRows = grid.getHeadRowCount();
        int colIdx = grid.getIndexOfColumn(col);
        int c = grid.getRowsCount();
        for (int i = 0; i < c; ++i) {
            if (i < headRows) {
                grid.getCell(i, colIdx).setStyleAttribute(saHead);
                continue;
            }
            grid.getCell(i, colIdx).setStyleAttribute(saRow);
        }
    }

    class ObjectFactory
    implements IAnObjectFactory {
        ObjectFactory() {
        }

        @Override
        public IReportObject create() {
            FormDataGrid dataGrid = new FormDataGrid();
            for (int i = 0; i < 3; ++i) {
                AbstractColumn col = dataGrid.addColumn();
                col.setWidthLom(Util.pixel2Lom(100));
            }
            AbstractRow row = dataGrid.addRow(1);
            ToolboxDataGrid.initStyle(dataGrid, row, true);
            row = dataGrid.addRow(2);
            ToolboxDataGrid.initStyle(dataGrid, row, false);
            row = dataGrid.addRow(1);
            ToolboxDataGrid.initStyle(dataGrid, row, false);
            return dataGrid;
        }

        @Override
        public IObjectXmlTrans getXmlTrans() {
            return new FormDataGridXmlTrans(this);
        }
    }
}

