/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.GroupingEngine;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.IGroupingListener;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.SimpleValue;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatCell;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.grouping.StatGroup;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.RsUtil;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleColumnMD;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSet;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.data.rs.SimpleResultSetMD;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public final class GroupRSTree {
    private static final String CHILD_RS_COLNAME = "CHILD_RS";
    private static final int CHILD_RS_COLIDX = 1;
    private static final int BASE_COLIDX = 2;
    private ResultSet rows;
    private int depth;
    private GroupCache[] groupCaches;
    private DetailCache detailCache = null;
    private GroupingEngine engine;
    private ResultSet[] outputs;

    public static String buildOutputStatColName(String statType, int dataCol) throws SQLException {
        return statType + dataCol;
    }

    public void init(ResultSet rows, StatGroup[] groups, int[] detailCols) throws SQLException {
        this.rows = rows;
        this.engine = new GroupingEngine();
        this.engine.init(rows, groups);
        this.engine.setListener(new CacheHandler());
        if (detailCols != null) {
            this.depth = groups.length + 1;
            this.detailCache = new DetailCache();
            this.detailCache.init(detailCols);
        } else {
            this.depth = groups.length;
        }
        this.groupCaches = new GroupCache[groups.length];
        for (int i = 0; i < this.groupCaches.length; ++i) {
            GroupCache groupCache = new GroupCache();
            groupCache.init(groups[i], i);
            this.groupCaches[i] = groupCache;
        }
        this.outputs = new ResultSet[this.depth];
        GroupCache rootCache = this.groupCaches[0];
        rootCache.newCachingRS();
        this.outputs[0] = rootCache.getCachingRS();
    }

    public final int getDepth() {
        return this.depth;
    }

    public final int findGroupCol(int level, String statType, int dataCol) throws SQLException {
        return RsUtil.locateColIndex(this.groupCaches[level].getRSMD(), GroupRSTree.buildOutputStatColName(statType, dataCol));
    }

    public final int findDetailCol(int dataCol) throws SQLException {
        return RsUtil.locateColIndex(this.detailCache.getRSMD(), String.valueOf(dataCol));
    }

    public final boolean hasNextGroup() {
        return this.engine.hasNextGroup();
    }

    public final int nextGroup(int exitDepth) throws SQLException {
        return this.engine.nextGroup(exitDepth);
    }

    public final boolean nextOutputRow(int level) throws SQLException {
        ResultSet rs = this.outputs[level];
        if (rs.next()) {
            if (++level < this.outputs.length) {
                this.outputs[level] = (ResultSet)rs.getObject(1);
            }
            return true;
        }
        return false;
    }

    public final ResultSet getOutputRow(int level) throws SQLException {
        return this.outputs[level];
    }

    public final ResultSet ensureRow(int level) throws SQLException {
        GroupCache groupCache;
        if (level < this.groupCaches.length && (groupCache = this.groupCaches[level]).isPending()) {
            this.nextGroup(level);
        }
        return this.outputs[level];
    }

    private class CacheHandler
    implements IGroupingListener {
        private CacheHandler() {
        }

        @Override
        public void startGroup(int level) throws SQLException {
            ResultSet childRS;
            if (GroupRSTree.this.detailCache != null) {
                GroupRSTree.this.detailCache.newCachingRS();
                childRS = GroupRSTree.this.detailCache.getCachingRS();
            } else {
                childRS = null;
            }
            for (int i = GroupRSTree.this.groupCaches.length - 1; i > level; --i) {
                GroupCache groupCache = GroupRSTree.this.groupCaches[i];
                groupCache.newCachingRS();
                groupCache.addGroupRow(childRS);
                childRS = groupCache.getCachingRS();
            }
            GroupCache groupCache = GroupRSTree.this.groupCaches[level];
            groupCache.addGroupRow(childRS);
        }

        @Override
        public void stepDetail() throws SQLException {
            if (GroupRSTree.this.detailCache != null) {
                GroupRSTree.this.detailCache.addDetailRow();
            }
        }

        @Override
        public void endGroup(int level) throws SQLException {
            for (int i = GroupRSTree.this.groupCaches.length - 1; i >= level; --i) {
                GroupRSTree.this.groupCaches[i].updateStatValues();
            }
        }
    }

    private class DetailCache
    extends ACache {
        private int[] colMap;

        private DetailCache() {
        }

        final void init(int[] colMap) throws SQLException {
            ResultSetMetaData rowsMD = GroupRSTree.this.rows.getMetaData();
            this.colMap = colMap;
            this.rsmd = new SimpleResultSetMD(this.colMap.length - 1);
            for (int i = 1; i < this.colMap.length; ++i) {
                int dataCol = this.colMap[i];
                SimpleColumnMD colMD = new SimpleColumnMD(rowsMD, dataCol);
                colMD.setName(String.valueOf(i));
                this.rsmd.setColumn(i, colMD);
            }
        }

        final void addDetailRow() throws SQLException {
            this.cachingRS.moveToInsertRow();
            for (int i = 1; i < this.colMap.length; ++i) {
                this.cachingRS.updateObject(i, GroupRSTree.this.rows.getObject(this.colMap[i]));
            }
            this.cachingRS.insertRow();
        }
    }

    private class GroupCache
    extends ACache {
        private SimpleValue[] statValues;
        private ResultSet childRS;

        private GroupCache() {
        }

        final void init(StatGroup group, int level) throws SQLException {
            int colCount = group.getStatCellCount();
            this.rsmd = new SimpleResultSetMD(2 + colCount - 1);
            this.statValues = new SimpleValue[colCount];
            SimpleColumnMD colMD = new SimpleColumnMD();
            colMD.setName(GroupRSTree.CHILD_RS_COLNAME);
            colMD.setType(ValueType.OBJECT.getJdbcType());
            this.rsmd.setColumn(1, colMD);
            for (int i = 0; i < colCount; ++i) {
                SimpleValue statVal;
                StatCell cell = group.getStatCell(i);
                String statType = cell.getStatType();
                int dataCol = cell.getDataCol();
                this.statValues[i] = statVal = GroupRSTree.this.engine.findStat(statType, dataCol).getStatValue(level);
                colMD = new SimpleColumnMD();
                colMD.setName(GroupRSTree.buildOutputStatColName(statType, dataCol));
                colMD.setType(statVal.getType().getJdbcType());
                this.rsmd.setColumn(2 + i, colMD);
            }
        }

        final void addGroupRow(ResultSet childRS) throws SQLException {
            this.childRS = childRS;
            this.cachingRS.moveToInsertRow();
            this.cachingRS.updateObject(1, (Object)childRS);
            for (int i = 0; i < this.statValues.length; ++i) {
                this.cachingRS.updateObject(2 + i, this.statValues[i].objectValue());
            }
            this.cachingRS.insertRow();
        }

        final void updateStatValues() throws SQLException {
            this.childRS = null;
            for (int i = 0; i < this.statValues.length; ++i) {
                this.cachingRS.updateObject(2 + i, this.statValues[i].objectValue());
            }
            this.cachingRS.updateRow();
            this.cachingRS.moveToCurrentRow();
        }

        final boolean isPending() {
            return this.childRS != null;
        }
    }

    private abstract class ACache {
        protected SimpleResultSetMD rsmd;
        protected ResultSet cachingRS;

        private ACache() {
        }

        final ResultSetMetaData getRSMD() {
            return this.rsmd;
        }

        final void newCachingRS() throws SQLException {
            this.cachingRS = new SimpleResultSet(this.rsmd);
        }

        final ResultSet getCachingRS() {
            return this.cachingRS;
        }
    }
}

