/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv;

import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.common.ValueType;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.formats.csv.CsvWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class CsvUtil {
    public static void writeResultSet(ResultSet rs, CsvWriter out) throws SQLException, IOException {
        CsvUtil.writeRSMD(rs.getMetaData(), out);
        CsvUtil.writeRows(rs, out);
    }

    public static void writeRSMD(ResultSetMetaData rsmd, CsvWriter out) throws SQLException, IOException {
        int i;
        int colCount = rsmd.getColumnCount();
        for (i = 1; i <= colCount; ++i) {
            ValueType type = ValueType.fromJdbcType(rsmd.getColumnType(i));
            out.writeCell(type.getName(), i == colCount);
        }
        for (i = 1; i <= colCount; ++i) {
            out.writeCell(rsmd.getColumnName(i), i == colCount);
        }
    }

    public static void writeRows(ResultSet rs, CsvWriter out) throws SQLException, IOException {
        int colCount = rs.getMetaData().getColumnCount();
        while (rs.next()) {
            for (int i = 1; i <= colCount; ++i) {
                out.writeCell(rs.getString(i), i == colCount);
            }
        }
    }
}

