/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter;

import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BarcodeContext;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.BaseTextPainter;
import com.kingdee.bos.ctrl.reportone.r1.print.barcode.painter.GraphicsForBarcode;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;

public class AdjustBaseLineTextPainter
extends BaseTextPainter {
    @Override
    public void doPaint(BarcodeContext barcodeContext) {
        String text = barcodeContext.getText();
        double width = barcodeContext.getWidth();
        double height = barcodeContext.getHeight();
        double barWidth = barcodeContext.getBarWidth();
        int fontSize = barcodeContext.getFontSize();
        GraphicsForBarcode g = barcodeContext.getGraphics();
        Font localFont = new Font("monospace", 0, AdjustBaseLineTextPainter.round((double)fontSize * barWidth));
        g.setFont(localFont);
        FontMetrics fontMetrics = g.getFontMetrics();
        double rawStringWidth = fontMetrics.stringWidth(text);
        double fh = fontMetrics.getHeight();
        g.setColor(Color.WHITE);
        g.fillRect(0.0, 0.0, width, height * 0.05);
        g.fillRect(0.0, height - fh * 0.8, width, fh * 0.8);
        g.setColor(Color.BLACK);
        double totalBarsWidth = barcodeContext.getBarZoneWidth();
        double x = (width - rawStringWidth) / 2.0;
        double y = height - fh * 0.2;
        if (rawStringWidth >= totalBarsWidth * 0.8) {
            g.drawString(text, x, y);
        } else {
            double length = text.length();
            double gap = (totalBarsWidth * 0.8 - rawStringWidth) / (length - 1.0);
            x = (width - totalBarsWidth * 0.8) / 2.0;
            for (int k = 0; k < text.length(); ++k) {
                String s = text.substring(k, k + 1);
                g.drawString(s, x, y);
                double rawCharWidth = fontMetrics.charWidth(s.charAt(0));
                x += rawCharWidth + gap;
            }
        }
    }

    private static int round(double d) {
        return (int)Math.round(d);
    }
}

