/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.grid.rowcol;

import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.ElementPath;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.AbstractRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.grid.biz.AbstractDetailRow;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.ComboPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.property.AbstractPropertyPanel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGrid;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.grid.datagrid.DataGridDetailRow;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

class DGridDetailRowPane
extends AbstractPropertyPanel {
    private KDRadioButton _radTypeReport;
    private KDRadioButton _radTypeNote;
    private KDCheckBox _chkHeightAdjust;
    private KDSpinner _spnRepeatTimes;
    private KDCheckBox _printBlankLine;
    private ComboPanel _core;

    public DGridDetailRowPane() {
        this.init();
        this.installListener();
    }

    private void init() {
        this._radTypeReport = new KDRadioButton(MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.typeReport", ""));
        this._radTypeNote = new KDRadioButton(MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.typeNote", ""));
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this._radTypeReport);
        bg.add((AbstractButton)this._radTypeNote);
        this._chkHeightAdjust = new KDCheckBox(MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.heightAdjust", ""));
        this._chkHeightAdjust.setSwitch(false);
        this._printBlankLine = new KDCheckBox("\u4e0d\u6253\u5370\u7a7a\u884c");
        this._printBlankLine.setSwitch(false);
        this._spnRepeatTimes = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 1, 100, 1));
        KDLabelContainer lbcRepeatTimes = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnRepeatTimes, (String)MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.repeatTimes", ""), (int)80);
        TableLayout tl = TableLayout.splitRow((int)6);
        tl.style().setMargin(10, 26, 10, 10);
        tl.rowStyle(0).setHeight(22);
        tl.rowStyle(0).setMarginBottom(3);
        tl.rowStyle(1).setHeight(25);
        tl.rowStyle(1).setMarginLeft(20);
        tl.rowStyle(1).setMarginBottom(6);
        tl.rowStyle(2).setHeight(22);
        tl.rowStyle(2).setMarginBottom(3);
        tl.rowStyle(3).setHeight(20);
        tl.rowStyle(3).setMarginLeft(20);
        tl.rowStyle(3).setMarginBottom(3);
        tl.rowStyle(4).setHeight(20);
        tl.rowStyle(4).setMarginLeft(19);
        tl.rowStyle(4).setMarginBottom(3);
        tl.rowStyle(5).setPriY(1);
        Table row3 = tl.cell(3).splitCol(2);
        row3.colStyle(0).setWidth(140);
        row3.colStyle(1).setPriX(1);
        this.setLayout((LayoutManager)tl);
        this.add((Component)this._radTypeReport, tl.cell(0));
        this.add((Component)this._chkHeightAdjust, tl.cell(1));
        this.add((Component)this._radTypeNote, tl.cell(2));
        this.add((Component)lbcRepeatTimes, row3.cell(0));
        this.add((Component)this._printBlankLine, tl.cell(4));
        this.setBorder(BorderFactory.createTitledBorder(MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.dataRow", "")));
    }

    private void installListener() {
        this._radTypeReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DGridDetailRowPane.this.syncCtrlEnabled();
            }
        });
        this._radTypeNote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DGridDetailRowPane.this._spnRepeatTimes.getIntegerVlaue() == 0) {
                    DGridDetailRowPane.this._spnRepeatTimes.setValue((Object)new Integer(1));
                }
                DGridDetailRowPane.this.syncCtrlEnabled();
            }
        });
    }

    @Override
    public String getTitle() {
        return null;
    }

    @Override
    public void prepareSupplyValue(ComboPanel core, ElementPath[] eles) {
        this._core = core;
    }

    @Override
    public void prepareCtrlValue(ElementPath[] eps) {
        DataGridDetailRow row = (DataGridDetailRow)eps[0].getLastPathComponent();
        int repeatTimes = row.getRepeatTimes();
        boolean isTypeReport = repeatTimes == 0;
        this._radTypeReport.setSelected(isTypeReport);
        this._radTypeNote.setSelected(!isTypeReport);
        if (isTypeReport) {
            this._chkHeightAdjust.setSelected(!row.isFixedHeight());
            this._spnRepeatTimes.setValue((Object)new Integer(0));
        } else {
            this._chkHeightAdjust.setSelected(false);
            this._spnRepeatTimes.setValue((Object)new Integer(repeatTimes));
            this._printBlankLine.setSelected(row.isDealPrintBlankLine());
        }
        this.syncCtrlEnabled();
    }

    private void syncCtrlEnabled() {
        this._chkHeightAdjust.setEnabled(this._radTypeReport.isSelected());
        this._spnRepeatTimes.setEnabled(this._radTypeNote.isSelected());
        this._printBlankLine.setEnabled(this._radTypeNote.isSelected());
    }

    @Override
    public void updateElementValue(ElementPath[] eles) {
        DataGridDetailRow row = (DataGridDetailRow)eles[0].getLastPathComponent();
        if (this._radTypeReport.isSelected()) {
            row.setRepeatTimes(0);
            row.setFixedHeight(!this._chkHeightAdjust.isSelected());
        } else if (this._radTypeNote.isSelected()) {
            int repeatTimes;
            DataGrid grid = (DataGrid)eles[0].getRootPathComponent();
            AbstractRow[] bfs = grid.getBackwardForwardRow();
            int occupyDetail = 0;
            if (bfs[0] != null && bfs[0] instanceof AbstractDetailRow) {
                ++occupyDetail;
            }
            if (bfs[1] != null && bfs[1] instanceof AbstractDetailRow) {
                ++occupyDetail;
            }
            if ((repeatTimes = this._spnRepeatTimes.getIntegerVlaue().intValue()) - occupyDetail < 1) {
                repeatTimes = occupyDetail + 1;
                StringBuffer sb = new StringBuffer();
                sb.append(MultiLanguageUtil.getMLS("rowcol.DGridDetailRowPane.info", ""));
                sb.append(repeatTimes);
                sb.append("\u3002");
                WindowUtil.msgboxInfo((Object)sb.toString(), (String)this._core.getPromptTitle(), (Component)((Object)this));
            }
            row.setDealPrintBlankLine(this._printBlankLine.isSelected());
            row.setRepeatTimes(repeatTimes);
            row.setFixedHeight(true);
        }
    }

    @Override
    protected void updateElementValue(ElementPath elePath) {
    }
}

