/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.script;

import com.kingdee.bos.ctrl.common.layout.table.Cell;
import com.kingdee.bos.ctrl.common.layout.table.Table;
import com.kingdee.bos.ctrl.common.layout.table.TableLayout;
import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.TypicalDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.editor.DefaultEditorStyleModel;
import com.kingdee.bos.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.bos.ctrl.common.ui.formulawizard.FormulaWizard;
import com.kingdee.bos.ctrl.common.ui.formulawizard.FormulaWizardFactory;
import com.kingdee.bos.ctrl.common.ui.formulawizard.Group;
import com.kingdee.bos.ctrl.common.ui.formulawizard.IOwner;
import com.kingdee.bos.ctrl.common.util.LangUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.MetaField;
import com.kingdee.bos.ctrl.data.modal.DefObj;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.IR1DataManager;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.property.script.Keywords;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class ScriptEditor {
    private KDPanel _panOwner;
    private KDLabel _labTitle = new KDLabel();
    private MiniScriptEditor _editor;
    private KDWorkButton _btnWizard;
    private FormulaWizard _wizard;
    private Group _groupOfDs;
    private MiniScriptEditor _editorOfwizard;
    private boolean _isEdited;
    private IR1DataManager _dm;

    public ScriptEditor(String title) {
        this._labTitle.setText(title);
        this._editor = MiniScriptEditor.createSensitiveCaseEditor();
        this._editorOfwizard = MiniScriptEditor.createSensitiveCaseEditor();
        this._editor.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                ScriptEditor.this._isEdited = true;
            }
        });
        this.initUI();
        this.addHeavyColorKeywords(Keywords.KEYWORDS);
    }

    private void initUI() {
        TableLayout tl = TableLayout.split((int)2, (int)1);
        tl.rowStyle(0).setHeight(24);
        tl.rowStyle(0).setMargin(3);
        tl.rowStyle(1).setPriY(1);
        Table row0 = tl.cell(0).splitCol(2);
        row0.colStyle(0).setPriX(1);
        row0.colStyle(1).setWidth(40);
        this._panOwner = new KDPanel((LayoutManager)tl);
        this._btnWizard = new KDWorkButton(MultiLanguageUtil.getMLS("script.ScriptEditor.guide", ""));
        this._panOwner.add((Component)this._labTitle, (Object)row0.cell(0));
        this._panOwner.add((Component)this._btnWizard, (Object)row0.cell(1));
        this._panOwner.add((Component)new KDScrollPane((Component)this._editor), (Object)tl.cell(1));
        this._btnWizard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardDialog dlg;
                Window parent = SwingUtilities.getWindowAncestor((Component)ScriptEditor.this._panOwner);
                if (parent instanceof Dialog) {
                    dlg = new WizardDialog((Dialog)parent);
                } else if (parent instanceof Frame) {
                    dlg = new WizardDialog((Frame)parent);
                } else {
                    throw new RuntimeException("Imposible");
                }
                dlg.setLocationRelativeTo(null);
                if (ScriptEditor.this._wizard == null) {
                    ScriptEditor.this._groupOfDs = ScriptEditor.this.createGroupOfDatasource();
                    String path = "/com/kingdee/bos/ctrl/reportone/r1/print/designer/gui/property/script/";
                    String[] fileName = LangUtil.getFileNames((String)"ScriptWizard", (String)".xml");
                    String filePath = null;
                    for (int i = 0; i < fileName.length; ++i) {
                        filePath = path + fileName[i];
                        if (this.getClass().getResourceAsStream(filePath) != null) break;
                        filePath = null;
                    }
                    if (filePath == null) {
                        filePath = "/com/kingdee/bos/ctrl/reportone/r1/print/designer/gui/property/script/ScriptWizard.xml";
                    }
                    ScriptEditor.this._wizard = FormulaWizardFactory.createWizard((String)filePath);
                    ScriptEditor.this._wizard.addSupplyGroup(ScriptEditor.this._groupOfDs);
                    ScriptEditor.this._wizard.setTitle(MultiLanguageUtil.getMLS("script.ScriptEditor.scriptGuide", ""));
                    ScriptEditor.this._wizard.setEditCtrl((JTextComponent)ScriptEditor.this._editorOfwizard);
                    ScriptEditor.this._wizard.setEditCtrlHeight(160);
                    ScriptEditor.this._wizard.setOwner((IOwner)dlg);
                    ScriptEditor.this._wizard.validateChildren();
                }
                ScriptEditor.this.prepareGroupOfDatasource();
                ScriptEditor.this._wizard.setResult(ScriptEditor.this._editor.getText());
                ScriptEditor.this._editorOfwizard.setCaretPosition(0);
                if (ScriptEditor.this._wizard.showWindow()) {
                    ScriptEditor.this.setText(ScriptEditor.this._wizard.getResult());
                    ScriptEditor.this._isEdited = true;
                }
            }
        });
    }

    public void addHeavyColorInterface(Class cls) {
        ArrayList<String> scriptKeys = new ArrayList<String>();
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            scriptKeys.add(methods[i].getName());
        }
        this.addHeavyColorKeywords(scriptKeys.toArray(new String[0]));
    }

    private void addHeavyColorKeywords(String[] keywords) {
        DefaultEditorStyleModel em = (DefaultEditorStyleModel)this._editor.getStyleModel();
        em.addStyle(keywords, em.createSimpleAttributeSet(new Color(127, 0, 85), true));
        DefaultEditorStyleModel em2 = (DefaultEditorStyleModel)this._editorOfwizard.getStyleModel();
        em2.addStyle(keywords, em2.createSimpleAttributeSet(new Color(127, 0, 85), true));
    }

    public boolean isEdited() {
        return this._isEdited;
    }

    public void clearEditedMark() {
        this._isEdited = false;
    }

    public JComponent getUI() {
        return this._panOwner;
    }

    public void setText(String text) {
        this._editor.setText(text);
        this._editor.setCaretPosition(0);
    }

    public String getText() {
        return this._editor.getText();
    }

    public void setEnabled(boolean enabled) {
        this._editor.setEnabled(enabled);
        this._btnWizard.setEnabled(enabled);
    }

    public void setDataManager(IR1DataManager dm) {
        this._dm = dm;
    }

    private Group createGroupOfDatasource() {
        Group group = new Group();
        group.setTitle(MultiLanguageUtil.getMLS("script.ScriptEditor.dataSource", ""));
        return group;
    }

    private void prepareGroupOfDatasource() {
        this._groupOfDs.removeAllChildren(this._groupOfDs.getRoot());
        DataExtend[] allExts = this._dm.getDataExtends();
        for (int i = 0; i < allExts.length; ++i) {
            DataExtend ext = allExts[i];
            DefaultKingdeeTreeNode nodeDs = this._groupOfDs.addNode(null, ScriptEditor.makeNameToShow(ext), ScriptEditor.makeFormula(ext));
            Object dsObj = this._dm.getObject(ext.getName());
            if (!(dsObj instanceof MetaClass)) continue;
            MetaClass mc = (MetaClass)dsObj;
            List fs = mc.getFields();
            int c = fs.size();
            for (int j = 0; j < c; ++j) {
                MetaField mf = (MetaField)fs.get(j);
                this._groupOfDs.addNode(nodeDs, ScriptEditor.makeNameToShow((DefObj)mf), ScriptEditor.makeFormula((DefObj)mf));
            }
        }
        this._groupOfDs.expandRoot();
    }

    private static String makeNameToShow(DefObj obj) {
        StringBuffer sb = new StringBuffer();
        if (obj.getAlias() != null) {
            sb.append(obj.getAlias());
        }
        sb.append(" (");
        sb.append(obj.getName());
        sb.append(")");
        return sb.toString();
    }

    private static Formula makeFormula(DefObj obj) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(obj.getName());
        sb.append("\"");
        Formula formula = new Formula(sb.toString());
        return formula;
    }

    private static class WizardDialog
    extends TypicalDialog
    implements IOwner {
        private FormulaWizard wizardPane;
        private KDWorkButton btnInfo;

        public WizardDialog(Dialog owner) {
            super(owner);
        }

        public WizardDialog(Frame owner) {
            super(owner);
        }

        protected void todoInit() {
            this.setSize(800, 600);
            this.btnInfo = new KDWorkButton(MultiLanguageUtil.getMLS("script.ScriptEditor.syntaxExplain", ""));
            TableLayout tl = TableLayout.splitCol((int)2);
            tl.colStyle(0).setWidth(60);
            tl.colStyle(1).setPriX(1);
            this.getExtPanel().setLayout((LayoutManager)tl);
            this.getExtPanel().add((Component)this.btnInfo, (Object)tl.cell(0));
            this.btnInfo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StringBuffer info = new StringBuffer();
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain1", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain2", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain3", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain4", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain5", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain6", ""));
                    info.append(StringUtil.RETURN);
                    info.append("\u3000\u3000var a = b + 1;");
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain7", ""));
                    info.append(StringUtil.RETURN);
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain8", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain9", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain10", ""));
                    info.append(StringUtil.RETURN);
                    info.append(MultiLanguageUtil.getMLS("script.ScriptEditor.explain11", ""));
                    KDTextArea txa = new KDTextArea();
                    txa.setText(info.toString());
                    txa.setEditable(false);
                    txa.setSelectAllOnFocus(false);
                    txa.setCaretPosition(0);
                    SimpleDialog dlg = (SimpleDialog)WindowUtil.createWindow(SimpleDialog.class, (Component)((Object)this));
                    dlg.setTitle(MultiLanguageUtil.getMLS("script.ScriptEditor.scriptSyntaxExplain", ""));
                    dlg.setComponent((Component)new KDScrollPane((Component)txa));
                    dlg.hideCancelButton();
                    dlg.showDialog();
                }
            });
        }

        protected void todoAddControls(Container parent, Cell thisCell) {
            parent.add((Component)this.getWizardPane(), thisCell);
        }

        public FormulaWizard getWizardPane() {
            return this.wizardPane;
        }

        public void setWizardPane(FormulaWizard wizardPane) {
            this.wizardPane = wizardPane;
        }

        public boolean showDialog() {
            if (!this.isAddControls) {
                this.addControls();
                this.isAddControls = true;
            }
            super.show();
            return this.isOk;
        }
    }
}

