/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer;

import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.print.ui.view.StyleRender;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.element.IReportObject;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.core.PageContainer;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.renderer.AbstractObjectRenderer;
import com.kingdee.bos.ctrl.reportone.r1.print.common.R1PrintStringRender;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.element.PictureObject;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.gui.icon.R1PrintIcons;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.renderer.RendererUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;

public class PictureRenderer
extends AbstractObjectRenderer {
    private PictureObject _objPic;

    @Override
    public void setReportObject(IReportObject obj) {
        this._objPic = (PictureObject)obj;
    }

    @Override
    public void draw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this._objPic.getX(), this._objPic.getY(), this._objPic.getWidth(), this._objPic.getHeight());
        int angle = this._objPic.getRotate();
        double rad = (double)angle / 360.0 * 2.0 * Math.PI;
        Graphics2D g2 = (Graphics2D)graphics;
        g2 = (Graphics2D)g2.create();
        Shape clip = g2.getClip();
        int tx = (int)Math.round(rect.getX() + rect.getWidth() / 2.0);
        int ty = (int)Math.round(rect.getY() + rect.getHeight() / 2.0);
        g2.rotate(rad, tx, ty);
        g2.setClip(clip);
        this.doDraw(g2, c);
    }

    private void doDraw(Graphics graphics, PageContainer c) {
        Rectangle rect = new Rectangle(this._objPic.getX(), this._objPic.getY(), this._objPic.getWidth(), this._objPic.getHeight());
        StyleAttributes sa = this._objPic.getStyleAttribute() == null ? Styles.getDefaultSA() : Styles.getSA((StyleAttributes)this._objPic.getStyleAttribute());
        sa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sa.setVerticalAlign(Styles.VerticalAlignment.MIDDLE);
        String text = null;
        Image image = null;
        if (this._objPic.isBindData()) {
            if (this._objPic.getBindField().getField() != null) {
                text = this._objPic.getBindField().getField().toDrawString();
            } else {
                text = RendererUtil.ErrorResult;
                sa.setFontColor(Color.RED);
            }
        } else {
            image = this._objPic.getImage() == null ? R1PrintIcons.PIC_DEFAULT.getImage() : this._objPic.getImage();
        }
        Style style = Styles.getStyle((ShareStyleAttributes)sa);
        RendererUtil.drawDashBorder(graphics, rect);
        this.drawBorder(graphics, rect, style);
        if (image == null) {
            R1PrintStringRender r1Render = R1PrintStringRender.getKeepClipInstance();
            r1Render.drawText(graphics, rect, text, style, text);
        } else {
            StyleRender.drawImange((Image)image, (Rectangle)rect, (Style)style, (int)this._objPic.getScale(), (Graphics)graphics);
        }
    }
}

