/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.r1.print.engine;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataExtend;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.data.DataParamSource;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.print.data.AbstractPrintDataProvider;
import com.kingdee.bos.ctrl.reportone.r1.print.data.IPrintVariantListener;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataParameter;
import com.kingdee.bos.ctrl.reportone.r1.print.data.SystemR1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.designer.model.R1PrintModelHelper;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.AbstractInteriorDataProviderFactory;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.data.R1PDataVisitor;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintDataException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class RuntimeModel {
    private ReportModel _reportModel;
    private HashMap _mapDataVisitor;
    private IPrintVariantListener _variantListener;
    private IRtDsInfoCreator _rtDsInfoCreator;

    public RuntimeModel(ReportModel reportModel) {
        this._reportModel = reportModel;
    }

    public ReportModel getReportModel() {
        return this._reportModel;
    }

    public void setRuntimeDsInfoCreator(IRtDsInfoCreator creator) {
        this._rtDsInfoCreator = creator;
    }

    private IRtDsInfoCreator getRuntimeDsInfoCreator() {
        if (this._rtDsInfoCreator == null) {
            this._rtDsInfoCreator = new DefaultRtDsInfoCreator();
        }
        return this._rtDsInfoCreator;
    }

    public void hookDataProvider(AbstractPrintDataProvider dataProvider) {
        this.hookDataProvider(dataProvider, null);
    }

    public void hookDataProvider(AbstractPrintDataProvider dataProvider, AbstractInteriorDataProviderFactory dpf) {
        R1PDataVisitor[] dss = this.getAllDataVisitors();
        for (int i = 0; i < dss.length; ++i) {
            R1PDataVisitor dsv = dss[i];
            dsv.setDelegate(dataProvider);
            dsv.setInteriorImpl(dpf);
        }
    }

    public void reInitialize() {
        R1PDataVisitor[] dss = this.getAllDataVisitors();
        for (int i = 0; i < dss.length; ++i) {
            R1PDataVisitor dsv = dss[i];
            dsv.reInitialize();
        }
    }

    private R1PDataVisitor[] getAllDataVisitors() {
        return this.getDataVisitors().values().toArray(new R1PDataVisitor[0]);
    }

    private HashMap getDataVisitors() {
        if (this._mapDataVisitor == null) {
            int i;
            this._mapDataVisitor = new HashMap();
            ArrayList relationCache = new ArrayList();
            DataExtend[] dataExtends = this.getReportModel().getDataManager().getDataExtends();
            for (i = 0; i < dataExtends.length; ++i) {
                DataExtend dataExt = dataExtends[i];
                this.buildDataVisitor(dataExt, relationCache);
            }
            if (relationCache.size() > 0) {
                for (i = relationCache.size() - 1; i >= 0; --i) {
                    String[] cache = (String[])relationCache.get(i);
                    R1PDataVisitor master = (R1PDataVisitor)this._mapDataVisitor.get(cache[0]);
                    R1PDataVisitor servant = (R1PDataVisitor)this._mapDataVisitor.get(cache[1]);
                    if (master == null) continue;
                    master.addRelativeDataVisitor(servant);
                }
            }
        }
        return this._mapDataVisitor;
    }

    private R1PDataVisitor buildDataVisitor(DataExtend dataExt, ArrayList relationCache) {
        SystemR1PrintDataSource dsInfo = this.getRuntimeDsInfoCreator().createDsInfo(dataExt);
        R1PDataVisitor dataVisitor = new R1PDataVisitor(dsInfo);
        List params = dataExt.getParamSources();
        for (int i = 0; i < params.size(); ++i) {
            DataParamSource designParam = (DataParamSource)((Object)params.get(i));
            SystemR1PrintDataParameter runtimeParam = new SystemR1PrintDataParameter(designParam.getName());
            String associateSource = designParam.getReferenceDataName();
            if (associateSource != null) {
                runtimeParam.setAssociateSource(associateSource);
                runtimeParam.setAssociateField(designParam.getValue());
                runtimeParam.setDelay(designParam.isDelay());
                R1PDataVisitor master = (R1PDataVisitor)this._mapDataVisitor.get(associateSource);
                if (master == null) {
                    relationCache.add(new String[]{associateSource, dsInfo.getId()});
                } else {
                    master.addRelativeDataVisitor(dataVisitor);
                }
            } else {
                runtimeParam.setValue(new Variant((Object)designParam.getValue()));
            }
            dsInfo.addParam(runtimeParam);
        }
        this._mapDataVisitor.put(dsInfo.getId(), dataVisitor);
        return dataVisitor;
    }

    private R1PDataVisitor getDataVisitor(String dataSource) {
        return (R1PDataVisitor)this.getDataVisitors().get(dataSource);
    }

    public void setVariantListener(IPrintVariantListener variantListener) {
        this._variantListener = variantListener;
    }

    public IPrintVariantListener getVariantListener() {
        return this._variantListener;
    }

    public int getRowsCount(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getRowsCount();
        }
        return 0;
    }

    public boolean hasNext(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.hasNext();
        }
        return false;
    }

    public boolean next(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.next();
        }
        return false;
    }

    public Variant getFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals((String)dataSource, (String)"context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            if ((wrapper.isDataChanged() || wrapper.isBOF()) && !wrapper.isEOF()) {
                wrapper.next();
            }
            return wrapper.getFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    public Variant getPreviousRowFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals((String)dataSource, (String)"context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getPreviousRowFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    public Variant getPropheticRowFieldData(String dataSource, String field) throws R1PrintDataException {
        if (StringUtil.equals((String)dataSource, (String)"context")) {
            return this.getSystemParamValue(dataSource, field);
        }
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getPropheticRowFieldData(field);
        }
        return Variant.getNewEmptyVariant();
    }

    private Variant getSystemParamValue(String dataSource, String field) throws R1PrintDataException {
        if (this.getVariantListener() != null) {
            return new Variant((Object)this.getVariantListener().requestVar(dataSource, field));
        }
        return null;
    }

    public int getFieldType(String dataSource, String field) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getFieldType(field);
        }
        return 0;
    }

    public boolean isEOF(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.isEOF();
        }
        return true;
    }

    public boolean isBOF(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.isBOF();
        }
        return true;
    }

    public void secondSpring(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            wrapper.secondSpring();
        }
    }

    public int getCurrentPositon(String dataSource) throws R1PrintDataException {
        R1PDataVisitor wrapper = this.getDataVisitor(dataSource);
        if (wrapper != null) {
            return wrapper.getCurrentPositon();
        }
        return -1;
    }

    private static class DefaultRtDsInfoCreator
    implements IRtDsInfoCreator {
        private DefaultRtDsInfoCreator() {
        }

        @Override
        public SystemR1PrintDataSource createDsInfo(DataExtend dataExt) {
            SystemR1PrintDataSource dsInfo = new SystemR1PrintDataSource();
            dsInfo.setId(dataExt.getName());
            dsInfo.setSortFields(R1PrintModelHelper.getDataSorts(dataExt));
            return dsInfo;
        }
    }

    public static interface IRtDsInfoCreator {
        public SystemR1PrintDataSource createDsInfo(DataExtend var1);
    }
}

