/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.r1form;

import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.r1.common.R1Exception;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.IR1DesignerOwner;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.gui.owner.R1DesignerOwnerFactory;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.ReportModel;
import com.kingdee.bos.ctrl.reportone.r1.common.designercore.model.io.ISaver;
import com.kingdee.bos.ctrl.reportone.r1.form.designer.gui.R1FormDesigner;
import com.kingdee.bos.ctrl.reportone.reportframework.IContext;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportEnv;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.UnsupportedStorageException;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import java.awt.Component;
import java.awt.Container;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class R1FormRptDesigner
extends AReportDesigner {
    private static final Logger log = LogUtil.getPackageLogger(R1FormRptDesigner.class);
    private Container editor;

    public R1FormRptDesigner(Component owner) {
        super(owner);
    }

    @Override
    public void design(boolean isNew, HashMap args) throws ReportException {
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        IReportEnv rptEnv = this.getReportEnv();
        IReportStorage rptSto = rptEnv.getReportStorage();
        if (!(rptSto instanceof IStreamStorage)) {
            throw new UnsupportedStorageException();
        }
        IR1DesignerOwner frame = R1DesignerOwnerFactory.createFrame(R1FormDesigner.class);
        R1FormDesigner fd = (R1FormDesigner)frame.getDesigner();
        this.editor = frame.getContentPane();
        IContext pubEnv = this.getReportEnv().getContext();
        if (pubEnv != null) {
            fd.setSystemParams(pubEnv.getMeta());
        }
        fd.setDataSelector(this.getObjectSelector(args));
        fd.setSaver(new Saver());
        fd.init();
        frame.setSize(800, 600);
        Object uiTitle = args.get(ReportUtil.ARG_UI_TITLE);
        fd.setTitle(uiTitle != null ? (String)uiTitle : ImplResource.getString("res_24"));
        frame.show();
        Element xmlRoot = null;
        if (isNew) {
            Object argInitReport = args.get(ReportUtil.ARG_INIT_OBJECT);
            if (argInitReport instanceof ReportModel) {
                fd.loadReport((ReportModel)argInitReport);
            } else {
                fd.newReport();
            }
        } else {
            try {
                InputStream tpl = ((IStreamStorage)rptSto).getInputStream();
                xmlRoot = XmlUtil.loadXmlStream((InputStream)tpl);
            }
            catch (Exception ex) {
                throw ReportException.makeException(ex);
            }
            try {
                fd.loadReport(xmlRoot);
            }
            catch (R1Exception e) {
                throw ReportException.makeException(e);
            }
        }
    }

    @Override
    public void close() throws ReportException {
        this.editor = null;
    }

    @Override
    public Component getComponent() throws ReportException {
        return this.editor;
    }

    private class Saver
    implements ISaver {
        private Saver() {
        }

        private boolean isUserCancel(Exception ex) {
            for (Throwable cause = ex; cause != null; cause = cause.getCause()) {
                if (!(cause instanceof UserCancelException)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean save(Element root) {
            log.debug((Object)"Save KDTable template ...");
            OutputStream out = null;
            try {
                out = ((IStreamStorage)R1FormRptDesigner.this.getReportEnv().getReportStorage()).getOutputStream();
                XmlUtil.saveXmlStream((OutputStream)out, (Element)root);
            }
            catch (Exception ex) {
                if (!this.isUserCancel(ex)) {
                    String msg = ImplResource.getString("res_21");
                    log.error((Object)msg, (Throwable)ex);
                    WindowUtil.showException((String)msg, (Throwable)ex, (String)ImplResource.getString("res_22"), (Component)R1FormRptDesigner.this.editor);
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
            R1FormRptDesigner.this.fireSaveCompleted();
            return true;
        }
    }
}

