/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.xmeta;

import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.ui.select.IObjectSelector;
import com.kingdee.bos.ctrl.common.ui.tree.DefaultNodeFilter;
import com.kingdee.bos.ctrl.common.ui.tree.INodeFilter;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.bos.ctrl.data.meta.MetaClass;
import com.kingdee.bos.ctrl.data.meta.io.Meta2Xml;
import com.kingdee.bos.ctrl.data.meta.io.Xml2Meta;
import com.kingdee.bos.ctrl.reportone.data.wizard.xmeta.MetaImportSelector;
import com.kingdee.bos.ctrl.reportone.data.wizard.xmeta.XMetaPanel;
import com.kingdee.bos.ctrl.reportone.forapp.eas.Eas_ObjectSelector;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.KDRSException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.IObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.InvalidTemplateException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import java.awt.Component;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.jdom2.Element;

public class XMetaRptDesigner
extends AReportDesigner {
    private XMetaPanel editor;

    public XMetaRptDesigner(Component owner) {
        super(owner);
    }

    private MetaClass loadMetaClass() throws ReportException {
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        if (rptSto instanceof IStreamStorage) {
            InputStream tpl = null;
            try {
                tpl = ((IStreamStorage)rptSto).getInputStream();
                Element xml = XmlUtil.loadXmlStream((InputStream)tpl);
                MetaClass metaClass = Xml2Meta.parseClass((Element)xml);
                return metaClass;
            }
            catch (Exception ex) {
                throw new InvalidTemplateException(ImplResource.getString("res_34"), ex);
            }
            finally {
                if (tpl != null) {
                    try {
                        tpl.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return (MetaClass)((IObjectStorage)rptSto).getInputObject();
    }

    private void saveMetaClass(MetaClass mc) throws ReportException {
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        if (rptSto instanceof IStreamStorage) {
            try {
                Element xml = Meta2Xml.makeClass((MetaClass)mc, null);
                XmlUtil.saveXmlStream((OutputStream)((IStreamStorage)rptSto).getOutputStream(), (Element)xml);
            }
            catch (Exception ex) {
                throw new InvalidTemplateException(ImplResource.getString("res_35"), ex);
            }
        } else {
            ((IObjectStorage)rptSto).setOutputObject(mc);
        }
    }

    @Override
    public void design(boolean isNew, HashMap args) throws ReportException {
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        MetaClass mc = null;
        if (!isNew) {
            mc = this.loadMetaClass();
        }
        SimpleDialog dlg = (SimpleDialog)WindowUtil.createWindow(SimpleDialog.class, (Component)this.owner);
        dlg.setTitle(ImplResource.getString("res_36"));
        dlg.setSize(this.DEFAULT_WINDOW_SIZE);
        Eas_ObjectSelector selector = null;
        try {
            DefaultNodeFilter filter = new DefaultNodeFilter(new Object[]{"bos-query"});
            selector = new Eas_ObjectSelector((INodeFilter)filter);
        }
        catch (KDRSException e) {
            throw ReportException.makeException("\u6784\u9020BOS\u5143\u6570\u636e\u9009\u62e9\u5668\u5931\u8d25\u3002", e);
        }
        MetaImportSelector dlgFromBos = (MetaImportSelector)((Object)WindowUtil.createWindow(MetaImportSelector.class, (Component)dlg));
        dlgFromBos.setSelector((IObjectSelector)selector);
        this.editor = new XMetaPanel(dlgFromBos);
        if (mc != null) {
            this.editor.setMetaClass(mc);
        }
        dlg.setComponent((Component)((Object)this.editor));
        if (!dlg.showDialog()) {
            this.fireWindowClosed();
            throw new UserCancelException();
        }
        mc = this.editor.makeMetaClass();
        this.saveMetaClass(mc);
        this.fireSaveCompleted();
        this.fireWindowClosed();
    }
}

