/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.reportone.reportimpl.xmltable;

import com.kingdee.bos.ctrl.common.ui.SimpleDialog;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.reportone.data.wizard.common.CustomRowsEditor;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.AlreadyOpenedException;
import com.kingdee.bos.ctrl.reportone.kdrs.exception.UserCancelException;
import com.kingdee.bos.ctrl.reportone.reportframework.IObjectStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IReportStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.IStreamStorage;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportException;
import com.kingdee.bos.ctrl.reportone.reportframework.ReportUtil;
import com.kingdee.bos.ctrl.reportone.reportframework.design.AReportDesigner;
import com.kingdee.bos.ctrl.reportone.reportimpl.ImplResource;
import com.kingdee.bos.ctrl.reportone.reportimpl.xmltable.XmlTableObjectStorage;
import java.awt.Component;
import java.util.HashMap;
import org.jdom2.Element;

public class XmlTableRptDesigner
extends AReportDesigner {
    private CustomRowsEditor editor;

    public XmlTableRptDesigner(Component owner) {
        super(owner);
    }

    @Override
    public void design(boolean isNew, HashMap args) throws ReportException {
        if (this.editor != null) {
            throw new AlreadyOpenedException();
        }
        IObjectStorage objSto = this.getObjectStorage();
        this.editor = new CustomRowsEditor();
        if (!isNew) {
            try {
                CustomRowsEditor.XmlIO.loadXml(this.editor, (Element)objSto.getInputObject());
            }
            catch (Exception ex) {
                throw ReportException.makeException(ImplResource.getString("res_37"), ex);
            }
        }
        SimpleDialog wzdWnd = (SimpleDialog)WindowUtil.createWindow(SimpleDialog.class, (Component)this.owner);
        wzdWnd.setSize(this.DEFAULT_WINDOW_SIZE);
        wzdWnd.setComponent((Component)this.editor.getComponent());
        Object uiTitle = args.get(ReportUtil.ARG_UI_TITLE);
        wzdWnd.setTitle(uiTitle != null ? (String)uiTitle : ImplResource.getString("res_38"));
        if (!wzdWnd.showDialog()) {
            this.fireWindowClosed();
            throw new UserCancelException();
        }
        try {
            objSto.setOutputObject(CustomRowsEditor.XmlIO.toXml(this.editor));
        }
        catch (Exception ex) {
            throw ReportException.makeException(ImplResource.getString("res_39"), ex);
        }
        this.fireSaveCompleted();
        this.fireWindowClosed();
    }

    private IObjectStorage getObjectStorage() {
        IReportStorage rptSto = this.getReportEnv().getReportStorage();
        if (rptSto instanceof IStreamStorage) {
            return new XmlTableObjectStorage((IStreamStorage)rptSto);
        }
        return (IObjectStorage)rptSto;
    }
}

