/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.io.BookIOController;
import com.kingdee.bos.ctrl.excel.io.BookIOException;
import com.kingdee.bos.ctrl.excel.io.htm.BookToXslHtm;
import com.kingdee.bos.ctrl.excel.io.kds.BookToKds;
import com.kingdee.bos.ctrl.excel.io.kds.KDSAreaReader;
import com.kingdee.bos.ctrl.excel.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.excel.io.kml.BookToKml;
import com.kingdee.bos.ctrl.excel.io.kml.KmlAreaReader;
import com.kingdee.bos.ctrl.excel.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.excel.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.excel.io.table.KdfToBook;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.kdf.table.KDFAreaReader;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;

public final class BookIOUtil {
    public static final byte FILE_TYPE_XLS = 0;
    public static final byte FILE_TYPE_KDS = 1;
    public static final byte FILE_TYPE_KDF = 2;
    public static final byte FILE_TYPE_PDF = 3;
    private static final String SpreadMagic = "###KDSpread1.0###";
    private static final String KDSBinary = "###KDSpread2.0###";
    public static boolean File_Default;
    public static boolean File_KDS;

    public static void main(String[] args) throws IOException, KDFException, KDFSAXException, Exception {
        BookIOUtil.loadPackFileToFile("d:\\a.bin", "d:\\a.xml");
    }

    public static byte getFileType(InputStream is) {
        try {
            byte[] b = new byte[80];
            is.read(b, 0, 80);
            if (new String(b).indexOf("progid=\"Excel.Sheet\"") >= 0) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void loadSomeCellValues(byte[] bytes, HashMap cells) throws BookIOException, KDFSAXException {
        ZipUtil.UnpackResult ur = null;
        try {
            ur = ZipUtil.unpackWithMagic((byte[])bytes);
        }
        catch (IOException e) {
            throw new BookIOException((Throwable)e);
        }
        if (SpreadMagic.equals(ur.getMagicCode())) {
            try {
                new KmlAreaReader().load(ur.getInputStream(), cells);
            }
            catch (Exception e) {
                throw new BookIOException((Throwable)e);
            }
        } else if ("###PACKER4.0.1###".equals(ur.getMagicCode())) {
            KDFAreaReader kdf2 = new KDFAreaReader();
            kdf2.setCondition(cells);
            kdf2.load(ur.getInputStream());
        } else if (KDSBinary.equals(ur.getMagicCode())) {
            new KDSAreaReader().loadValues(ur.getInputStream(), cells);
        }
    }

    public static Book loadPackFile(String file) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.loadPackFile(file, null);
    }

    public static Book loadFile(String file) throws IOException, KDFException, Exception {
        return BookIOUtil.loadFile(file, null);
    }

    public static Book loadFile(String file, BookIOController ctrl, BookKdfIOController ctrl2) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.loadFile(file, ctrl, ctrl2, null);
    }

    public static Book unpack(byte[] source) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, null, null, null);
    }

    public static Book unpack(byte[] source, BookIOController ctrl, BookKdfIOController ctrl2) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, ctrl, ctrl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Book loadPackFile(String file, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        Book book2;
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            byte[] bytes = CtrlUtil.Stream.readInputStream((InputStream)fs);
            book2 = BookIOUtil.unpack(bytes, book);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fs});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fs});
        return book2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPackFileToFile(String file, String dstFile) throws IOException, KDFException, KDFSAXException, Exception {
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            byte[] bytes = CtrlUtil.Stream.readInputStream((InputStream)fs);
            ZipUtil.UnpackResult ur = ZipUtil.unpackWithMagic((byte[])bytes);
            CtrlUtil.Stream.forwardStream((InputStream)ur.getInputStream(), (OutputStream)new FileOutputStream(dstFile));
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fs});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fs});
    }

    public static Book loadFile(String file, Book book) throws IOException, KDFException, Exception {
        block5: {
            byte type;
            FileInputStream is;
            block4: {
                Book book2;
                is = null;
                type = 1;
                try {
                    is = new FileInputStream(file);
                    type = BookIOUtil.getFileType(is);
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    is = new FileInputStream(file);
                    if (type != 1) break block4;
                    KmlToBook kb = new KmlToBook();
                    kb.load((InputStream)is, book);
                    book2 = kb.getBook();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{is});
                return book2;
            }
            if (type != 2) break block5;
            KDF kdf = new KDF((InputStream)is);
            Book book3 = new KdfToBook().getBook(kdf, book);
            CloseUtil.close((Closeable[])new Closeable[]{is});
            return book3;
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6");
    }

    public static Book loadFile(String file, BookIOController ctrl, BookKdfIOController ctrl2, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        block8: {
            KdfToBook ktb;
            FileInputStream is;
            block9: {
                byte type;
                block7: {
                    Book book2;
                    is = null;
                    type = 1;
                    try {
                        is = new FileInputStream(file);
                        type = BookIOUtil.getFileType(is);
                        CloseUtil.close((Closeable[])new Closeable[]{is});
                        is = new FileInputStream(file);
                        if (type != 1) break block7;
                        KmlToBook kb = new KmlToBook();
                        kb.setIOController(ctrl);
                        kb.load((InputStream)is, book);
                        book2 = kb.getBook();
                    }
                    catch (Throwable throwable) {
                        CloseUtil.close((Closeable[])new Closeable[]{is});
                        throw throwable;
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    return book2;
                }
                if (type != 2) break block8;
                ktb = new KdfToBook();
                ktb.setIOController(ctrl2);
                if (ctrl == null || ctrl.getIOMode() == BookIOController.FLAG_ALL) break block9;
                int mode = ctrl.getIOMode();
                if ((mode & 8) != 0) {
                    mode -= 8;
                }
                if ((mode & 0x10) != 0) {
                    mode -= 16;
                }
                KDFSAX sax = new KDFSAX(mode);
                sax.load((InputStream)is);
                Book book3 = ktb.getBook(sax, book);
                CloseUtil.close((Closeable[])new Closeable[]{is});
                return book3;
            }
            Book book4 = ktb.getBook(new KDF((InputStream)is), book);
            CloseUtil.close((Closeable[])new Closeable[]{is});
            return book4;
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6");
    }

    public static Book unpack(byte[] source, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, null, null, book);
    }

    public static Book unpack(byte[] source, BookIOController ctrl, BookKdfIOController ctrl2, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        ZipUtil.UnpackResult ur = ZipUtil.unpackWithMagic((byte[])source);
        if (KDSBinary.equals(ur.getMagicCode())) {
            KdsToBook ktb = new KdsToBook();
            ktb.setBookIOController(ctrl);
            return ktb.load(ur.getInputStream());
        }
        if (SpreadMagic.equals(ur.getMagicCode())) {
            KmlToBook ktb = new KmlToBook();
            ktb.setIOController(ctrl);
            ktb.load(ur.getInputStream(), book);
            return ktb.getBook();
        }
        if ("###PACKER4.0.1###".equals(ur.getMagicCode())) {
            KdfToBook ktb = new KdfToBook();
            ktb.setIOController(ctrl2);
            if (ctrl != null && ctrl.getIOMode() != BookIOController.FLAG_ALL) {
                int mode = ctrl.getIOMode();
                if ((mode & 8) != 0) {
                    mode -= 8;
                }
                if ((mode & 0x10) != 0) {
                    mode -= 16;
                }
                KDFSAX sax = new KDFSAX(mode);
                sax.load(ur.getInputStream());
                return ktb.getBook(sax, book);
            }
            return ktb.getBook(new KDF(ur.getInputStream()), book);
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6\u7684\u538b\u7f29\u6d41");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToPackFile(Book book, String fileName) throws IOException {
        FileOutputStream fos = null;
        try {
            byte[] bytes = BookIOUtil.pack(book);
            fos = new FileOutputStream(fileName);
            fos.write(bytes);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    public static void saveToFile(Book book, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, null, fileName, null);
    }

    public static void saveToFile(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, null, fileName, sheetNames);
    }

    public static void saveToFile(Book book, BookIOController ctrl, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, ctrl, fileName, null);
    }

    public static void saveToFile(Book book, BookIOController ctrl, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookToKml btk = new BookToKml();
        btk.setBookIOController(ctrl);
        btk.export(book, fileName, sheetNames);
    }

    public static void saveToHtmFile(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookIOUtil.saveToHtmFile(book, null, fileName, sheetNames);
    }

    public static void saveToHtmFile(Book book, BookIOController ctrl, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToHtmFile(book, ctrl, fileName, null);
    }

    public static void saveToHtmFile(Book book, BookIOController ctrl, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookToXslHtm btHtm = new BookToXslHtm();
        btHtm.setBookIOController(ctrl);
        btHtm.export(book, fileName, sheetNames);
    }

    public static byte[] pack(Book book) throws IOException {
        return BookIOUtil.pack(book, null, null);
    }

    public static byte[] pack(Book book, String[] sheetNames) throws IOException {
        return BookIOUtil.pack(book, sheetNames, null);
    }

    public static byte[] pack(Book book, BookIOController ctrl) throws IOException {
        return BookIOUtil.pack(book, null, ctrl);
    }

    public static byte[] pack(Book book, String[] sheetNames, BookIOController ctrl) throws IOException {
        SectionByteOutputStream os = new SectionByteOutputStream();
        if (File_KDS) {
            KDSDataOutputStream kdo = new KDSDataOutputStream((OutputStream)os);
            BookToKds btk = new BookToKds();
            btk.setBookIOController(ctrl);
            btk.export(book, kdo);
            kdo.flush();
            return ZipUtil.pack((SectionByteOutputStream)os, (String)KDSBinary);
        }
        BookToKml btk = new BookToKml();
        btk.setBookIOController(ctrl);
        btk.export(book, (OutputStream)os, sheetNames);
        return ZipUtil.pack((SectionByteOutputStream)os, (String)SpreadMagic);
    }

    static {
        File_KDS = File_Default = true;
    }
}

