/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.io.kds;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UnitConverter;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Span;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.ConditionalFormatVO;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.Condition;
import com.kingdee.bos.ctrl.excel.model.struct.cformat.util.ConditionVO;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidateVO;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.Validate;
import com.kingdee.bos.ctrl.kdf.kds.KDSAttributeSpan;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.kds.ViewSplitInfoVO;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;

public class KDSBookToBook {
    public static Book traslate(KDSBook kdsbook) {
        Book book = Book.Manager.getNewBook(null, (int)0);
        KDSBookToBook.traslate(kdsbook, book);
        return book;
    }

    public static void traslate(KDSBook kdsbook, Book book) {
        if (book == null) {
            book = Book.Manager.getNewBook((String)"", (int)0);
        }
        book.setAutoCalculate(false);
        book.getUndoManager().enable(false);
        book.setSkipListeners(true);
        int count = kdsbook.getSheetCount();
        for (int i = 0; i < count; ++i) {
            KDSSheet kdssheet = kdsbook.getSheet((Object)new Integer(i));
            if (kdssheet == null) continue;
            Sheet sheet = new Sheet(book, kdssheet.getName());
            book.addSheet(sheet, i == 0);
            KDSBookToBook.traslateSheet(kdssheet, sheet);
        }
        book.updatePendingSheet();
        book.clearEmptyCells();
        book.setAutoCalculate(true);
        book.getUndoManager().enable(true);
        book.setSkipListeners(false);
        KDSBookToBook.buildBorders(book);
    }

    private static void buildBorders(Book book) {
        int sheetCount = book.getSheetCount();
        for (int i = 0; i < sheetCount; ++i) {
            Sheet sheet = book.getSheet(i);
            sheet.createCellsFromBorders(sheet.getBorders().getRoot(true), CellBlock.getNewCellBlock((int)0, (int)0, (int)1048575, (int)16383), true, 0, 0);
            sheet.createCellsFromBorders(sheet.getBorders().getRoot(false), CellBlock.getNewCellBlock((int)0, (int)0, (int)1048575, (int)16383), false, 0, 0);
        }
    }

    private static void traslateSheet(KDSSheet kdssheet, Sheet sheet) {
        KDSBookToBook.translateColumns(kdssheet, sheet);
        KDSBookToBook.translateRows(kdssheet, sheet);
        KDSBookToBook.translateCells(kdssheet, sheet);
        KDSBookToBook.translateMerger(kdssheet, sheet);
        KDSBookToBook.translateConditionalFormats(kdssheet, sheet);
        sheet.setValidations(kdssheet.getValidationList());
        KDSBookToBook.translateValidations(kdssheet, sheet);
        KDSBookToBook.translateSheetView(kdssheet, sheet);
    }

    private static void translateColumns(KDSSheet kdssheet, Sheet sheet) {
        if (null != kdssheet.getColSpans() && !kdssheet.getColSpans().isEmpty()) {
            for (Object sp : kdssheet.getColSpans()) {
                KDSAttributeSpan kdSpan = (KDSAttributeSpan)sp;
                double colWidth = UnitConverter.mmToPx((double)kdSpan.getOriginalLength());
                sheet.getColSpans().setSpanAttribute(new Span(kdSpan.getStart(), kdSpan.getEnd()), kdSpan.getSSA(), kdSpan.getOriginalLength() <= 0 ? null : new Integer((int)colWidth), Boolean.valueOf(kdSpan.isVisible()), Integer.valueOf(kdSpan.getOutlineGroupLevel()), Boolean.valueOf(kdSpan.isCollapse()), false);
            }
        } else {
            int size = kdssheet.getExpandedColumns() + 1;
            for (int i = 0; i < size; ++i) {
                double colWidth = UnitConverter.mmToPx((double)kdssheet.getColumnWidth(i));
                sheet.getColSpans().setSpanAttribute(new Span(i, i), kdssheet.getColumnShareStyleAttributes(i), colWidth <= 0.0 ? null : new Integer((int)colWidth), null, null, null, false);
            }
        }
    }

    private static void translateRows(KDSSheet kdssheet, Sheet sheet) {
        if (null != kdssheet.getRowSpans() && !kdssheet.getRowSpans().isEmpty()) {
            for (Object sp : kdssheet.getRowSpans()) {
                KDSAttributeSpan kdSpan = (KDSAttributeSpan)sp;
                double rowHeight = UnitConverter.mmToPx((double)kdSpan.getOriginalLength());
                sheet.getRowSpans().setSpanAttribute(new Span(kdSpan.getStart(), kdSpan.getEnd()), kdSpan.getSSA(), kdSpan.getOriginalLength() <= 0 ? null : new Integer((int)rowHeight), Boolean.valueOf(kdSpan.isVisible()), Integer.valueOf(kdSpan.getOutlineGroupLevel()), Boolean.valueOf(kdSpan.isCollapse()), false);
            }
        } else {
            int size = kdssheet.getExpandedRows() + 1;
            for (int i = 0; i < size; ++i) {
                double rowHeight = UnitConverter.mmToPx((double)kdssheet.getRowHeight(i));
                sheet.getRowSpans().setSpanAttribute(new Span(i, i), kdssheet.getRowShareStyleAttributes(i), rowHeight <= 0.0 ? null : new Integer((int)rowHeight), null, null, null, false);
            }
        }
    }

    private static void translateCells(KDSSheet kdssheet, Sheet sheet) {
        int colCount = kdssheet.getExpandedColumns() + 1;
        int rowCount = kdssheet.getExpandedRows() + 1;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                KDSCell kdscell = kdssheet.getCell(i, j, false);
                if (KDSSheet.isEmptyCell((KDSCell)kdscell)) continue;
                KDSMergeBlock smb = kdssheet.getMerges().getMergeBlock(i, j);
                if (smb == KDSMergeBlock.NULL_MERGE || smb.row == i && smb.col == j) {
                    Object value;
                    Cell cell = sheet.getCell(i, j, true);
                    cell.setSSA(kdscell.getSSA());
                    String formula = kdscell.getFormula();
                    if (!StringUtil.isEmptyString((String)formula)) {
                        if (formula.charAt(0) != '=') {
                            formula = "=" + formula;
                        }
                        cell.setFormula(formula);
                    }
                    if ((value = kdscell.getValue()) instanceof String) {
                        if (!StringUtil.isEmptyString((String)((String)value))) {
                            String fmt = kdscell.getStyle() == null ? null : kdscell.getStyle().getNumberFormat();
                            boolean parseDate = kdscell.getType() == 6;
                            Variant var = Cell.parseValue((String)((String)value), (String)fmt, (boolean)parseDate);
                            cell.setValue(var);
                        }
                    } else {
                        Variant var;
                        if (value instanceof Calendar) {
                            kdscell.setType((short)6);
                        }
                        switch (kdscell.getType()) {
                            case 0: {
                                var = new Variant((Object)new BigDecimal((String)value), 10);
                                break;
                            }
                            case 1: {
                                var = new Variant(value, 11);
                                break;
                            }
                            case 6: {
                                var = new Variant(value, 13);
                                break;
                            }
                            case 4: {
                                var = new Variant((Object)Boolean.valueOf((String)value), 8);
                                break;
                            }
                            default: {
                                var = new Variant(value);
                            }
                        }
                        cell.setValue(var);
                    }
                    if (kdscell.getHyperLink() == null || StringUtil.isEmptyString((String)kdscell.getHyperLink().getLinkTo())) continue;
                    cell.setHyperLink(kdscell.getHyperLink());
                    continue;
                }
                KDSCell tempCell = new KDSCell(null, Styles.getEmptySSA(), Styles.getStyle((ShareStyleAttributes)Styles.getEmptySSA()));
                StyleAttributes sa = Styles.getSA((ShareStyleAttributes)tempCell.getSSA());
                KDSCell cellFirst = kdssheet.getCell(smb.row, smb.col, false);
                KDSCell cellLast = kdssheet.getCell(smb.getRow2(), smb.getCol2(), false);
                ShareStyleAttributes ssaFirst = cellFirst.getSSA();
                ShareStyleAttributes ssaLast = cellLast.getSSA();
                sa.setBorder(Styles.Position.LEFT, ssaFirst);
                sa.setBorder(Styles.Position.TOP, ssaFirst);
                sa.setBorder(Styles.Position.RIGHT, ssaLast);
                sa.setBorder(Styles.Position.BOTTOM, ssaLast);
                Cell cell = sheet.getCell(i, j, true);
                sheet.getRange(cell).setStyle(sa, Styles.getEmptySA());
            }
        }
    }

    private static void translateMerger(KDSSheet kdssheet, Sheet sheet) {
        MergeBlocks merger = null;
        for (KDSMergeBlock block : kdssheet.getMerges()) {
            if (merger == null) {
                merger = sheet.getSheetOption().getMerger(true);
            }
            merger.insert((Object)CellBlock.getNewCellBlock((int)block.row, (int)block.col, (int)block.getRow2(), (int)block.getCol2()));
        }
    }

    private static void translateConditionalFormats(KDSSheet kdSheet, Sheet sheet) {
        List formatVOs = kdSheet.getConditionFromats();
        for (ConditionalFormatVO vo : formatVOs) {
            Condition[] conditions = new Condition[vo.getCondtionVOs().size()];
            for (int i = 0; i < vo.getCondtionVOs().size(); ++i) {
                ConditionVO conditionVO = (ConditionVO)vo.getCondtionVOs().get(i);
                Condition condition = new Condition();
                condition.setType(conditionVO.getType());
                condition.setQualifier(conditionVO.getQualifier());
                condition.setMinMax(conditionVO.getMin(), conditionVO.getMax(), sheet);
                conditions[i] = condition;
            }
            sheet.getConditionalFormats().insertConditionalFormat(conditions, vo.getShareStyleAttributes().toArray(new ShareStyleAttributes[0]), SheetBaseMath.getSortedBlockNodes((Sheet)sheet, (String)vo.getSqref(), (boolean)true));
        }
    }

    private static void translateSheetView(KDSSheet kdSheet, Sheet sheet) {
        ViewSplitInfoVO vo = kdSheet.getViewSplitInfo();
        if (null != vo) {
            ViewSplitInfo info = sheet.getSheetOption().getViewSplitInfo();
            info.setColFixLine(vo.getColFixLine());
            info.setRowFixLine(vo.getRowFixLine());
            info.setFreezed(vo.isFreezed());
            info.setActivePane(vo.getActivePane());
            info.setRowSplit(vo.getRowSplit());
            info.setColSplit(vo.getColSplit());
        }
    }

    private static void translateValidations(KDSSheet kdSheet, Sheet sheet) {
        List validateVOs = kdSheet.getMessagedValidateVOs();
        for (MessagedValidateVO validateVO : validateVOs) {
            MessagedValidate validate = new MessagedValidate();
            validate.setType(validateVO.getType());
            if (validateVO.getType().equals(Validate.Type_List)) {
                validate.setCellRangeList(true);
            }
            validate.setErrorMessage(validateVO.getError());
            validate.setInputHide(validateVO.isShowInputMessage());
            validate.setUseBlank(!validateVO.isAllowBlank());
            validate.setErrorStyle(MessagedValidate.getKDSErrorStyle((String)validateVO.getErrorStyle()));
            validate.setErrorTitle(validateVO.getErrorTitle());
            validate.setInputTitle(validateVO.getPromptTitle());
            validate.setInputMessage(validateVO.getPrompt());
            validate.setQualifier(validateVO.getOperator());
            validate.setMin(validateVO.getMin());
            validate.setMax(validateVO.getMax());
            sheet.getValidations().insertValidation(validate, SheetBaseMath.getSortedBlockNodes((Sheet)sheet, (String)validateVO.getSqref(), (boolean)true));
        }
    }
}

