/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder;

import com.kingdee.bos.invokecounter.RPCLogEventQueue;
import com.kingdee.bos.rpc.impl.RPCRecordStatus;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.eas.client.recorder.Utils;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Stack;
import org.apache.log4j.Logger;

public class UserInputEventQueue
extends RPCLogEventQueue {
    private static Logger logger = Logger.getLogger(UserInputEventQueue.class);
    private static Stack eventStack = new Stack();
    private static Stack statusStack = new Stack();
    RPCLogEventQueue old;
    private Method dispatchMethod = null;

    public UserInputEventQueue(RPCLogEventQueue old) {
        this.old = old;
    }

    public UserInputEventQueue() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchEvent(AWTEvent event) {
        if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            int mask = 10;
            if (ke.getKeyCode() == 93 && (ke.getModifiers() & mask) == mask) {
                Utils.createRecorderWindowAsDialog();
                return;
            }
        }
        if (!RPCRecordStatus.isOn()) {
            this.myDispatchEvent(event);
            return;
        }
        boolean isUserInput = event.getID() == 502 || event.getID() == 501 || event.getID() == 500 || event.getID() == 402 || event.getID() == 401 || event.getID() == 400 || event.getID() == 201 || event.getID() == 202;
        try {
            statusStack.push(isUserInput);
            eventStack.push(event);
            this.setStatus(isUserInput);
            if (isUserInput) {
                String type = event.paramString();
                int id = event.hashCode();
                RPCRecordStatus.setCurrentEventInfo((RPCRequest.EventInfo)new RPCRequest.EventInfo(type, id));
            }
            this.myDispatchEvent(event);
        }
        finally {
            eventStack.pop();
            statusStack.pop();
            if (!eventStack.isEmpty()) {
                Boolean b = (Boolean)statusStack.peek();
                this.setStatus(b);
            }
        }
    }

    private void myDispatchEvent(AWTEvent event) {
        if (this.old == null) {
            super.dispatchEvent(event);
        } else {
            if (this.dispatchMethod == null) {
                try {
                    this.dispatchMethod = this.old.getClass().getDeclaredMethod("dispatchEvent", AWTEvent.class);
                    this.dispatchMethod.setAccessible(true);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
            }
            try {
                this.dispatchMethod.invoke((Object)this.old, event);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void setStatus(boolean on) {
        if (on) {
            RPCRecordStatus.turnOnThread();
        } else {
            RPCRecordStatus.turnOffThread();
        }
    }
}

