/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder;

import com.kingdee.bos.RemoteBOSObjectFactory;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.invokecounter.RPCLogEventQueue;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.rpc.impl.RPCRequest;
import com.kingdee.bos.rpc.impl.RPCSessionImpl;
import com.kingdee.bos.rpcrecorder.IValueJudge;
import com.kingdee.bos.rpcrecorder.Play;
import com.kingdee.bos.rpcrecorder.SerdeTool;
import com.kingdee.bos.rpcwrapper.ISession;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.SystemEntry;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.client.recorder.EASValueJudge;
import com.kingdee.eas.client.recorder.RecorderUI;
import com.kingdee.eas.client.recorder.UserInputEventQueue;
import com.kingdee.eas.client.recorder.serde.SerdeRegister;
import com.kingdee.eas.client.recorder.udf.UDFRegister;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Utils {
    private static JFrame easMainFrame;
    public static Window recorderWindow;

    public static void touch() {
    }

    public static boolean tryFocus() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != null;
    }

    public static JDialog getParentDialog() {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        do {
            if (!(parent instanceof JDialog)) continue;
            return (JDialog)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static Window getParentWindow() {
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        do {
            if (parent instanceof JDialog) {
                return (JDialog)parent;
            }
            if (!(parent instanceof JDialog)) continue;
            return (JFrame)parent;
        } while ((parent = parent.getParent()) != null);
        return null;
    }

    public static JFrame getMainFrame() {
        if (easMainFrame != null) {
            return easMainFrame;
        }
        Window window = null;
        window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (window == null) {
            return null;
        }
        Container parent = window;
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        if (!(parent instanceof NewMainFrame)) {
            return null;
        }
        easMainFrame = (JFrame)parent;
        return easMainFrame;
    }

    public static void createRecorderWindowAsDialog() {
        JDialog parent = Utils.getParentDialog();
        Utils.createRecorderWindow(RecorderUI.instance, parent);
    }

    public static void createRecorderWindow() {
        Utils.createRecorderWindow(RecorderUI.instance, null);
    }

    public static void createRecorderWindow(RecorderUI ui, JDialog parent) {
        if (recorderWindow != null && recorderWindow.isVisible()) {
            return;
        }
        KDDialog dialog = null;
        if (parent != null) {
            dialog = new KDDialog((Dialog)parent, "EAS\u5f55\u5236\u56de\u653e");
        }
        if (dialog == null) {
            dialog = new KDFrame("EAS\u5f55\u5236\u56de\u653e");
        }
        dialog.setPreferredSize(new Dimension(520, 100));
        dialog.setLayout(new BorderLayout());
        dialog.add((Component)((Object)ui), "Center");
        dialog.pack();
        Utils.makeCenter((Window)dialog);
        if (dialog instanceof JFrame) {
            ((JFrame)dialog).setDefaultCloseOperation(2);
        }
        dialog.setVisible(true);
        recorderWindow = dialog;
    }

    public static void makeCenter(Window wnd) {
        Rectangle rc = new Rectangle(wnd.getBounds());
        Dimension sz = Toolkit.getDefaultToolkit().getScreenSize();
        rc.x = (sz.width - rc.width) / 2;
        rc.y = (sz.height - rc.height) / 2;
        wnd.setBounds(rc);
    }

    public static String formatCurrentTime() {
        return Utils.formatTime(System.currentTimeMillis());
    }

    public static String formatTime(long t) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        return df.format(new Date(t));
    }

    public static String formatMillisTime(long t) {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss-SSS");
        return df.format(new Date(t));
    }

    public static void saveRPCRequest(RPCRequest request, String fileName) throws IOException {
        Utils.saveBinaryObject(request, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBinaryObject(Object object, String fileName) throws IOException {
        FileOutputStream file = null;
        ObjectOutputStream oos = null;
        try {
            file = new FileOutputStream(fileName);
            oos = new ObjectOutputStream(file);
            oos.writeObject(object);
            oos.flush();
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Throwable throwable) {}
            }
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadBinaryObject(String fileName) throws IOException, ClassNotFoundException {
        FileInputStream file = null;
        ObjectInputStream in = null;
        try {
            Object o;
            file = new FileInputStream(fileName);
            in = new ObjectInputStream(file);
            Object object = o = in.readObject();
            return object;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Throwable throwable) {}
            }
            if (in != null) {
                in.close();
            }
        }
    }

    public static RPCSessionImpl getCurrentSession() {
        String url = UIConfig.getUrl();
        ISession session = RemoteBOSObjectFactory.getInstance((String)url).getSession();
        RPCSessionImpl session2 = (RPCSessionImpl)session.getDelegate();
        return session2;
    }

    public static RPCSessionImpl login(String url, String user, String pwd, String datacenter) throws Exception {
        return Utils.login(url, user, pwd, "eas", datacenter, "l2");
    }

    public static RPCSessionImpl login(String url, String user, String pwd, String solution, String datacenter, String locale) throws Exception {
        MetaDataLoaderFactory.setClientMetaDataPath((String)Utils.getMetadataPath());
        SystemEntry.instance.setStartMode(0);
        SystemEntry.instance.initSystem(url, false);
        SystemEntry.instance.login(user, pwd, solution, datacenter, new Locale(locale), 2, null);
        return Utils.getCurrentSession();
    }

    public static void logout() throws Exception {
        SystemEntry.instance.logout();
    }

    private static String getMetadataPath() {
        String metaDir = System.getProperty("EAS_HOME") + "/client/metas";
        String metaPath = metaDir + "/*.jar;" + metaDir + "/patch/*.jar;" + metaDir + "/sp/*.jar;" + metaDir + "/bos/*.jar;" + metaDir + "/eas/*.jar;";
        return metaPath;
    }

    public static void runScript(String fileName, Map variables) {
        RPCSessionImpl session = Utils.getCurrentSession();
        Play play = new Play(session, variables);
        play.getContext().put(IValueJudge.Factory.class, (Object)new EASValueJudge.Factory());
        play.playScript(fileName);
    }

    public static void enableRecorderInputEventQueue() {
        EventQueue old = Toolkit.getDefaultToolkit().getSystemEventQueue();
        if (old instanceof UserInputEventQueue) {
            return;
        }
        UserInputEventQueue eq = old instanceof RPCLogEventQueue ? new UserInputEventQueue((RPCLogEventQueue)old) : new UserInputEventQueue();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push((EventQueue)((Object)eq));
    }

    public static void showObjectAsXML(Object object, String prix, long time) {
        Properties prop = System.getProperties();
        String tempdir = prop.getProperty("java.io.tmpdir");
        String name = prix + Utils.formatMillisTime(time) + ".xml";
        String filename = tempdir + name;
        try {
            SerdeTool.saveObjectAsXML((Object)object, (String)filename);
            Runtime.getRuntime().exec("explorer " + filename);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getRPCObjectPath(File scriptFile) {
        String path = scriptFile.getParent();
        String name = scriptFile.getName();
        int pos = name.indexOf(".");
        if (pos < 0) {
            pos = name.length();
        }
        name = name.substring(0, pos);
        String rpcPath = path + "/" + name + "_objects";
        return new File(rpcPath);
    }

    public static File getRPCInitRequestPath(File scriptFile) {
        String path = scriptFile.getParent();
        String name = scriptFile.getName();
        int pos = name.indexOf(".");
        if (pos < 0) {
            pos = name.length();
        }
        name = name.substring(0, pos);
        String rpcPath = path + "/" + name + "_initrequest";
        return new File(rpcPath);
    }

    public static File getRPCInitResultPath(File scriptFile) {
        String path = scriptFile.getParent();
        String name = scriptFile.getName();
        int pos = name.indexOf(".");
        if (pos < 0) {
            pos = name.length();
        }
        name = name.substring(0, pos);
        String rpcPath = path + "/" + name + "_initresult";
        return new File(rpcPath);
    }

    public static String cloneUuid(String oldUuid) {
        String type = BOSUuid.read((String)oldUuid).getType().toString();
        BOSUuid uuid = BOSUuid.create((String)type);
        return uuid.toString();
    }

    static {
        UDFRegister.registerAll();
        SerdeRegister.registerAll();
        recorderWindow = null;
    }
}

