/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.client.recorder.serde;

import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.rpcrecorder.RecorderException;
import com.kingdee.bos.rpcrecorder.serde.AbstractXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.IXmlSerde;
import com.kingdee.bos.rpcrecorder.serde.SerdeContext;
import com.kingdee.bos.rpcrecorder.serde.SerdeUtils;
import com.kingdee.bos.rpcrecorder.serde.XmlSerdeFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.Uuid;
import com.kingdee.util.enums.Enum;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdom2.Content;
import org.jdom2.Element;

public class BOSSerdeProvider {
    public static void touch() {
    }

    static {
        XmlSerdeFactory.register(Uuid.class, (IXmlSerde)new UuidSerde(Uuid.class));
        XmlSerdeFactory.register(BOSUuid.class, (IXmlSerde)new BOSUuidSerde(BOSUuid.class));
        XmlSerdeFactory.register(MetaDataPK.class, (IXmlSerde)new MetaDataPKSerde(MetaDataPK.class));
        XmlSerdeFactory.register(ObjectUuidPK.class, (IXmlSerde)new ObjectUuidPKSerde(ObjectUuidPK.class));
        XmlSerdeFactory.register(BOSObjectType.class, (IXmlSerde)new BOSObjectTypeSerde(BOSObjectType.class));
        XmlSerdeFactory.register(Enum.class, (IXmlSerde)new EnumSerde(Enum.class));
        XmlSerdeFactory.register(IObjectValue.class, (IXmlSerde)new ObjectValueSerde(IObjectValue.class));
        XmlSerdeFactory.register(IObjectCollection.class, (IXmlSerde)new ObjectCollectionSerde(IObjectCollection.class));
        XmlSerdeFactory.register(Map.class, (IXmlSerde)new MapSerde(Map.class));
        XmlSerdeFactory.register(List.class, (IXmlSerde)new ListSerde(List.class));
        XmlSerdeFactory.register(Set.class, (IXmlSerde)new SetSerde(Set.class));
    }

    public static class SetSerde
    extends AbstractXmlSerde {
        protected SetSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            Set set = (Set)object;
            Element element = this.createElement();
            element.setAttribute("class", object.getClass().getName());
            if (set != null) {
                int size = set.size();
                element.setAttribute("size", "" + size);
                int index = 0;
                for (Object value : set) {
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent((Content)childEle);
                    childEle.addContent((Content)ctx.toXML(value));
                }
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String s = element.getAttributeValue("size");
            if (s == null || "".equals(s)) {
                return null;
            }
            String className = element.getAttributeValue("class");
            Set set = null;
            Class clz = null;
            try {
                clz = SerdeUtils.classForName((String)className);
                set = (Set)clz.newInstance();
            }
            catch (Throwable e) {
                throw new RecorderException(e.getMessage());
            }
            List children = element.getChildren("Child");
            for (Element childEle : children) {
                Element objectEle = (Element)childEle.getChildren().get(0);
                set.add(ctx.fromXML(objectEle));
            }
            return set;
        }

        public String getTagName() {
            return "Set";
        }

        public boolean accept(String type) {
            if ("Set".equals(type)) {
                return true;
            }
            Class clazz = null;
            Constructor ct = null;
            try {
                clazz = SerdeUtils.classForName((String)type);
                ct = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && Set.class.isAssignableFrom(clazz) && ct != null;
        }
    }

    public static class MapSerde
    extends AbstractXmlSerde {
        protected MapSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) throws RecorderException {
            Map map = (Map)object;
            Element element = this.createElement();
            element.setAttribute("class", object.getClass().getName());
            if (map != null) {
                TreeMap tmap;
                int size = map.size();
                element.setAttribute("size", "" + size);
                int index = 0;
                for (Map.Entry entry : map.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent((Content)childEle);
                    Element keyEle = new Element("Key");
                    Element valueEle = new Element("Value");
                    childEle.addContent((Content)keyEle);
                    childEle.addContent((Content)valueEle);
                    keyEle.addContent((Content)ctx.toXML(key));
                    valueEle.addContent((Content)ctx.toXML(value));
                }
                if (map instanceof TreeMap && (tmap = (TreeMap)map).comparator() != null) {
                    Element ele = new Element("Comparator");
                    ele.setAttribute("class", tmap.comparator().getClass().getName());
                    ele.addContent((Content)ctx.toXML(tmap.comparator()));
                    element.addContent((Content)ele);
                }
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) throws RecorderException {
            String s = element.getAttributeValue("size");
            if (s == null || "".equals(s)) {
                return null;
            }
            String className = element.getAttributeValue("class");
            Map map = null;
            Class clz = null;
            try {
                clz = SerdeUtils.classForName((String)className);
                Element cele = element.getChild("Comparator");
                if (cele != null && TreeMap.class.getName().equals(className)) {
                    Comparator c = (Comparator)ctx.fromXML((Element)cele.getChildren().get(0));
                    Constructor ct = clz.getConstructor(Comparator.class);
                    map = (Map)ct.newInstance(c);
                } else {
                    map = (Map)clz.newInstance();
                }
            }
            catch (Throwable e) {
                throw new RecorderException(e.getMessage());
            }
            List children = element.getChildren("Child");
            for (Element child : children) {
                Element keyEle = child.getChild("Key");
                Element valueEle = child.getChild("Value");
                Object key = ctx.fromXML((Element)keyEle.getChildren().get(0));
                Object value = ctx.fromXML((Element)valueEle.getChildren().get(0));
                map.put(key, value);
            }
            return map;
        }

        public String getTagName() {
            return "Map";
        }

        public boolean accept(String type) {
            if ("Map".equals(type)) {
                return true;
            }
            Class clazz = null;
            Constructor ct = null;
            try {
                clazz = SerdeUtils.classForName((String)type);
                ct = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && Map.class.isAssignableFrom(clazz) && ct != null;
        }
    }

    public static class ListSerde
    extends AbstractXmlSerde {
        protected ListSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            List list = (List)object;
            Element element = this.createElement();
            element.setAttribute("class", object.getClass().getName());
            if (list != null) {
                int size = list.size();
                element.setAttribute("size", "" + size);
                int index = 0;
                for (Object value : list) {
                    Element childEle = new Element("Child");
                    childEle.setAttribute("index", "" + index++);
                    element.addContent((Content)childEle);
                    childEle.addContent((Content)ctx.toXML(value));
                }
            }
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String s = element.getAttributeValue("size");
            if (s == null || "".equals(s)) {
                return null;
            }
            String className = element.getAttributeValue("class");
            List list = null;
            Class clz = null;
            try {
                clz = SerdeUtils.classForName((String)className);
                list = (List)clz.newInstance();
            }
            catch (Throwable e) {
                throw new RecorderException(e.getMessage());
            }
            String command = element.getAttributeValue("_command_");
            List IDList = null;
            if (command != null && command.toLowerCase(Locale.ENGLISH).startsWith("ChangeChildrenUuid".toLowerCase())) {
                String var = command.substring("ChangeChildrenUuid".length() + 1);
                if (!(var = var.trim()).startsWith("$")) {
                    var = "$" + var;
                }
                if ((IDList = (List)ctx.getContext().get((Object)var)) == null) {
                    throw new RecorderException("ChangeChildrenUuid list " + var + " not found.");
                }
            }
            int index = 0;
            List children = element.getChildren("Child");
            if (IDList != null && children.size() != IDList.size()) {
                throw new RecorderException("ChangeChildrenUuid list size " + IDList.size() + " not equals to element size " + children.size());
            }
            for (Element childEle : children) {
                Element objectEle = (Element)childEle.getChildren().get(0);
                Object value = ctx.fromXML(objectEle);
                list.add(value);
                if (IDList == null || !(value instanceof IObjectValue)) continue;
                Object newId = IDList.get(index++);
                ((IObjectValue)value).put("id", newId);
            }
            return list;
        }

        public String getTagName() {
            return "List";
        }

        public boolean accept(String type) {
            if ("List".equals(type)) {
                return true;
            }
            Class clazz = null;
            Constructor ct = null;
            try {
                clazz = SerdeUtils.classForName((String)type);
                ct = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && List.class.isAssignableFrom(clazz) && ct != null;
        }
    }

    private static class UuidSerde
    extends AbstractXmlSerde {
        protected UuidSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            Uuid uuid = (Uuid)object;
            Element element = this.createElement();
            element.setAttribute("value", uuid.toString());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String value = element.getAttributeValue("value");
            return Uuid.read((String)value);
        }

        protected String getTagName() {
            return "Uuid";
        }
    }

    private static class BOSUuidSerde
    extends AbstractXmlSerde {
        protected BOSUuidSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            BOSUuid uuid = (BOSUuid)object;
            Element element = this.createElement();
            element.setAttribute("value", uuid.toString());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String value = element.getAttributeValue("value");
            return BOSUuid.read((String)value);
        }

        protected String getTagName() {
            return "BOSUuid";
        }
    }

    private static class BOSObjectTypeSerde
    extends AbstractXmlSerde {
        protected BOSObjectTypeSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            BOSObjectType value = (BOSObjectType)object;
            Element element = this.createElement();
            element.setAttribute("value", value.toString());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String value = element.getAttributeValue("value");
            return BOSObjectType.create((String)value);
        }

        protected String getTagName() {
            return "BOSObjectType";
        }
    }

    private static class ObjectUuidPKSerde
    extends AbstractXmlSerde {
        protected ObjectUuidPKSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            ObjectUuidPK value = (ObjectUuidPK)object;
            Element element = this.createElement();
            element.setAttribute("value", value.toString());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String value = element.getAttributeValue("value");
            return new ObjectUuidPK(value);
        }

        protected String getTagName() {
            return "ObjectUuidPK";
        }
    }

    private static class MetaDataPKSerde
    extends AbstractXmlSerde {
        protected MetaDataPKSerde(Class clazz) {
            super(clazz);
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            MetaDataPK value = (MetaDataPK)object;
            Element element = this.createElement();
            element.setAttribute("value", value.getFullName());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String value = element.getAttributeValue("value");
            return MetaDataPK.create((String)value);
        }

        protected String getTagName() {
            return "MetaDataPK";
        }
    }

    private static class ObjectCollectionSerde
    extends AbstractXmlSerde {
        protected ObjectCollectionSerde(Class clazz) {
            super(clazz);
        }

        public boolean isMultiMatch() {
            return true;
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            ctx.markIdentityObject(object);
            IObjectCollection objectCollection = (IObjectCollection)object;
            Element element = this.createElement();
            element.setAttribute("id", "" + SerdeUtils.identityId((Object)object));
            element.setAttribute("class", objectCollection.getClass().getName());
            Iterator iter = objectCollection.iterator();
            int index = 0;
            while (iter.hasNext()) {
                IObjectValue value = (IObjectValue)iter.next();
                if (value == null) continue;
                Element childEle = new Element("Child");
                childEle.setAttribute("index", "" + index++);
                element.addContent((Content)childEle);
                childEle.addContent((Content)ctx.toXML((Object)value));
            }
            element.setAttribute("size", "" + index);
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String clazz = element.getAttributeValue("class");
            IObjectCollection objectCollection = null;
            try {
                objectCollection = (IObjectCollection)SerdeUtils.classForName((String)clazz).newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RecorderException("Can't not instance IObjectCollection:" + clazz + ", the exeption message is:" + e.getMessage());
            }
            String id = element.getAttributeValue("id");
            ctx.markIdentityObject(id, (Object)objectCollection);
            String command = element.getAttributeValue("_command_");
            boolean cloneUuid = "cloneUuid".equalsIgnoreCase(command);
            List IDList = null;
            if (command != null && command.toLowerCase(Locale.ENGLISH).startsWith("ChangeChildrenUuid".toLowerCase())) {
                String var = command.substring("ChangeChildrenUuid".length() + 1);
                if (!(var = var.trim()).startsWith("$")) {
                    var = "$" + var;
                }
                if ((IDList = (List)ctx.getContext().get((Object)var)) == null) {
                    throw new RecorderException("ChangeChildrenUuid list " + var + " not found.");
                }
            }
            List children = element.getChildren("Child");
            if (IDList != null && children.size() != IDList.size()) {
                throw new RecorderException("ChangeChildrenUuid list size " + IDList.size() + " not equals to element size " + children.size());
            }
            int index = 0;
            for (Element child : children) {
                Object value = ctx.fromXML((Element)child.getChildren().get(0));
                IObjectValue ov = (IObjectValue)value;
                objectCollection.addObjectDirect(ov);
                if (cloneUuid) {
                    BOSUuid uuid = (BOSUuid)ov.get("id");
                    if (uuid == null) continue;
                    String type = uuid.getType().toString();
                    BOSUuid newUuid = BOSUuid.create((String)type);
                    ov.put("id", (Object)newUuid);
                    System.out.println("Replace uuid " + uuid + " to " + newUuid);
                    continue;
                }
                if (IDList == null || !(value instanceof IObjectValue)) continue;
                Object newId = IDList.get(index++);
                ((IObjectValue)value).put("id", newId);
            }
            return objectCollection;
        }

        protected String getTagName() {
            return "ObjectCollection";
        }

        public boolean accept(String type) {
            if ("ObjectCollection".equals(type)) {
                return true;
            }
            Class clazz = null;
            try {
                clazz = SerdeUtils.classForName((String)type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && IObjectCollection.class.isAssignableFrom(clazz);
        }
    }

    private static class ObjectValueSerde
    extends AbstractXmlSerde {
        protected ObjectValueSerde(Class clazz) {
            super(clazz);
        }

        public boolean isMultiMatch() {
            return true;
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            ctx.markIdentityObject(object);
            IObjectValue objectValue = (IObjectValue)object;
            Element element = this.createElement();
            element.setAttribute("id", "" + SerdeUtils.identityId((Object)object));
            element.setAttribute("class", objectValue.getClass().getName());
            Enumeration em = objectValue.keys();
            int index = 0;
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                Object value = objectValue.get(key);
                if (value == null) continue;
                Element childEle = new Element("Property");
                childEle.setAttribute("index", "" + index++);
                element.addContent((Content)childEle);
                childEle.setAttribute("key", key);
                childEle.addContent((Content)ctx.toXML(value));
            }
            element.setAttribute("size", "" + index);
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            String clazz = element.getAttributeValue("class");
            IObjectValue objectValue = null;
            try {
                objectValue = (IObjectValue)SerdeUtils.classForName((String)clazz).newInstance();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RecorderException("Can't not instance IObjectValue:" + clazz + ", the exeption message is:" + e.getMessage());
            }
            String id = element.getAttributeValue("id");
            ctx.markIdentityObject(id, (Object)objectValue);
            List children = element.getChildren("Property");
            for (Element child : children) {
                String key = child.getAttributeValue("key");
                Object value = ctx.fromXML((Element)child.getChildren().get(0));
                objectValue.put(key, value);
            }
            return objectValue;
        }

        protected String getTagName() {
            return "ObjectValue";
        }

        public boolean accept(String type) {
            if ("ObjectValue".equals(type)) {
                return true;
            }
            Class clazz = null;
            try {
                clazz = SerdeUtils.classForName((String)type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && IObjectValue.class.isAssignableFrom(clazz);
        }
    }

    private static class EnumSerde
    extends AbstractXmlSerde {
        protected EnumSerde(Class clazz) {
            super(clazz);
        }

        public boolean isMultiMatch() {
            return true;
        }

        public Element toXML(SerdeContext ctx, Class clazz, Object object) {
            Element element = this.createElement();
            Enum en = (Enum)object;
            element.setAttribute("class", object.getClass().getName());
            element.setAttribute("name", en.getName());
            return element;
        }

        public Object fromXML(SerdeContext ctx, Element element) {
            Enum en;
            String className = element.getAttributeValue("class");
            String name = element.getAttributeValue("name");
            Class<?> clazz = null;
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new RecorderException("Class Not Found:" + className);
            }
            Method method = null;
            try {
                method = clazz.getMethod("getEnum", String.class);
            }
            catch (SecurityException e) {
                throw new RecorderException(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new RecorderException(e.getMessage());
            }
            try {
                en = (Enum)method.invoke(null, name);
            }
            catch (IllegalArgumentException e) {
                throw new RecorderException(e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RecorderException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new RecorderException(e.getTargetException().getMessage());
            }
            return en;
        }

        public String getTagName() {
            return "Enum";
        }

        public boolean accept(String type) {
            if ("Enum".equals(type)) {
                return true;
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(type);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return clazz != null && Enum.class.isAssignableFrom(clazz);
        }
    }

    private static class ProxyObjectValue
    extends AbstractBaseObjectValue {
        ProxyObjectValue(Map map) {
            this.values.putAll(map);
        }

        public BOSObjectType getBOSType() {
            return null;
        }
    }
}

