/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.cache;

import com.kingdee.bos.cache.CacheLoader;
import com.kingdee.bos.cache.CacheObject;
import com.kingdee.bos.cache.CacheRegion;
import com.kingdee.bos.cache.ObjectAttributes;
import com.kingdee.bos.cache.RegionAttributes;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.eas.framework.cache.CacheRegionFactory;
import com.kingdee.eas.framework.cache.CacheStat;
import com.kingdee.eas.framework.cache.CollectionCacheObject;
import com.kingdee.eas.framework.cache.CollectionLoader;
import com.kingdee.eas.framework.cache.ICacheable;
import com.kingdee.eas.framework.cache.IDataPK;
import com.kingdee.eas.framework.cache.OqlPK;
import com.kingdee.eas.framework.cache.QueryCacheObject;
import com.kingdee.eas.framework.cache.QueryLoader;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class CacheService {
    public static final int REGION_IDLE_TIMEOUT = 36000000;
    public static final int OBJECT_LIVE_TIMEOUT = 14400000;
    public static final int OBJECT_IDLE_TIMEOUT = 1800000;
    public static final int TMPOBJECT_IDLE_TIMEOUT = 300000;

    public static CacheRegion createRegion(IMetaDataPK metaPK) {
        return CacheService.createRegion(metaPK.toString());
    }

    public static synchronized CacheRegion createRegion(String regionName) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        if (rootRegion.exists((Object)regionName)) {
            int level = CacheService.parseRegionLevel(regionName);
            return rootRegion.getRegion(regionName, level);
        }
        RegionAttributes rattr = CacheService.createRegionAttributes();
        ObjectAttributes oattr = CacheService.createObjectAttributes();
        return rootRegion.createSubRegion((Object)regionName, rattr, oattr);
    }

    public static void addCacheObject(ICacheable cacheable) {
        String regionName = cacheable.getMetaDataPK().toString();
        String name = cacheable.getDataPK().getPK();
        ObjectAttributes oattr = cacheable.getAttrbuites();
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.createRegion(regionName);
        if (region.exists((Object)name)) {
            region.getObject(name).destroy();
        }
        region.delayLoad((Object)name, oattr);
    }

    public static void addTmpCacheObject(ICacheable cacheable) {
        String regionName = cacheable.getMetaDataPK().toString();
        String name = cacheable.getDataPK().getPK();
        ObjectAttributes oattr = cacheable.getAttrbuites();
        oattr.setLong(6, 300000L);
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.createRegion(regionName);
        if (region.exists((Object)name)) {
            region.getObject(name).destroy();
        }
        region.delayLoad((Object)name, oattr);
    }

    private static void addCacheObject(String regionName, String name, Object value) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.createRegion(regionName);
        if (region.exists((Object)name)) {
            region.getObject(name).destroy();
        }
        ObjectAttributes oattr = CacheService.createObjectAttributes();
        region.putObject((Object)name, value, oattr);
    }

    private static void addCacheObject(String regionName, String name, CacheLoader loader) {
        CacheService.addCacheObject(regionName, name, loader, null);
    }

    private static void addCacheObject(String regionName, String name, CacheLoader loader, Object loadArgs) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.createRegion(regionName);
        if (region.exists((Object)name)) {
            region.getObject(name).destroy();
        }
        ObjectAttributes oattr = CacheService.createObjectAttributes();
        oattr.setLoader(loader);
        oattr.setLoadArguments(loadArgs);
        region.delayLoad((Object)name, oattr);
    }

    public static void removeCacheObject(IMetaDataPK metaPK, IDataPK dataPK) {
        CacheService.removeCacheObject(metaPK.toString(), dataPK.getPK());
    }

    static void removeCacheObject(String regionName, String name) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.createRegion(regionName);
        if (region.exists((Object)name)) {
            region.getObject(name).destroy();
        }
    }

    public static Object getCacheObject(IMetaDataPK metaPK) {
        return CacheService.getCacheObject(metaPK, new OqlPK());
    }

    public static Object getCacheObject(IMetaDataPK metaPK, boolean reload) {
        return CacheService.getCacheObject(metaPK, new OqlPK(), reload);
    }

    public static Object getCacheObject(IMetaDataPK metaPK, IDataPK dataPK) {
        return CacheService.getCacheObject(metaPK, dataPK, false);
    }

    public static Object getCacheObject(IMetaDataPK metaPK, IDataPK dataPK, boolean reload) {
        Object obj = CacheService.getCacheObject(metaPK.toString(), dataPK.getPK(), reload);
        if (obj == null) {
            CacheService.addCacheObject(CacheService.createCacheObject(metaPK, dataPK));
            obj = CacheService.getCacheObject(metaPK, dataPK, reload);
        } else {
            CacheStat.getInstance().doStat(metaPK.toString(), dataPK.getPK(), false);
        }
        if (obj instanceof IRowSet) {
            try {
                ((IRowSet)obj).beforeFirst();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return obj;
    }

    private static ICacheable createCacheObject(IMetaDataPK metaPK, IDataPK dataPK) {
        if (metaPK.toString().endsWith("Collection")) {
            return new CollectionCacheObject(metaPK, dataPK);
        }
        if (metaPK.toString().endsWith("Query")) {
            return new QueryCacheObject(metaPK, dataPK);
        }
        throw new IllegalArgumentException("unsupported cache type: " + metaPK.toString());
    }

    private static Object getCacheObject(String regionName, String name, boolean reload) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        CacheRegion region = CacheService.getCacheRegion(regionName);
        if (region == null || !region.exists((Object)name)) {
            return null;
        }
        CacheObject cacheObject = region.getObject(name);
        ObjectAttributes oattr = cacheObject.getAttributes();
        if (reload && oattr.getLoader() != null) {
            cacheObject.reload();
        }
        return region.getObjectValue((Object)name);
    }

    public static void removeRegion(IMetaDataPK metaPK) {
        CacheService.removeRegion(metaPK.toString());
    }

    public static void removeRegion(String regionName) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        if (rootRegion.exists((Object)regionName)) {
            rootRegion.getRegion(regionName).destroy();
        }
    }

    public static RegionAttributes createRegionAttributes() {
        RegionAttributes regionAttr = new RegionAttributes();
        regionAttr.setLong(6, 36000000L);
        return regionAttr;
    }

    public static ObjectAttributes createObjectAttributes() {
        ObjectAttributes objectAttr = new ObjectAttributes();
        objectAttr.setLong(5, 14400000L);
        objectAttr.setLong(6, 1800000L);
        objectAttr.setBoolean(22, true);
        return objectAttr;
    }

    public static CacheRegion getCacheRegion(IMetaDataPK metaPK) {
        return CacheService.getCacheRegion(metaPK.toString());
    }

    public static CacheRegion getCacheRegion(String regionName) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        if (!rootRegion.exists((Object)regionName)) {
            return null;
        }
        int level = CacheService.parseRegionLevel(regionName);
        return rootRegion.getRegion(regionName, level);
    }

    public static boolean existRegion(IMetaDataPK metaPK) {
        return CacheService.existRegion(metaPK.toString());
    }

    public static boolean existRegion(String regionName) {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        return rootRegion.exists((Object)regionName);
    }

    public static CacheRegion getCacheRegion() {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        return rootRegion.getRegion("!default");
    }

    public static CacheRegion getLocalCacheRegion() {
        CacheRegion rootRegion = CacheRegionFactory.getLocalRootCacheRegion();
        return rootRegion.getRegion("!local");
    }

    public static QueryLoader getQueryLoader() {
        return QueryLoader.getInstance();
    }

    public static CollectionLoader getCollectionLoader() {
        return CollectionLoader.getInstance();
    }

    static String generateHashcode(String str) {
        MessageDigest msgDigest = null;
        try {
            msgDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        byte[] digest = msgDigest.digest(str.getBytes());
        return new BigInteger(digest).toString();
    }

    private static int parseRegionLevel(String regionName) {
        StringTokenizer token = new StringTokenizer(regionName, ".");
        return token.countTokens() - 1;
    }
}

