/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client;

import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDTreeView;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.IMoveTreeListener;
import com.kingdee.eas.framework.client.MoveTreeEvent;
import com.kingdee.eas.framework.client.TreeObject;
import com.kingdee.eas.framework.client.tree.DefaultLNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.client.tree.TreeBuilderFactory;
import com.kingdee.eas.framework.util.StringUtility;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class MoveTree
extends KDDialog {
    protected Logger logger;
    protected ResourceBundleHelper resHelper = null;
    protected KDTree treeMain;
    protected KDTreeView treeView;
    protected KDButton btnSelect;
    protected KDButton btnCancel;
    private String title = "";
    private String RootName = "";
    private Frame parentFrame = null;
    protected EntityViewInfo mainQuery = null;
    private TreeBaseInfo sourceTree = null;
    private boolean isMoveTree = false;
    private FilterInfo treeFilter;
    private Set listeners = new HashSet();
    private TreeSelectionListener treeSelectionListener;
    protected ITreeBuilder treeBuilder;
    private ITreeBase itree;

    public MoveTree(Frame comp, String title, String RootName, ITreeBase iTreeBase, TreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter) throws Exception {
        super(comp, title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter);
    }

    public MoveTree(Dialog comp, String title, String RootName, ITreeBase iTreeBase, TreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter) throws Exception {
        super(comp, title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter);
    }

    public MoveTree(Component comp, String title, String RootName, ITreeBase iTreeBase, TreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter) throws Exception {
        super((Frame)ComponentUtil.getOwnerWindow((Component)comp), title, true);
        this.initDialog(title, RootName, iTreeBase, sourceTree, isMoveTree, treeFilter);
    }

    private void initDialog(String title, String RootName, ITreeBase iTreeBase, TreeBaseInfo sourceTree, boolean isMoveTree, FilterInfo treeFilter) throws Exception {
        this.title = title;
        this.RootName = RootName;
        this.itree = iTreeBase;
        this.sourceTree = sourceTree;
        this.isMoveTree = isMoveTree;
        this.treeFilter = treeFilter;
        this.sourceTree = sourceTree;
        this.logger = Logger.getLogger(MoveTree.class);
        this.jbInit();
        this.initUIContentLayout();
        this.initListener();
        this.initTree();
        this.treeMain.setSelectionRow(0);
    }

    private void jbInit() throws Exception {
        this.resHelper = new ResourceBundleHelper(MoveTree.class.getName());
        if (this.title.trim().equals("")) {
            this.setTitle(this.resHelper.getString("this.title"));
        } else {
            this.setTitle(this.title);
        }
        this.treeMain = new KDTree();
        this.treeView = new KDTreeView();
        this.btnSelect = new KDButton();
        this.btnCancel = new KDButton();
        this.treeMain.setName("treeMain");
        this.treeView.setName("treeView");
        this.btnSelect.setName("btnSelect");
        this.btnCancel.setName("btnCancel");
        this.setName("MoveTree");
        this.treeView.setShowControlPanel(false);
        this.btnSelect.setText(this.resHelper.getString("btnSelect.text"));
        this.btnCancel.setText(this.resHelper.getString("btnCancel.text"));
    }

    public void initUIContentLayout() {
        this.setBounds(new Rectangle(7, 7, 300, 420));
        this.getContentPane().setLayout(null);
        this.treeView.setBounds(new Rectangle(7, 7, 280, 350));
        this.treeView.setPreferredSize(new Dimension(280, 350));
        this.getContentPane().add((Component)this.treeView, null);
        this.btnSelect.setBounds(new Rectangle(138, 361, 73, 21));
        this.getContentPane().add((Component)this.btnSelect, null);
        this.btnCancel.setBounds(new Rectangle(214, 361, 73, 21));
        this.getContentPane().add((Component)this.btnCancel, null);
        this.treeView.setTree(this.treeMain);
        this.treeMain.setVisible(true);
        this.setResizable(false);
    }

    public void initListener() {
        this.getRootPane().setDefaultButton((JButton)this.btnSelect);
        this.btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveTree.this.fireSelectTree();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MoveTree.this.fireCancel();
                MoveTree.this.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMoveTreeListener(IMoveTreeListener moveTreeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(moveTreeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSelectTree() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        KDTreeNode treeNode = this.getSelectedTreeNode();
        TreeObject content = new TreeObject();
        if (!(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            content.setTargetTreeBaseInfo(null);
        } else {
            content.setTargetTreeBaseInfo((TreeBaseInfo)treeNode.getUserObject());
        }
        content.setTargetNode(this.getSelectedTreeNode());
        content.setSourceTreeBaseInfo(this.sourceTree);
        if (content.getSourceTreeBaseInfo() != null && content.getTargetTreeBaseInfo() != null && content.getTargetTreeBaseInfo().getLongNumber().length() > content.getSourceTreeBaseInfo().getLongNumber().length() && this.isMoveTree && StringUtility.isMatch(content.getTargetTreeBaseInfo().getLongNumber().substring(0, content.getSourceTreeBaseInfo().getLongNumber().length()), content.getSourceTreeBaseInfo().getLongNumber(), true) && content.getTargetTreeBaseInfo().getLongNumber().toLowerCase(Locale.ENGLISH).startsWith(content.getSourceTreeBaseInfo().getLongNumber().toLowerCase(Locale.ENGLISH) + "!")) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_ParentCanNotMoveChild"));
            return;
        }
        MoveTreeEvent moveTreeEvent = new MoveTreeEvent((Object)this, content);
        while (iterator.hasNext()) {
            IMoveTreeListener moveTreeListener = (IMoveTreeListener)iterator.next();
            moveTreeListener.SelectTreeNode(moveTreeEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireCancel() {
        Iterator iterator;
        Set set = this.listeners;
        synchronized (set) {
            iterator = new HashSet(this.listeners).iterator();
        }
        TreeObject content = new TreeObject();
        MoveTreeEvent moveTreeEvent = new MoveTreeEvent((Object)this, content);
        while (iterator.hasNext()) {
            IMoveTreeListener moveTreeListener = (IMoveTreeListener)iterator.next();
            moveTreeListener.SelectTreeCancel(moveTreeEvent);
        }
    }

    public void setDataObject(IObjectValue dataObject) {
    }

    protected void initTree() throws Exception {
        this.treeBuilder = TreeBuilderFactory.createTreeBuilder(this.getLNTreeNodeCtrl(), this.getTreeInitialLevel(), this.getTreeExpandLevel(), this.treeFilter);
        if (this.getRootName() != null) {
            KDTreeNode rootNode = new KDTreeNode(this.getRootObject());
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot((TreeNode)((Object)rootNode));
        } else {
            ((DefaultTreeModel)this.treeMain.getModel()).setRoot(null);
        }
        this.treeBuilder.buildTree(this.treeMain);
        this.treeMain.expandRow(0);
    }

    protected ILNTreeNodeCtrl getLNTreeNodeCtrl() throws Exception {
        return new DefaultLNTreeNodeCtrl(this.getTreeInterface());
    }

    protected int getTreeInitialLevel() {
        return 3;
    }

    protected int getTreeExpandLevel() {
        return 3;
    }

    protected String getRootName() {
        return this.RootName;
    }

    protected Object getRootObject() {
        return this.getRootName();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return this.itree;
    }

    public KDTreeNode getSelectedTreeNode() {
        return (KDTreeNode)((Object)this.treeMain.getLastSelectedPathComponent());
    }

    protected String getLongNumberFieldName() {
        return "longNumber";
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        return sic;
    }
}

