/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.cloud;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.base.weibo.util.SocialBizUtil;
import com.kingdee.eas.base.weibo.util.User;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.cloud.ISecretLetter;
import com.kingdee.eas.framework.client.cloud.XunTongUserProvider;
import com.kingdee.eas.framework.client.cloud.component.HyperlinkLabel;
import com.kingdee.eas.framework.client.cloud.component.ImageScaleLabel;
import com.kingdee.eas.framework.client.cloud.component.RecieverListPopupItem;
import com.kingdee.eas.framework.client.cloud.component.TipTextArea;
import com.kingdee.eas.framework.client.cloud.component.XTParticipatorAutoCompletionPopup;
import com.kingdee.eas.framework.client.cloud.screen.IPrintScreenListener;
import com.kingdee.eas.framework.client.cloud.screen.PrintScreen;
import com.kingdee.eas.framework.client.cloud.screen.PrintScreenRef;
import com.kingdee.eas.framework.client.resource.FWResourceManager;
import com.kingdee.eas.framework.query.component.AutoCompletionTextField;
import com.kingdee.eas.framework.query.component.IListPopupItem;
import com.kingdee.eas.framework.util.FileUtils;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class XunTongFeedDialog
extends KDDialog
implements ActionListener,
ISecretLetter {
    private static final long serialVersionUID = -5499807360387190450L;
    private static final Logger logger = Logger.getLogger(XunTongFeedDialog.class);
    private KDButton btnSnapshot;
    private KDButton btnCancel;
    private KDButton btnSend;
    private KDLabel labReceiver;
    private KDLabel labContent;
    private KDLabel labSnapshot;
    private KDLabel labContentTips;
    private KDLabel labOperationTips;
    private HyperlinkLabel labExpression;
    private HyperlinkLabel labAttach;
    private HyperlinkLabel labPic;
    private HyperlinkLabel labSave;
    private HyperlinkLabel labDelete;
    AutoCompletionTextField txtReciever;
    XTParticipatorAutoCompletionPopup popup;
    TipTextArea txtLetter;
    private KDPanel c;
    private KDPanel pnlBottom;
    private KDPanel pnlLeft;
    private KDPanel buttonJP;
    private BufferedImage get;
    private ImageScaleLabel labImg;
    private KDScrollPane sPnltxtContent;
    StartSnapshot snap;
    int titleLen = 20;
    int contentLen = 540;
    String operationsTips1 = "<html><font size = 4 color = blue>";
    String operationsTips2 = "\u8bf7\u8f93\u5165\u5185\u5bb9\u8fdb\u884c\u6c9f\u901a";
    String operationsTips3 = "</font></html>";
    PrintScreenRef screenRef = new PrintScreenRef();
    private byte[] screenPicBytes;
    private String currentPersonID;
    JDialog dialog;
    boolean isShowed = false;
    PrintScreen screen;
    boolean isSave = false;
    boolean isTitleTypeed = false;

    public XunTongFeedDialog(Dialog owner, String currentPersonID) {
        super(owner, "\u53d1\u8d77\u6c9f\u901a");
        this.dialog = (JDialog)owner;
        this.currentPersonID = currentPersonID;
        this.initWindow();
        this.isShowed = true;
    }

    public XunTongFeedDialog(Frame owner, String currentPersonID) {
        super(owner, "\u53d1\u8d77\u6c9f\u901a");
        this.currentPersonID = currentPersonID;
        this.initWindow();
        this.isShowed = true;
    }

    private void initWindow() {
        this.btnSnapshot = new KDButton("\u622a\u5c4f");
        this.btnSend = new KDButton("\u53d1\u8d77\u6c9f\u901a");
        this.btnCancel = new KDButton("\u53d6\u6d88");
        this.btnSend.addActionListener((ActionListener)this);
        this.btnSnapshot.addActionListener((ActionListener)this);
        this.btnCancel.addActionListener((ActionListener)this);
        this.buttonJP = new KDPanel();
        this.c = new KDPanel(null);
        this.labReceiver = new KDLabel("\u53c2\u4e0e\u8005\uff1a", 2);
        this.labContent = new KDLabel("\u77ed\u90ae\u5185\u5bb9\uff1a", 2);
        this.labSnapshot = new KDLabel("\u622a\u56fe\uff1a", 2);
        this.labContentTips = new KDLabel("", 2);
        this.labOperationTips = new KDLabel(this.operationsTips1 + this.operationsTips2 + this.operationsTips3, 2);
        this.labExpression = new HyperlinkLabel("", 2);
        this.labAttach = new HyperlinkLabel("", 2);
        this.labPic = new HyperlinkLabel("", 2);
        this.labSave = new HyperlinkLabel("", 2);
        this.labDelete = new HyperlinkLabel("", 2);
        this.labSave.setToolTipText("\u4fdd\u5b58\u56fe\u7247");
        this.labDelete.setToolTipText("\u5220\u9664\u56fe\u7247");
        this.labExpression.setIcon(FWResourceManager.getIcon("expression.png"));
        this.labAttach.setIcon(FWResourceManager.getIcon("attachment.png"));
        this.labPic.setIcon(FWResourceManager.getIcon("picture.png"));
        this.labSave.setIcon(FWResourceManager.getIcon("save.png"));
        this.labDelete.setIcon(FWResourceManager.getIcon("delete.png"));
        this.sPnltxtContent = new KDScrollPane();
        this.txtLetter = new TipTextArea();
        this.txtLetter.setTipInfoText("\u8bf4\u70b9\u4ec0\u4e48");
        this.updateContentTips();
        this.labReceiver.setSize(100, 25);
        this.labReceiver.setLocation(10, 10);
        try {
            this.txtReciever = new AutoCompletionTextField();
            this.popup = new XTParticipatorAutoCompletionPopup(this.txtReciever);
            this.popup.setProvider(new XunTongUserProvider<User>(this.currentPersonID));
            this.txtReciever.setPopup(this.popup);
            this.txtReciever.setInfoLabelText("\u9009\u62e9\u53c2\u4e0e\u8005");
            this.txtReciever.setShowSearchIcon(false);
            this.txtReciever.setMaxItemSize(50);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        this.txtReciever.setBounds(new Rectangle(100, 10, 430, 25));
        this.sPnltxtContent.setBounds(new Rectangle(10, 60, 250, 180));
        this.txtLetter.setBounds(new Rectangle(10, 60, 250, 180));
        this.sPnltxtContent.getViewport().add((Component)((Object)this.txtLetter), null);
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (XunTongFeedDialog.this.txtLetter.getText().equals("")) {
                    XunTongFeedDialog.this.txtLetter.requestFocus();
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                XunTongFeedDialog.this.isShowed = false;
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        });
        this.txtLetter.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                XunTongFeedDialog.this.updateOperationTips("");
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.txtLetter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.txtLetter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                XunTongFeedDialog.this.doContentsChanged();
                XunTongFeedDialog.this.updateContentTips();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                XunTongFeedDialog.this.doContentsChanged();
                XunTongFeedDialog.this.updateContentTips();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                XunTongFeedDialog.this.doContentsChanged();
                XunTongFeedDialog.this.updateContentTips();
            }
        });
        this.labReceiver.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.labContent.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.labSnapshot.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.labAttach.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.labPic.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.labContent.setSize(100, 25);
        this.labContent.setForeground(Color.BLACK);
        this.labExpression.setSize(25, 25);
        this.labAttach.setSize(25, 25);
        this.labPic.setSize(25, 25);
        this.labSave.setSize(25, 25);
        this.labDelete.setSize(25, 25);
        this.labContentTips.setSize(220, 50);
        this.labOperationTips.setSize(300, 30);
        this.labSave.setVisible(false);
        this.labDelete.setVisible(false);
        this.labSnapshot.setForeground(Color.BLACK);
        this.labSnapshot.setSize(100, 25);
        this.labImg = new ImageScaleLabel();
        this.labImg.setBorder(new LineBorder(Color.gray));
        this.labImg.setText("\u622a\u5c4f");
        this.labImg.setTipText("\u622a\u5c4f");
        this.labImg.setTipImage(FWResourceManager.getIcon("screenshot.png"));
        this.labImg.setVerticalTextPosition(1);
        this.labImg.setForeground(Color.BLUE);
        this.labImg.setSize(250, 180);
        this.labImg.setLocation(280, 60);
        this.snap = this.dialog != null ? new StartSnapshot(this.dialog) : new StartSnapshot((JDialog)((Object)this));
        this.labImg.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XunTongFeedDialog.this.setVisible(false);
                    XunTongFeedDialog.this.getOwner().repaint();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(XunTongFeedDialog.this.snap);
                }
            }
        });
        this.c.add((Component)this.labReceiver);
        this.c.add((Component)((Object)this.txtReciever));
        this.c.add((Component)this.sPnltxtContent);
        this.c.add((Component)((Object)this.labImg));
        this.c.add((Component)((Object)this.labSave));
        this.c.add((Component)((Object)this.labDelete));
        this.c.add((Component)this.labContentTips);
        this.c.add((Component)this.labOperationTips);
        this.labContent.setLocation(10, 65);
        this.labSnapshot.setLocation(10, 217);
        this.labAttach.setLocation(10, 250);
        this.labPic.setLocation(75, 250);
        this.labSave.setLocation(490, 245);
        this.labDelete.setLocation(515, 245);
        this.labContentTips.setLocation(150, 225);
        this.labOperationTips.setLocation(10, 283);
        this.btnSend.setSize(100, 22);
        this.btnSnapshot.setSize(50, 22);
        this.btnCancel.setSize(50, 22);
        this.buttonJP.setSize(250, 100);
        JSeparator jsep = new JSeparator(0);
        jsep.setBounds(3, 280, 535, 1);
        this.c.add((Component)jsep);
        this.c.add((Component)this.btnCancel);
        this.c.add((Component)this.btnSend);
        this.btnSnapshot.setLocation(250, 290);
        this.btnSend.setLocation(350, 290);
        this.btnSend.setSize(100, 25);
        this.btnCancel.setLocation(460, 290);
        this.btnCancel.setSize(50, 25);
        this.pnlBottom = new KDPanel();
        KDLabel labBlan = new KDLabel("  ");
        this.pnlLeft = new KDPanel();
        this.pnlBottom.setLayout((LayoutManager)new BorderLayout());
        this.pnlBottom.add((Component)this.pnlLeft, (Object)"Center");
        this.pnlBottom.add((Component)this.buttonJP, (Object)"South");
        this.labAttach.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XunTongFeedDialog.this.doOpenDocs();
                }
            }
        });
        this.labPic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XunTongFeedDialog.this.doOpenPics();
                }
            }
        });
        this.labSave.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XunTongFeedDialog.this.doSave();
                }
            }
        });
        this.labDelete.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    XunTongFeedDialog.this.doDelete();
                }
            }
        });
        this.getContentPane().add((Component)this.c);
        this.setSize(550, 350);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.txtLetter.setRequired(true);
        this.txtLetter.requestFocus();
    }

    public boolean isShowed() {
        return this.isShowed;
    }

    private void updateImageOperations(boolean b) {
        this.labSave.setVisible(b);
        this.labDelete.setVisible(b);
    }

    @Override
    public void updates() {
        this.setVisible(true);
        if (this.screenRef != null && this.screenRef.getBufferedImage() != null) {
            ImageIcon ii = new ImageIcon(this.screenRef.getBufferedImage());
            this.setImage(this.screenRef.getBufferedImage());
            Image img = ii.getImage();
            this.labImg.setImage(img);
            SwingUtilities.updateComponentTreeUI((Component)((Object)this));
            this.updateImageOperations(true);
        }
    }

    @Override
    public void setImage(BufferedImage img) {
        this.get = img;
    }

    private byte[] toBytes() {
        byte[] bytes = null;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        try {
            if (this.get == null) {
                return null;
            }
            ImageIO.write((RenderedImage)this.get, "jpg", bao);
            bytes = bao.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bytes;
    }

    private void doOpenDocs() {
        try {
            KDFileChooser jfc = new KDFileChooser("*.*");
            int i = jfc.showOpenDialog((Component)((Object)this));
            if (i == 0) {
                File file = jfc.getSelectedFile();
                String about = "PNG";
                String ext = file.toString().toLowerCase();
                FileFilter fileFilter = jfc.getFileFilter();
            }
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    private void doOpenPics() {
        try {
            KDFileChooser jfc = new KDFileChooser(".");
            jfc.addChoosableFileFilter((FileFilter)new JPGfilter());
            jfc.addChoosableFileFilter((FileFilter)new PNGfilter());
            int i = jfc.showOpenDialog((Component)((Object)this));
            if (i == 0) {
                File file = jfc.getSelectedFile();
                String about = "PNG";
                String ext = file.toString().toLowerCase();
                FileFilter ff = jfc.getFileFilter();
                if (ff instanceof JPGfilter) {
                    if (!ext.toLowerCase(Locale.ENGLISH).endsWith(".jpg")) {
                        String ns = ext + ".jpg";
                        file = new File(ns);
                        about = "JPG";
                    }
                } else if (ff instanceof PNGfilter && !ext.toLowerCase(Locale.ENGLISH).endsWith(".png")) {
                    String ns = ext + ".png";
                    file = new File(ns);
                    about = "PNG";
                }
            }
        }
        catch (Exception exe) {
            exe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSave() {
        try {
            KDFileChooser jfc = FileUtils.initPicKDFileChooser();
            int i = jfc.showSaveDialog((Component)((Object)this));
            if (i == 0) {
                File file = jfc.getSelectedFile();
                int index = file.getName().indexOf(".");
                String about = file.getName().substring(index + 1).toUpperCase();
                System.out.println("save file extend: " + about);
                if (ImageIO.write((RenderedImage)this.get, about, file)) {
                    this.isSave = true;
                    System.out.println("save file:" + file.toString());
                }
            }
        }
        catch (Exception exe) {
            exe.printStackTrace();
            logger.error((Object)exe);
        }
    }

    private void doDelete() {
        if (this.labImg.getImage() != null) {
            this.get = null;
            this.labImg.setImage(null);
            this.labImg.repaint();
            this.updateImageOperations(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() != this.btnSnapshot && ae.getSource() != this.labImg) {
            if (ae.getSource() == this.btnCancel) {
                this.setVisible(false);
                this.isShowed = false;
                this.dispose();
            } else if (ae.getSource() == this.btnSend) {
                this.doSend();
            }
        }
    }

    private void updateOperationTips(String tips) {
        if (tips != null && tips.equals("")) {
            this.labOperationTips.setText(this.operationsTips1 + this.operationsTips2 + this.operationsTips3);
        } else {
            this.labOperationTips.setText(this.operationsTips1 + tips + this.operationsTips3);
        }
    }

    private void updateContentTips() {
        int len = this.contentLen;
        String characterLen = "";
        len = this.contentLen - this.txtLetter.getText().length();
    }

    private void doTitleChanged() {
        String title = "";
        this.isTitleTypeed = title.length() > 0;
    }

    private void doContentsLenLimited() {
        String content = "";
        content = this.txtLetter.getText();
        if (content.length() > this.contentLen) {
            content = content.substring(0, this.contentLen);
            this.txtLetter.setText(content);
        }
    }

    private void doContentsChanged() {
        String title = "";
        String content = "";
        String userName = "";
        content = this.txtLetter.getText();
        if (title.length() > 0 && content.length() > this.titleLen) {
            return;
        }
        if (content.length() > this.titleLen) {
            content = content.substring(0, this.titleLen);
        }
        if (!this.isTitleTypeed && content.equals("")) {
            title = content;
        }
    }

    private String getSendContent() {
        String content = "";
        String participants = "";
        content = this.txtLetter.getText();
        IListPopupItem[] items = this.txtReciever.getListPopupItems();
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof RecieverListPopupItem)) continue;
                participants = participants.length() > 0 ? participants + " " + "@" + ((RecieverListPopupItem)items[i]).getDisplayValue() : "@" + ((RecieverListPopupItem)items[i]).getDisplayValue();
            }
        }
        content = content + participants;
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSend() {
        String participantIds = "";
        String content = "";
        String fileName = "pictemp";
        IListPopupItem[] items = this.txtReciever.getListPopupItems();
        if (items != null && items.length > 0) {
            for (int i = 0; i < items.length; ++i) {
                if (!(items[i] instanceof RecieverListPopupItem)) continue;
                participantIds = participantIds.length() > 0 ? participantIds + ";" + ((RecieverListPopupItem)items[i]).getUserID() : ((RecieverListPopupItem)items[i]).getUserID();
            }
        }
        if (participantIds.equals("")) {
            MsgBox.showInfo((String)"\u5fc5\u987b\u9009\u4e00\u4e2a\u53c2\u4e0e\u4eba\u624d\u80fd\u53d1\u9001\uff01");
            return;
        }
        content = this.txtLetter.getText();
        this.screenPicBytes = this.toBytes();
        SimpleDateFormat tempDate = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName = tempDate.format(new Date()) + ".png";
        File srceenPicFile = new File(fileName);
        try {
            String resultTip = "";
            String errorMsg = "";
            if (content.length() > 0 && this.screenPicBytes != null) {
                String result = SocialBizUtil.sendMessageFile((String)this.currentPersonID, (String)participantIds, (String)content, (File)(srceenPicFile = this.toPicFile(srceenPicFile, this.screenPicBytes)));
                JSONObject resultjson = new JSONObject(result);
                if (!resultjson.getBoolean("success")) {
                    resultTip = resultTip + "\u6d88\u606f";
                    errorMsg = errorMsg + "\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cerrorCode:" + resultjson.getString("errorCode") + "\nerror:" + resultjson.getString("error") + "\n";
                }
                srceenPicFile.delete();
            } else if (content.length() > 0) {
                String messageResult = SocialBizUtil.sendMessageFile((String)this.currentPersonID, (String)participantIds, (String)content, null);
                JSONObject msgjson = new JSONObject(messageResult);
                if (!msgjson.getBoolean("success")) {
                    resultTip = resultTip + "\u6587\u672c\u6d88\u606f";
                    errorMsg = errorMsg + "\u6587\u672c\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0cerrorCode:" + msgjson.getString("errorCode") + "\nerror:" + msgjson.getString("error") + "\n";
                }
            } else if (this.screenPicBytes != null) {
                String fileResult = SocialBizUtil.sendMessageFile((String)this.currentPersonID, (String)participantIds, null, (File)(srceenPicFile = this.toPicFile(srceenPicFile, this.screenPicBytes)));
                JSONObject filejson = new JSONObject(fileResult);
                if (!filejson.getBoolean("success")) {
                    if (!"".equals(resultTip)) {
                        resultTip = resultTip + "\uff0c";
                    }
                    resultTip = resultTip + "\u56fe\u7247";
                    errorMsg = errorMsg + "\u56fe\u7247\u53d1\u9001\u5931\u8d25\uff0cerrorCode:" + filejson.getString("errorCode") + "\nerror:" + filejson.getString("error") + "\n";
                }
                srceenPicFile.delete();
            }
            if ("".equals(resultTip)) {
                this.updateOperationTips("\u53d1\u9001\u6210\u529f\uff01");
                this.dispose();
            } else {
                this.updateOperationTips(resultTip + "\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01");
                logger.error((Object)("\u8baf\u901a\u6d88\u606f\u53d1\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a\n" + errorMsg));
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (JSONException e) {
            logger.error((Object)e);
        }
        finally {
            srceenPicFile.delete();
        }
    }

    private File toPicFile(File picFile, byte[] picBytes) {
        try {
            int i = 0;
            while (i < picBytes.length) {
                int n = i++;
                picBytes[n] = (byte)(picBytes[n] ^ 0x80);
            }
            FileOutputStream fos = new FileOutputStream(picFile);
            fos.write(picBytes);
            fos.close();
        }
        catch (Exception e) {
            logger.error((Object)"\u8baf\u901a\u56fe\u7247\u5b57\u8282\u7801\u8f6c\u6587\u4ef6\u51fa\u9519", (Throwable)e);
        }
        return picFile;
    }

    class StartSnapshot
    extends Thread {
        JDialog owner;

        public StartSnapshot(JDialog owner) {
            this.owner = owner;
        }

        @Override
        public void run() {
            try {
                XunTongFeedDialog.this.screen = XunTongFeedDialog.this.dialog != null ? new PrintScreen((Dialog)this.owner, XunTongFeedDialog.this.screenRef) : new PrintScreen(XunTongFeedDialog.this.screenRef);
                XunTongFeedDialog.this.screen.addPrintScreenListener(new IPrintScreenListener(){

                    @Override
                    public void printScreenClose(PrintScreenRef ref) {
                        if (ref != null && ref.getBufferedImage() != null) {
                            XunTongFeedDialog.this.screenRef = ref;
                            XunTongFeedDialog.this.updates();
                        }
                    }
                });
                XunTongFeedDialog.this.screen.setParentDialog(this.owner);
            }
            catch (Exception exe) {
                exe.printStackTrace();
            }
        }
    }

    private class PNGfilter
    extends FileFilter {
        private PNGfilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase(Locale.ENGLISH).endsWith(".png") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.PNG(PNG\u56fe\u50cf)";
        }
    }

    private class JPGfilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.toString().toLowerCase(Locale.ENGLISH).endsWith(".jpg") || file.toString().toLowerCase(Locale.ENGLISH).endsWith(".jpeg") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "*.JPG,*.JPEG(JPG,JPEG\u56fe\u50cf)";
        }
    }
}

