/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.context.f7;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.FilterInfoProducerFactory;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.MultiOUs4OrgFilterInfoProducer;
import com.kingdee.bos.ctrl.extendcontrols.ext.OrgUnitDelegationFilterInfoProducer;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.DelegationPartsEnum;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.MultiOrgHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;

public final class F7ContextUtil {
    public static OrgUnitCollection getOrgsByRelation(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getRemoteInstance();
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        switch (iSrcOrg) {
            case 0: 
            case 4: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 1: {
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 2: {
                if (iDestOrg == 4) {
                    return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 3: {
                if (iDestOrg == 1) {
                    return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
                }
                return iOrgRelation.getFromUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
            case 24: {
                return iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
            }
        }
        return null;
    }

    public static FullOrgUnitCollection getAuthOrgByPermItem(IObjectPK user, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = null;
        IPermission permission = PermissionFactory.getRemoteInstance();
        result = permission.getAuthorizedOrg(user, orgType, null, permItem);
        return result;
    }

    public static boolean isAuthoriedForOrg(IObjectPK user, OrgType orgType, IObjectPK orgPK, String permItem) throws BOSException, EASBizException {
        FullOrgUnitCollection result = F7ContextUtil.getAuthOrgByPermItem(user, orgType, permItem);
        if (result != null) {
            for (int i = 0; i < result.size(); ++i) {
                if (!result.get(i).getId().toString().equals(orgPK.toString())) continue;
                return true;
            }
        }
        return false;
    }

    public static void setBizOrgF7ByType(KDBizPromptBox bizOrgUnitBox, OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (bizOrgUnitBox == null) {
            return;
        }
        String query = null;
        if (orgType.equals((Object)OrgType.Storage)) {
            query = "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Purchase)) {
            query = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Sale)) {
            query = "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Company)) {
            query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
        } else if (orgType.equals((Object)OrgType.Admin)) {
            query = "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery";
        } else {
            return;
        }
        bizOrgUnitBox.setQueryInfo(query);
        if (!orgType.equals((Object)OrgType.Admin)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Integer.valueOf("1"), CompareType.EQUALS));
            view.setFilter(filter);
            bizOrgUnitBox.setEntityViewInfo(view);
        }
        if (!OrgType.Admin.equals((Object)mainOrgType)) {
            bizOrgUnitBox.setFilterInfoProducer(F7ContextUtil.getOrgUnitProducer(orgType, mainOrgType, isSingleMainOrg));
        }
    }

    private static IFilterInfoProducer getOrgUnitProducer(OrgType orgType, OrgType mainOrgType, boolean isSingleMainOrg) {
        if (isSingleMainOrg) {
            IFilterInfoProducer iProducer = FilterInfoProducerFactory.getOrgUnitDelegationFilterInfoProducer((DelegationPartsEnum)F7ContextUtil.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
            OrgUnitDelegationFilterInfoProducer producer = (OrgUnitDelegationFilterInfoProducer)iProducer;
            producer.getModel().setDoNotUseUserOrgRangeAsFilter();
            return producer;
        }
        IFilterInfoProducer iProducer = FilterInfoProducerFactory.getMultiOUs4OrgFilterInfoProducer(null, (OrgType)mainOrgType, (DelegationPartsEnum)F7ContextUtil.getDelegationDirection(orgType, mainOrgType), (OrgType)orgType);
        MultiOUs4OrgFilterInfoProducer producer = (MultiOUs4OrgFilterInfoProducer)iProducer;
        producer.getModel().setDoNotUseUserOrgRangeAsFilter();
        return producer;
    }

    private static DelegationPartsEnum getDelegationDirection(OrgType orgType, OrgType mainOrgType) {
        int iMainType = mainOrgType.getValue();
        int iDeleType = orgType.getValue();
        switch (iMainType) {
            case 1: {
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 2: {
                if (iDeleType == 4) {
                    return DelegationPartsEnum.THE_FROM_UNIT;
                }
                return DelegationPartsEnum.THE_TO_UNIT;
            }
            case 3: {
                if (iDeleType == 1) {
                    return DelegationPartsEnum.THE_TO_UNIT;
                }
                return DelegationPartsEnum.THE_FROM_UNIT;
            }
            case 4: {
                return DelegationPartsEnum.THE_TO_UNIT;
            }
        }
        return DelegationPartsEnum.THE_TO_UNIT;
    }

    public static OrgUnitInfo getOrgUnitInfoByType(String id, OrgType orgType) {
        OrgUnitInfo orgInfo = null;
        try {
            orgInfo = OrgCommonUtils.getOrgUnitInfo(null, (String)id, (OrgType)orgType, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orgInfo;
    }

    public static OrgUnitInfo[] getOrgUnitInfosByType(FullOrgUnitCollection orgs, OrgType orgType) {
        OrgUnitInfo[] results = null;
        if (orgs == null || orgs.size() == 0) {
            return null;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)true, CompareType.EQUALS));
        }
        view.setFilter(filter);
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getRemoteInstance();
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getRemoteInstance();
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getRemoteInstance();
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getRemoteInstance();
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getRemoteInstance();
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection != null && collection.size() > 0) {
                        results = new OrgUnitInfo[collection.size()];
                        for (int i = 0; i < collection.size(); ++i) {
                            results[i] = collection.get(i);
                        }
                    }
                    return results;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo)) continue;
            SubEntityInfo subEntityInfo = (SubEntityInfo)subObjectInfo;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            entityNames.add(entityName);
        }
        return entityNames;
    }

    public static String getMainEntityName(String queryName) {
        QueryInfo queryInfo = Util.getQueryInfo((String)queryName);
        ArrayList entityNames = MultiOrgHelper.getEntitiyNames(queryInfo);
        if (entityNames.size() > 0) {
            return (String)entityNames.get(0);
        }
        return null;
    }

    public static EntityObjectInfo getEntity(String entityName) {
        return Util.getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
    }

    public static boolean isDiffrent4OrgCollection(OrgUnitCollection collection1, OrgUnitCollection collection2) {
        boolean isChanged = false;
        if (collection1 == null && collection2 != null) {
            isChanged = collection2.size() > 0;
        } else if (collection1 != null && collection2 == null) {
            isChanged = collection1.size() > 0;
        } else if (collection1 != null && collection2 != null) {
            if (collection1.size() != collection2.size()) {
                isChanged = true;
            } else {
                int i;
                ArrayList<String> list = new ArrayList<String>();
                for (i = 0; i < collection1.size(); ++i) {
                    list.add(collection1.get(i).getId().toString());
                }
                for (i = 0; i < collection2.size(); ++i) {
                    if (list.contains(collection2.get(i).getId().toString())) continue;
                    isChanged = true;
                    break;
                }
            }
        }
        return isChanged;
    }

    public static EntityViewInfo getCurrntMainOrgChangedEV(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext, OrgUnitCollection collection) {
        boolean isHasPorperty = false;
        EntityViewInfo view = null;
        view = promptBox.getEntityViewInfo();
        if (view == null) {
            view = new EntityViewInfo();
        }
        if (StringUtils.isEmpty((String)propertyOfBizOrg)) {
            return view;
        }
        FilterInfo bizFilterInfo = F7ContextUtil.getBizFilterInfo(promptBox, propertyOfBizOrg, mainOrgContext, collection);
        if (bizFilterInfo == null) {
            return view;
        }
        if (view != null && view.getFilter() != null && view.getFilter().getFilterItems().size() > 0) {
            FilterItemInfo itemInfo = null;
            for (int i = 0; i < view.getFilter().getFilterItems().size(); ++i) {
                itemInfo = view.getFilter().getFilterItems().get(i);
                if (itemInfo.getPropertyName().indexOf(propertyOfBizOrg) < 0) continue;
                view.getFilter().getFilterItems().set(i, bizFilterInfo.getFilterItems().get(0));
                isHasPorperty = true;
            }
        }
        try {
            if (view.getFilter() != null && view.getFilter().getFilterItems().size() > 0) {
                if (bizFilterInfo != null && !isHasPorperty) {
                    view.getFilter().mergeFilter(bizFilterInfo, "and");
                }
            } else if (bizFilterInfo != null && !isHasPorperty) {
                view.setFilter(bizFilterInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return view;
    }

    private static FilterInfo getBizFilterInfo(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext, OrgUnitCollection collection) {
        if (mainOrgContext == null) {
            mainOrgContext = promptBox.getF7Context();
        }
        FilterInfo bizFilterInfo = null;
        bizFilterInfo = collection == null || collection.size() == 0 ? F7ContextUtil.getBizFilterInfo4InMaintaining(promptBox, propertyOfBizOrg, mainOrgContext) : F7ContextUtil.getBizFilterInfo4InQuerying(promptBox, propertyOfBizOrg, mainOrgContext, collection);
        if (bizFilterInfo == null || bizFilterInfo.getFilterItems().size() == 0) {
            bizFilterInfo = new FilterInfo();
            bizFilterInfo.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        return bizFilterInfo;
    }

    public static EntityViewInfo getCurrntMainOrgChangedEV(KDBizPromptBox promptBox, String mainOrgProperty, Context mainOrgContext) {
        return F7ContextUtil.getCurrntMainOrgChangedEV(promptBox, mainOrgProperty, mainOrgContext, null);
    }

    public static void resetFilterItemCompareValue(EntityViewInfo view, String propertyName, Object Value) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        FilterInfo filter = view.getFilter();
        boolean hasProperty = false;
        if (filter != null && filter.getFilterItems().size() != 0) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!propertyName.equals(item.getPropertyName())) continue;
                item.setCompareValue(Value);
                hasProperty = true;
            }
            if (!hasProperty) {
                filter.getFilterItems().add(new FilterItemInfo(propertyName, Value));
            }
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(propertyName, Value));
        }
    }

    public static void resetFilterItemCompareValue(EntityViewInfo view, String propertyName, Object Value, CompareType type) {
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        boolean hasProperty = false;
        FilterInfo filter = view.getFilter();
        if (filter != null && filter.getFilterItems().size() != 0) {
            for (int i = 0; i < filter.getFilterItems().size(); ++i) {
                FilterItemInfo item = filter.getFilterItems().get(i);
                if (!propertyName.equals(item.getPropertyName())) continue;
                item.setCompareValue(Value);
                hasProperty = true;
                item.setCompareType(type);
            }
            if (!hasProperty) {
                filter.getFilterItems().add(new FilterItemInfo(propertyName, Value));
            }
        } else {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(propertyName, Value, type));
        }
    }

    private static FilterInfo getBizFilterInfo4InQuerying(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext, OrgUnitCollection collection) {
        FilterInfo bizFilterInfo = new FilterInfo();
        if (collection.size() > 0) {
            StringBuffer orgIdBuffer = new StringBuffer();
            for (int i = 0; i < collection.size(); ++i) {
                if (i > 0) {
                    orgIdBuffer.append(",");
                }
                orgIdBuffer.append(collection.get(i).getId().toString());
            }
            if (propertyOfBizOrg != null && !propertyOfBizOrg.trim().equals("")) {
                bizFilterInfo = new FilterInfo();
                bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
            }
        } else {
            bizFilterInfo = new FilterInfo();
            bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, null, CompareType.EQUALS));
        }
        return bizFilterInfo;
    }

    private static FilterInfo getBizFilterInfo4InMaintaining(KDBizPromptBox promptBox, String propertyOfBizOrg, Context mainOrgContext) {
        FilterInfo bizFilterInfo = new FilterInfo();
        OrgUnitInfo orgUnitInfo = (OrgUnitInfo)mainOrgContext.get((Object)"CurOU");
        CtrlUnitInfo cu = orgUnitInfo.getCU();
        if (cu == null && mainOrgContext != null) {
            cu = (CtrlUnitInfo)mainOrgContext.get((Object)OrgType.ControlUnit);
        }
        if (cu == null) {
            try {
                IFullOrgUnit iFullOrg = FullOrgUnitFactory.getRemoteInstance();
                orgUnitInfo = iFullOrg.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId().toString()));
                cu = orgUnitInfo.getCU();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String cuId = null;
        if (cu != null) {
            cuId = cu.getId().toString();
        }
        if (propertyOfBizOrg != null && !propertyOfBizOrg.trim().equals("")) {
            if (!orgUnitInfo.getId().toString().equals(cuId)) {
                StringBuffer orgIdBuffer = new StringBuffer();
                orgIdBuffer.append(orgUnitInfo.getId().toString());
                orgIdBuffer.append("," + cuId);
                bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgIdBuffer.toString(), CompareType.INCLUDE));
            } else {
                bizFilterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            }
        }
        return bizFilterInfo;
    }

    public static void addFilter4EV(EntityViewInfo viewInfo, FilterItemInfo itemInfo) {
        FilterInfo filter = viewInfo.getFilter();
        boolean found = false;
        String key = itemInfo.getPropertyName();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            FilterItemInfo item = filter.getFilterItems().get(i);
            if (!item.getPropertyName().equalsIgnoreCase(key)) continue;
            item.setCompareType(itemInfo.getCompareType());
            item.setCompareValue(itemInfo.getCompareValue());
            found = true;
        }
        if (!found) {
            FilterInfo info = new FilterInfo();
            info.getFilterItems().add(itemInfo);
            try {
                filter.mergeFilter(info, "AND");
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

