/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.exportexcel;

import com.kingdee.util.ConfigurationItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.XMLConfiguration;
import java.io.File;
import java.io.IOException;

public class ExportExcelConfigParam {
    public static final String DEFAULTFILENAME = "eastemp";
    public static final String TAG_CURRENTCONFIGVERSION = "configVersion";
    public static final String CURRENT_CONFIGFILE_VERSION = "1.0";
    private static final boolean DEFAULT_OPENFILE = false;
    public static final String TAG_EXCELVERSION = "excelVersion";
    public static final int EXCEL_VERSION_2003 = 1;
    public static final int EXCEL_VERSION_2007 = 0;
    public static final int EXCEL_VERSION_DEFAULT = 1;
    public static final int EXCEL2003_MAX_COLUMN_COUNT = 255;
    public static int EXCEL2003_MAXROWS_VALUE = 10000;
    public static final String TAG_EXPORTPARAM = "exportParam";
    public static final String TAG_EXPORTMERGEBLOCKS = "isExportMergeBlocks";
    public static final boolean IS_EXPORT_MERGEBLOCKS_DEFAULT = false;
    public static final boolean IS_EXPORT_SELECT_DEFAULT = false;
    public static final boolean IS_MERGE_HEAD_ROWS_EXPORT = false;
    public static final boolean IS_DESENSITIZATION_EXPORT = false;
    public static final String TAG_EXPORTSELECT = "isExportSelect";
    public static final String TAG_SAVEPATH = "savePath";
    public static final String TAG_CLOSEWINDOW = "isCloseWindow";
    public static final String TAG_OPENFILE = "isOpenFile";
    public static final String TAG_MAXROWS = "2003MaxRowsValue";
    public static final String TAG_MERGE_HEAD_ROWS_EXPORT = "isMergeHeadRowsExport";
    public static final String TAG_DESENSITIZATION = "isDesensitizationExport";
    private String configFileVersion = "1.0";
    private int excelVersion = 1;
    private String fileName = "eastemp";
    private boolean isExportMergeBlocks = false;
    private boolean isExportSelect = false;
    private boolean isOpenFile = false;
    private boolean isMergeHeadRowsExport = false;
    private boolean isDesensitizationExport = false;
    private String savePath = this.getDefaultPath();

    public static ExportExcelConfigParam getDefaultExportExcelConfigParam() {
        ExportExcelConfigParam param = new ExportExcelConfigParam();
        return param;
    }

    public ExportExcelConfigParam() {
    }

    public ExportExcelConfigParam(XMLConfiguration config) {
        ConfigurationItem configItem;
        if (config != null && (configItem = config.getConfigItem(TAG_EXPORTPARAM)) != null) {
            String paramStr = configItem.getProperty(TAG_EXCELVERSION);
            if (!StringUtils.isEmpty((String)paramStr)) {
                try {
                    this.setExcelVersion(Integer.parseInt(paramStr));
                }
                catch (NumberFormatException ex) {
                    this.setExcelVersion(1);
                }
            } else {
                this.setExcelVersion(1);
            }
            paramStr = configItem.getProperty(TAG_CURRENTCONFIGVERSION);
            this.setConfigFileVersion(paramStr);
            paramStr = configItem.getProperty(TAG_EXPORTMERGEBLOCKS);
            if (!StringUtils.isEmpty((String)paramStr)) {
                this.setExportMergeBlocks(Boolean.valueOf(paramStr));
            } else {
                this.setExportMergeBlocks(false);
            }
            paramStr = configItem.getProperty(TAG_MERGE_HEAD_ROWS_EXPORT);
            if (!StringUtils.isEmpty((String)paramStr)) {
                this.setMergeHeadRowsExport(Boolean.valueOf(paramStr));
            } else {
                this.setMergeHeadRowsExport(false);
            }
            paramStr = configItem.getProperty(TAG_EXPORTSELECT);
            if (!StringUtils.isEmpty((String)paramStr)) {
                this.setExportSelect(Boolean.valueOf(paramStr));
            } else {
                this.setExportSelect(false);
            }
            paramStr = configItem.getProperty(TAG_SAVEPATH);
            if (!StringUtils.isEmpty((String)paramStr)) {
                this.setSavePath(paramStr);
            } else {
                this.setSavePath(this.getDefaultPath());
            }
            paramStr = configItem.getProperty(TAG_OPENFILE);
            if (!StringUtils.isEmpty((String)paramStr)) {
                this.setOpenFile(Boolean.valueOf(paramStr));
            } else {
                this.setOpenFile(false);
            }
            paramStr = configItem.getProperty(TAG_MAXROWS);
            if (!StringUtils.isEmpty((String)paramStr)) {
                EXCEL2003_MAXROWS_VALUE = Integer.parseInt(paramStr);
            }
            if (!StringUtils.isEmpty((String)(paramStr = configItem.getProperty(TAG_DESENSITIZATION)))) {
                this.setDesensitizationExport(Boolean.valueOf(paramStr));
            } else {
                this.setDesensitizationExport(false);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExportExcelConfigParam other = (ExportExcelConfigParam)obj;
        if (this.excelVersion != other.excelVersion) {
            return false;
        }
        if (this.isExportMergeBlocks != other.isExportMergeBlocks) {
            return false;
        }
        if (this.isExportSelect != other.isExportSelect) {
            return false;
        }
        if (this.isOpenFile != other.isOpenFile) {
            return false;
        }
        if (this.isMergeHeadRowsExport != other.isMergeHeadRowsExport) {
            return false;
        }
        if (this.isDesensitizationExport != other.isDesensitizationExport) {
            return false;
        }
        return !(this.savePath == null ? other.savePath != null : !this.savePath.equals(other.savePath));
    }

    public String getConfigFileVersion() {
        return this.configFileVersion;
    }

    private String getDefaultPath() {
        String path = "";
        try {
            String suffix = this.isExportExcel2007() ? ".xlsx" : ".xls";
            File tempFile = File.createTempFile("tmp", suffix);
            path = tempFile.getParent();
            tempFile.delete();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return path;
    }

    public int getExcelVersion() {
        return this.excelVersion;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.excelVersion;
        result = 31 * result + (this.isExportMergeBlocks ? 1231 : 1237);
        result = 31 * result + (this.isMergeHeadRowsExport ? 1231 : 1237);
        result = 31 * result + (this.isExportSelect ? 1231 : 1237);
        result = 31 * result + (this.isOpenFile ? 1231 : 1237);
        result = 31 * result + (this.isDesensitizationExport ? 1231 : 1237);
        result = 31 * result + (this.savePath == null ? 0 : this.savePath.hashCode());
        return result;
    }

    public boolean isExportExcel2003() {
        return this.excelVersion == 1;
    }

    public boolean isExportExcel2007() {
        return this.excelVersion == 0;
    }

    public boolean isExportMergeBlocks() {
        return this.isExportMergeBlocks;
    }

    public boolean isExportSelect() {
        return this.isExportSelect;
    }

    public boolean isNewConfigFile() {
        return CURRENT_CONFIGFILE_VERSION.equals(this.configFileVersion);
    }

    public boolean isOpenFile() {
        return this.isOpenFile;
    }

    public boolean isMergeHeadRowsExport() {
        return this.isMergeHeadRowsExport;
    }

    public boolean isDesensitizationExport() {
        return this.isDesensitizationExport;
    }

    public void setConfigFileVersion(String configFileVersion) {
        this.configFileVersion = configFileVersion;
    }

    public void setExcelVersion(int excelVersion) {
        this.excelVersion = excelVersion;
    }

    public void setExportMergeBlocks(boolean isExportMergeBlocks) {
        this.isExportMergeBlocks = isExportMergeBlocks;
    }

    public void setExportSelect(boolean isExportSelect) {
        this.isExportSelect = isExportSelect;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setOpenFile(boolean isOpenFile) {
        this.isOpenFile = isOpenFile;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void setMergeHeadRowsExport(boolean isMergeHeadRowsExport) {
        this.isMergeHeadRowsExport = isMergeHeadRowsExport;
    }

    public void setDesensitizationExport(boolean isDesensitizationExport) {
        this.isDesensitizationExport = isDesensitizationExport;
    }

    public String toString() {
        return "excelVersion:" + this.excelVersion + ",isExportMergeBlocks:" + this.isExportMergeBlocks + ",isMergeHeadRowsExport:" + this.isMergeHeadRowsExport + ",isExportSelect:" + this.isExportSelect + ",isOpenFile:" + this.isOpenFile + ",isDesensitizationExport:" + this.isDesensitizationExport + ",savePath:" + this.savePath;
    }
}

