/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.multiDetail;

import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.common.CtrlUIEnv;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentException;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.UILifeCycleEvent;
import com.kingdee.eas.framework.client.UILifeCycleImp;
import com.kingdee.eas.framework.client.multiDetail.DetailPanelEvent;
import com.kingdee.eas.framework.client.multiDetail.IDetailPanelListener;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class DetailPanel
extends JPanel {
    private static final long serialVersionUID = -5058182349722236713L;
    private static final Logger logger = Logger.getLogger(DetailPanel.class);
    protected KDWorkButton btnAddnewLine;
    protected KDWorkButton btnInsertLine;
    protected KDWorkButton btnRemoveLines;
    protected KDPanel controlPanel;
    protected KDTable entryTable;
    protected KDPanel entryPanel;
    protected KDContainer kdConTitle;
    protected HashMap resourceMap = null;
    protected DataBinder dataBinder = null;
    private AbstractObjectValue newDetailInfo = null;
    private Rectangle rect = null;
    private boolean isAgent = false;
    private CoreUI ui = null;
    private Set addListeners = new HashSet();
    private Set removeListeners = new HashSet();
    private Set insertListeners = new HashSet();

    public DetailPanel(CoreUI ui, DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        this(binder, kdt, newVO, resourceMap, isAgent);
        this.ui = ui;
        this.ui.getUILifeCycleHandler().addRuleListener(new UILifeListener());
        actionBackListener backListener = new actionBackListener();
        this.addAddListener(backListener);
        this.addInsertListener(backListener);
        this.addRemoveListener(backListener);
    }

    public DetailPanel(DataBinder binder, KDTable kdt, AbstractObjectValue newVO, HashMap resourceMap, boolean isAgent) throws Exception {
        CtrlUIEnv.setKingdeeLAF();
        this.jbInit();
        if (binder == null) {
            logger.debug((Object)"databinder is not null!");
            return;
        }
        this.dataBinder = binder;
        this.entryTable = kdt;
        if (this.entryTable == null) {
            logger.debug((Object)"kdtable is not null!");
            return;
        }
        this.rect = this.entryTable.getBounds();
        this.newDetailInfo = newVO;
        if (this.newDetailInfo == null) {
            logger.debug((Object)"detailinfo is not null!");
        }
        this.resourceMap = resourceMap;
        this.isAgent = isAgent;
        this.initKDWorkButtion();
        this.initUIContentLayout();
    }

    private void initStatus(String oprtStatus) {
        if (this.ui != null) {
            boolean enabled = false;
            if (!OprtState.VIEW.equals(oprtStatus)) {
                enabled = true;
            }
            this.btnAddnewLine.setEnabled(enabled);
            this.btnInsertLine.setEnabled(enabled);
            this.btnRemoveLines.setEnabled(enabled);
        }
    }

    private void jbInit() throws Exception {
        this.kdConTitle = new KDContainer();
        this.kdConTitle.setName("kdDetailCon");
        this.kdConTitle.setBounds(0, 5, 100, 24);
        this.kdConTitle.setContainerType(2);
        this.kdConTitle.setTitleStyle(1);
        this.btnAddnewLine = new KDWorkButton();
        this.btnInsertLine = new KDWorkButton();
        this.btnRemoveLines = new KDWorkButton();
        this.controlPanel = new KDPanel();
        this.entryTable = new KDTable();
        this.entryPanel = new KDPanel();
        this.btnAddnewLine.setName("btnAddnewLine");
        this.btnInsertLine.setName("btnInsertLine");
        this.btnRemoveLines.setName("btnRemoveLines");
        this.controlPanel.setName("controlPanel");
        this.entryTable.setName("entryTable");
        this.entryPanel.setName("entryPanel");
        this.btnAddnewLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanel.this.actionAddnewLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    logger.debug((Object)("addLine error:" + e));
                }
            }
        });
        this.btnInsertLine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanel.this.actionInsertLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    logger.debug((Object)("InsertLine error:" + e));
                }
            }
        });
        this.btnRemoveLines.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DetailPanel.this.actionRemoveLine_actionPerformed(e);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    logger.debug((Object)("RemoveLine error:" + e));
                }
            }
        });
        this.registerBindings();
        this.registerUIState();
    }

    public KDWorkButton getAddNewLineButton() {
        return this.btnAddnewLine;
    }

    public KDWorkButton getInsertLineButton() {
        return this.btnInsertLine;
    }

    public KDWorkButton getRemoveLinesButton() {
        return this.btnRemoveLines;
    }

    public KDTable getEntryTable() {
        return this.entryTable;
    }

    public void initKDWorkButtion() {
        this.btnAddnewLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_AddLine"));
        this.btnAddnewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsertLine.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_InsertLine"));
        this.btnInsertLine.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnRemoveLines.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Tip_RemoveLine"));
        this.btnRemoveLines.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void initUIContentLayout() {
        this.setBounds(this.entryTable.getBounds());
        this.setLayout((LayoutManager)new KDLayout());
        this.putClientProperty("OriginalBounds", new Rectangle(0, 0, this.rect.width, this.rect.height));
        this.setBounds(this.entryTable.getBounds());
        Rectangle controlRect = new Rectangle(0, 0, this.rect.width, 24);
        this.controlPanel.setBounds(controlRect);
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)controlRect);
        Rectangle entryRect = new Rectangle(0, 29, this.rect.width, this.rect.height - 29);
        this.entryPanel.setBounds(entryRect);
        this.entryPanel.putClientProperty((Object)"OriginalBounds", (Object)entryRect);
        this.add((Component)this.controlPanel, new KDLayout.Constraints(13, controlRect));
        this.add((Component)this.entryPanel, new KDLayout.Constraints(15, entryRect));
        this.controlPanel.setLayout((LayoutManager)new KDLayout());
        this.controlPanel.add((Component)this.kdConTitle, (Object)new KDLayout.Constraints(0, 5, 100, 19, 5));
        this.controlPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, this.rect.width, 24));
        this.controlPanel.add((Component)this.btnAddnewLine, (Object)new KDLayout.Constraints(this.rect.width - 86, 5, 22, 19, 9));
        this.controlPanel.add((Component)this.btnInsertLine, (Object)new KDLayout.Constraints(this.rect.width - 59, 5, 22, 19, 9));
        this.controlPanel.add((Component)this.btnRemoveLines, (Object)new KDLayout.Constraints(this.rect.width - 32, 5, 22, 19, 9));
        this.entryPanel.setLayout((LayoutManager)new BorderLayout(0, 0));
        this.entryTable.setBounds(entryRect);
        this.entryPanel.add((Component)this.entryTable, (Object)"Center");
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "sdfdfsdf";
        }
        this.kdConTitle.setTitle(title);
    }

    public void setTitleWidth(int width) {
        if (width < 100) {
            width = 100;
        }
        int x = this.kdConTitle.getX();
        int y = this.kdConTitle.getY();
        int height = this.kdConTitle.getWidth();
        this.kdConTitle.setBounds(x, y, width, height);
    }

    private void registerBindings() {
    }

    private void registerUIState() {
    }

    public void loadFields() {
    }

    public void storeFields() {
    }

    public void actionAddnewLine_actionPerformed(ActionEvent e) throws Exception {
        this.addLine(this.entryTable);
    }

    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.insertLine(this.entryTable);
    }

    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.entryTable);
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        if (table == null) {
            return null;
        }
        if (this.isAgent) {
            EntityObjectInfo entity = MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.newDetailInfo.getBOSType());
            try {
                Class<?> agentClz = Class.forName(entity.getBusinessAgent());
                Method method = agentClz.getMethod("copyOvAsNewAgent", IObjectValue.class);
                Object obj = method.invoke(agentClz, this.newDetailInfo);
                if (obj instanceof IObjectValue) {
                    return (IObjectValue)obj;
                }
                return null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, e.getCause());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new AgentException("Exception at creating agent instance from BOS value object:" + this.newDetailInfo, (Throwable)e);
            }
        }
        return (IObjectValue)this.newDetailInfo.clone();
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    protected void addLine(KDTable table) throws Exception {
        if (table == null) {
            logger.info((Object)"table is null...");
            return;
        }
        if (table.getColumnCount() <= 0) {
            logger.info((Object)"table columscount is 0...");
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (this.ui instanceof EditUI) {
            ((EditUI)this.ui).getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        }
        this.fireAddLineBeforeAction(detailData);
        IRow row = table.addRow();
        this.loadLineFields(table, row, detailData);
        if (this.ui instanceof EditUI) {
            ((EditUI)this.ui).getUILifeCycleHandler().fireOnAddNewLine(table, row.getRowIndex());
        }
        this.fireAddLineAfterAction(detailData);
    }

    protected void insertLine(KDTable table) throws Exception {
        if (table == null) {
            logger.info((Object)"table is null...");
            return;
        }
        if (table.getColumnCount() <= 0) {
            logger.info((Object)"table columscount is 0...");
            return;
        }
        IObjectValue detailData = this.createNewDetailData(table);
        if (this.ui instanceof EditUI) {
            ((EditUI)this.ui).getUILifeCycleHandler().fireOnAddNewLine((Object)table, detailData);
        }
        this.fireInsertLineBeforeAction(detailData);
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        this.loadLineFields(table, row, detailData);
        if (this.ui instanceof EditUI) {
            ((EditUI)this.ui).getUILifeCycleHandler().fireOnAddNewLine(table, row.getRowIndex());
        }
        this.fireInsertLineAfterAction(detailData);
    }

    protected void removeLine2(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = table.getSelectManager().get().getTop();
        if (table.getRow(top) == null) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
        this.fireRemoveLineBeforeAction(detailData);
        table.removeRow(top);
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        if (collection == null) {
            logger.error((Object)"collection not be binded to table");
        } else if (detailData != null) {
            collection.removeObject(top);
        }
        this.fireRemoveLineAfterAction(detailData);
    }

    protected IObjectCollection getBindData(KDTable table) {
        return (IObjectCollection)table.getUserObject();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void storeLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.storeLineFields(table, row, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAddListener(IDetailPanelListener listener) {
        Set set = this.addListeners;
        synchronized (set) {
            this.addListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInsertListener(IDetailPanelListener listener) {
        Set set = this.insertListeners;
        synchronized (set) {
            this.insertListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemoveListener(IDetailPanelListener listener) {
        Set set = this.removeListeners;
        synchronized (set) {
            this.removeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAddLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.addListeners;
        synchronized (set) {
            iterator = new HashSet(this.addListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.insertListeners;
        synchronized (set) {
            iterator = new HashSet(this.insertListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineBeforeAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.beforeEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveLineAfterAction(IObjectValue vo) throws Exception {
        Iterator iterator;
        Set set = this.removeListeners;
        synchronized (set) {
            iterator = new HashSet(this.removeListeners).iterator();
        }
        DetailPanelEvent event = new DetailPanelEvent(this, vo);
        while (iterator.hasNext()) {
            IDetailPanelListener listener = (IDetailPanelListener)iterator.next();
            listener.afterEvent(event);
        }
        this.entryTable.repaint();
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    protected void removeLine(KDTable table) throws Exception {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)this, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                this.fireRemoveLineBeforeAction(detailData);
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.fireRemoveLineAfterAction(detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    class UILifeListener
    extends UILifeCycleImp {
        UILifeListener() {
        }

        @Override
        public void beforeOnload(UILifeCycleEvent event) {
            CoreUI ui = (CoreUI)event.getSource();
            DetailPanel.this.initStatus(ui.getOprtState());
        }

        @Override
        public void onSetDataObject(UILifeCycleEvent event) {
            this.beforeOnload(event);
        }
    }

    class actionBackListener
    implements IDetailPanelListener {
        actionBackListener() {
        }

        @Override
        public void beforeEvent(DetailPanelEvent event) throws Exception {
        }

        @Override
        public void afterEvent(DetailPanelEvent event) throws Exception {
            if (DetailPanel.this.ui == null) {
                return;
            }
            if (DetailPanel.this.ui instanceof EditUI) {
                EditUI editUI = (EditUI)DetailPanel.this.ui;
                editUI.refreshFootROw(DetailPanel.this.entryTable);
            }
        }
    }
}

