/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.popup;

import com.kingdee.eas.framework.client.popup.MenuContributionEvent;
import com.kingdee.eas.framework.client.popup.MenuContributionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.EventListenerList;

public class MenuSection {
    private String name;
    private boolean dynamic;
    private LinkedList menus = new LinkedList();
    private EventListenerList listeners = new EventListenerList();

    public MenuSection(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public void insertBefore(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu == null");
        }
        this.menus.addFirst(menu);
    }

    public void insertBefore(JMenuItem menuItem) {
        if (menuItem == null) {
            throw new IllegalArgumentException("menuItem == null");
        }
        this.menus.addFirst(menuItem);
    }

    public void insertBefore(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action == null");
        }
        JMenuItem menuItem = new JMenuItem(action);
        this.insertBefore(menuItem);
    }

    public boolean containsMenuItemName(String name) {
        for (JMenuItem menuItem : this.menus) {
            if (!name.equals(menuItem.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsMenuItem(JMenuItem menuItem) {
        return this.menus.contains(menuItem);
    }

    public boolean containsMenu(JMenu menu) {
        return this.menus.contains(menu);
    }

    public boolean containsAction(Action action) {
        for (JMenuItem menuItem : this.menus) {
            if (menuItem.getAction() != action) continue;
            return true;
        }
        return false;
    }

    public void insertAfter(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("menu == null");
        }
        this.menus.addLast(menu);
    }

    public void insertAfter(JMenuItem menuItem) {
        if (menuItem == null) {
            throw new IllegalArgumentException("menuItem == null");
        }
        this.menus.addLast(menuItem);
    }

    public void insertAfter(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("action == null");
        }
        JMenuItem menuItem = new JMenuItem(action);
        this.insertAfter(menuItem);
    }

    public void addMenuContributionListener(MenuContributionListener listener) {
        this.listeners.add(MenuContributionListener.class, listener);
    }

    public void removeMenuContributionListener(MenuContributionListener listener) {
        this.listeners.remove(MenuContributionListener.class, listener);
    }

    List allMenuItems() {
        return this.menus;
    }

    void show() {
        this.menus.clear();
        Object[] listenerList = this.listeners.getListenerList();
        MenuContributionEvent event = new MenuContributionEvent(this);
        for (int i = listenerList.length - 2; i >= 0; i -= 2) {
            if (listenerList[i] != MenuContributionListener.class) continue;
            MenuContributionListener listener = (MenuContributionListener)listenerList[i + 1];
            listener.contribute(event);
        }
    }
}

