/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.relogin;

import com.kingdee.eas.base.license.LicenseUserInfo;
import com.kingdee.eas.base.license.client.LicenseClientCache;
import com.kingdee.eas.base.license.client.LicenseController;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.framework.client.service.LicenseService;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.IReloginAction;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.util.List;

public class LicenseCheckAction
implements IReloginAction {
    public void doAction() throws Exception {
        LicenseUserInfo user = (LicenseUserInfo)SysContext.getSysContext().getProperty((Object)"License.UserInfo");
        LicenseController lc = FrameWorkClientUtils.getLicenseController();
        List licenseRecordList = LicenseService.getLicenseRecordList();
        if (licenseRecordList != null && licenseRecordList.size() > 0) {
            LicenseClientCache.distoryInstance();
        }
        if (licenseRecordList == null) {
            return;
        }
        for (String className : licenseRecordList) {
            if (StringUtils.isEmpty((String)className)) continue;
            int licenselcFlag = 0;
            boolean isUserDef = false;
            int index = className.indexOf(LicenseService.USERDEF);
            if (index > -1) {
                className = className.substring(0, index);
                licenselcFlag = lc.requestLicenseByUserAndSubSystemOnCache(user, className);
                isUserDef = true;
            } else {
                licenselcFlag = lc.requestLicense(user, className);
            }
            switch (licenselcFlag) {
                case 1: {
                    break;
                }
                case 4: {
                    String msg = "";
                    if (isUserDef) {
                        LicenseService.constructLicenseMessageByModuleName(lc, className);
                    } else {
                        LicenseService.constructLicenseMessage(lc, className);
                    }
                    MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_Invalid"), (String)msg, (int)0);
                    SysUtil.abort();
                    return;
                }
                case 2: {
                    MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_License_NO_SURPLUS"), (String)LicenseService.constructLicenseMessage(lc, className), (int)0);
                    SysUtil.abort();
                    return;
                }
            }
        }
    }
}

