/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.common.client.OprtState;
import java.awt.Component;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FieldPermissionService {
    static String status = null;

    public static void setStatus(String status) {
        FieldPermissionService.status = status;
    }

    public static FieldPermission doFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK, DataBinder dataBinder, FieldPermission oldFields) throws Exception {
        if (oldFields != null) {
            FieldPermissionService.restoreFieldPermission(oldFields, dataBinder);
        }
        FieldPermission curFieldPermission = FieldPermissionService.doFieldPermission(bizObjectType, userPK, orgPK, dataBinder);
        return curFieldPermission;
    }

    public static FieldPermission doFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK, DataBinder dataBinder) throws Exception {
        FieldPermission fields = PermissionHelper.getFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK);
        FieldPermissionService.innerDoFieldPermission(fields, dataBinder);
        return fields;
    }

    private static void innerDoFieldPermission(FieldPermission fieldPermission, DataBinder dataBinder) {
        Component comp = null;
        FieldAccessInfo fieldAccess = null;
        for (int i = 0; i < fieldPermission.size(); ++i) {
            fieldAccess = fieldPermission.get(i);
            String fieldName = fieldAccess.getFieldName();
            comp = dataBinder.getComponetByField(fieldName);
            if (comp == null) continue;
            KDTable table = null;
            String columnName = null;
            if (comp instanceof KDTable && (table = (KDTable)comp) != null) {
                ComponentProperty comproperty = dataBinder.getDataComponentMap().getComponentProperty(fieldName);
                String propertyName = comproperty.getPropertyName();
                columnName = propertyName.lastIndexOf(".") > 0 ? propertyName.substring(0, propertyName.lastIndexOf(".") - 1) : propertyName;
            }
            if (!fieldPermission.isEnableFieldPermission(fieldName)) continue;
            if (fieldAccess.isEditable() && OprtState.EDIT.equals(status)) {
                if (comp instanceof IKDTextComponent) {
                    ((IKDTextComponent)comp).setAccessAuthority(0);
                }
                if (comp instanceof KDTable && columnName != null) {
                    table.getColumn(columnName).getStyleAttributes().setHided(false);
                }
            }
            if (fieldAccess.isViewable()) {
                if (comp instanceof IKDTextComponent && !fieldAccess.isEditable()) {
                    ((IKDTextComponent)comp).setAccessAuthority(1);
                }
                if (comp instanceof KDTable && !fieldAccess.isEditable() && columnName != null) {
                    table.getColumn(columnName).getStyleAttributes().setLocked(true);
                    table.getColumn(columnName).getStyleAttributes().setHided(false);
                }
            }
            if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
                if (comp instanceof IKDTextComponent) {
                    ((IKDTextComponent)comp).setAccessAuthority(2);
                }
                if (comp instanceof KDTable && columnName != null) {
                    table.getColumn(columnName).getStyleAttributes().setHided(true);
                }
            }
            columnName = null;
        }
    }

    private static void restoreFieldPermission(FieldPermission oldFieldPermission, DataBinder dataBinder) {
        Component comp = null;
        FieldAccessInfo fieldAccess = null;
        for (int i = 0; i < oldFieldPermission.size(); ++i) {
            fieldAccess = oldFieldPermission.get(i);
            String fieldName = fieldAccess.getFieldName();
            comp = dataBinder.getComponetByField(fieldName);
            if (comp == null) continue;
            KDTable table = null;
            String columnName = null;
            if (comp instanceof KDTable && (table = (KDTable)comp) != null) {
                ComponentProperty comproperty = dataBinder.getDataComponentMap().getComponentProperty(fieldName);
                String propertyName = comproperty.getPropertyName();
                columnName = propertyName.lastIndexOf(".") > 0 ? propertyName.substring(0, propertyName.lastIndexOf(".") - 1) : propertyName;
            }
            if (!oldFieldPermission.isEnableFieldPermission(fieldName)) continue;
            if (fieldAccess.isViewable()) {
                if (comp instanceof IKDTextComponent && !fieldAccess.isEditable()) {
                    ((IKDTextComponent)comp).setAccessAuthority(0);
                }
                if (comp instanceof KDTable && !fieldAccess.isEditable() && columnName != null) {
                    table.getColumn(columnName).getStyleAttributes().setLocked(false);
                    table.getColumn(columnName).getStyleAttributes().setHided(false);
                }
            }
            if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
                if (comp instanceof IKDTextComponent) {
                    ((IKDTextComponent)comp).setAccessAuthority(0);
                }
                if (comp instanceof KDTable && table != null && columnName != null) {
                    table.getColumn(columnName).getStyleAttributes().setHided(false);
                }
            }
            columnName = null;
        }
    }

    public static FieldPermission doFieldPermission(IMetaDataPK metaDataPK, IObjectPK userPK, IObjectPK orgPK, KDTable table, FieldPermission oldFieldPermission) throws Exception {
        if (oldFieldPermission != null) {
            FieldPermissionService.restoreQueryPermission(oldFieldPermission, table);
        }
        return FieldPermissionService.doFieldPermission(metaDataPK, userPK, orgPK, table);
    }

    public static FieldPermission doFieldPermission(IMetaDataPK metaDataPK, IObjectPK userPK, IObjectPK orgPK, KDTable table) throws Exception {
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        fields = PermissionHelper.getQueryFieldPermission((IMetaDataPK)metaDataPK, (IObjectPK)userPK, (IObjectPK)orgPK);
        for (int i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            IColumn col = null;
            String columnName = null;
            if (table != null) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    col = table.getColumn(j);
                    if (!fieldName.equals(col.getFieldName())) continue;
                    columnName = table.getColumns().getColumnKey(j);
                    break;
                }
            }
            if (columnName == null || !fields.isEnableFieldPermission(fieldName)) continue;
            if (fieldAccess.isViewable()) {
                // empty if block
            }
            if (fieldAccess.isEditable()) {
                // empty if block
            }
            if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
                table.getColumn(columnName).getStyleAttributes().setHided(true);
            }
            columnName = null;
        }
        return fields;
    }

    private static void restoreQueryPermission(FieldPermission oldFieldPermission, KDTable table) {
        FieldAccessInfo fieldAccess = null;
        for (int i = 0; i < oldFieldPermission.size(); ++i) {
            fieldAccess = oldFieldPermission.get(i);
            String fieldName = fieldAccess.getFieldName();
            IColumn col = null;
            String columnName = null;
            if (table != null) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    col = table.getColumn(j);
                    if (!fieldName.equals(col.getFieldName())) continue;
                    columnName = table.getColumns().getColumnKey(j);
                    break;
                }
            }
            if (columnName == null || !oldFieldPermission.isEnableFieldPermission(fieldName)) continue;
            if (!fieldAccess.isViewable() && !fieldAccess.isEditable()) {
                table.getColumn(columnName).getStyleAttributes().setHided(false);
            }
            columnName = null;
        }
    }

    public static Map doMutilOrgPermission(IMetaDataPK queryPK, IObjectPK userPK, List orgIdStrList, KDTable table) throws Exception {
        HashMap fieldMap = new HashMap();
        HashMap<String, String> columnMap = new HashMap<String, String>();
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        if (table != null) {
            IColumn col = null;
            for (int j = 0; j < table.getColumnCount(); ++j) {
                col = table.getColumn(j);
                if (col.getWidth() < 0) continue;
                String fieldName = col.getFieldName();
                columnMap.put(fieldName, col.getKey());
            }
        }
        Map tempMap = PermissionHelper.getQueryFieldPermission((IMetaDataPK)queryPK, (IObjectPK)userPK, (List)orgIdStrList);
        for (Map.Entry entry : tempMap.entrySet()) {
            String orgId = (String)entry.getKey();
            fields = (FieldPermission)entry.getValue();
            LinkedList list = new LinkedList();
            for (int i = 0; i < fields.size(); ++i) {
                fieldAccess = fields.get(i);
                String fieldName = fieldAccess.getFieldName();
                if (!columnMap.containsKey(fieldName) || !fields.isEnableFieldPermission(fieldName) || fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
                list.add(columnMap.get(fieldName));
            }
            if (list.size() == 0) continue;
            fieldMap.put(orgId, list);
        }
        return fieldMap;
    }
}

