/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.service;

import com.kingdee.bos.appframework.client.servicebinding.IBindService;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseException;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LowTimer;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.Uuid;
import java.util.Map;
import org.apache.log4j.Logger;

public class NetFunctionService
implements IBindService {
    private static Logger logger = Logger.getLogger(NetFunctionService.class);
    public static final String NETUUID = "NetUuid";
    public static final String NETFUNCID = "NETFUNCID";
    private Map serviceContext;
    private Map uiContext;
    private MutexParameter param = null;
    private Uuid uuid = null;
    private boolean functionLocked = false;
    private IItemAction act = null;

    public void beforeActionPerformed(Map serviceContext) throws Throwable {
        this.serviceContext = serviceContext;
        this.uiContext = (Map)serviceContext.get("UICONTEXT");
        LowTimer t = new LowTimer();
        t.reset();
        this.act = (IItemAction)serviceContext.get("ACTION");
        if (this.act != null) {
            this.uuid = (Uuid)this.act.getValue(NETUUID);
            if (this.uuid != null & this.functionLocked) {
                logger.info((Object)"Handle net control for function 2nd times, so ignore it...");
                return;
            }
            this.handleNetControlForFunction(this.act);
            logger.info((Object)("Handle net control for function : " + t.msValue() + "ms"));
        }
    }

    private void handleNetControlForFunction(IItemAction act) throws Throwable {
        String mutexStr = act.getExtendProperty("Mutex");
        if (mutexStr == null || mutexStr.trim().length() < 1) {
            return;
        }
        String[][] mutexs = this.resolveMutexStr(mutexStr);
        MutexParameter param = this.createDefaultMutexParameter(act);
        for (int i = 0; i < mutexs.length; ++i) {
            param.setMutexName(mutexs[i][0]);
            if (mutexs[i][1].equals("0")) {
                param.setMutexLockType(MutexLockType.SHARE_LOCK);
            } else {
                param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
            }
            if (!this.getMutex(param)) {
                if (this.uuid != null) {
                    FrameWorkClientUtils.createMutexServiceControl().releaseMutex(this.uuid);
                    this.functionLocked = false;
                    this.uuid = null;
                }
                throw new EASBizException(new NumericExceptionSubItem("100", EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_MutexSC_Request")));
            }
            if (this.uuid == null) continue;
            this.uiContext.put(NETFUNCID, this.uuid);
            this.functionLocked = true;
        }
    }

    private boolean getMutex(MutexParameter param) {
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        return mutexServiceControl.requestMutex(param);
    }

    private MutexParameter createDefaultMutexParameter(IItemAction action) {
        this.param = (MutexParameter)this.uiContext.get("MUTEXPARA");
        if (this.param == null) {
            this.param = new MutexParameter();
        }
        if (this.uuid == null) {
            this.uuid = Uuid.create();
        }
        this.param.setRequestId(this.uuid);
        this.param.setActionName(action.getExtendProperty("Name"));
        UserInfo userinfo = SysContext.getSysContext().getCurrentUserInfo();
        this.param.setUserID(userinfo.getId());
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        this.param.setDcName(dcName);
        IObjectValue obj = null;
        if (this.uiContext.get("DATAOBJECTS") != null) {
            obj = (IObjectValue)((Map)this.uiContext.get("DATAOBJECTS")).get(this.uiContext.get("DATAOBJECTNAME"));
        }
        if (obj != null && obj.getObjectValue("Company") != null && obj.getObjectValue("Company").getString("id").trim().length() > 0) {
            this.param.setOrgUnitID(BOSUuid.read((String)obj.getObjectValue("Company").getString("id")));
        }
        return this.param;
    }

    private String[][] resolveMutexStr(String mutexStr) throws CoreBaseException {
        try {
            String[] mutexArray = mutexStr.split(";");
            String[][] mutexs = new String[mutexArray.length][2];
            for (int i = 0; i < mutexs.length; ++i) {
                String[] mutex = mutexArray[i].split(",");
                for (int j = 0; j < 2; ++j) {
                    int testnumber;
                    mutexs[i][j] = mutex[j];
                    if (j != 1 || (testnumber = new Integer(mutexs[i][j]).intValue()) <= 1) continue;
                    throw new CoreBaseException(CoreBaseException.ERROR_MUTEXSC_DEFINE);
                }
            }
            return mutexs;
        }
        catch (Exception err) {
            throw new CoreBaseException(CoreBaseException.ERROR_MUTEXSC_DEFINE);
        }
    }

    public void afterActionPerformed(Map serviceContext) throws Throwable {
    }

    private void releaseFunctionMutex() {
        if (this.uuid != null && this.act != null) {
            Uuid uid = (Uuid)this.act.getValue(NETUUID);
            if (uid == null) {
                uid = (Uuid)this.uiContext.get(NETFUNCID);
            }
            if (this.uuid != null & this.uuid == uid) {
                FrameWorkClientUtils.createMutexServiceControl().releaseMutex(this.uuid);
                this.functionLocked = false;
                this.uiContext.put(NETFUNCID, null);
                this.uuid = null;
            }
        }
    }

    public void finalActionPerformed(Map serviceContext) throws Throwable {
        this.serviceContext = serviceContext;
        this.uiContext = (Map)serviceContext.get("UICONTEXT");
        if (this.act != null && !this.act.isDaemonRun()) {
            LowTimer t = new LowTimer();
            t.reset();
            this.releaseFunctionMutex();
            logger.info((Object)("Release function mutex : " + t.msValue() + "ms"));
        }
    }
}

