/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.sidebar;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeLookAndFeel;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeToolBarUI;
import com.kingdee.bos.ctrl.swing.util.SwingLogUtil;
import com.kingdee.eas.base.weibo.util.WeiboBizUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.sidebar.SideBarBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.jdesktop.jdic.browser.WebBrowser;
import org.jdesktop.jdic.browser.WebBrowserEvent;
import org.jdesktop.jdic.browser.WebBrowserListener;

public class SideBarArea
extends SideBarBase
implements Runnable,
ActionListener {
    private Logger logger = Logger.getLogger(SideBarArea.class);
    public static final String EAS_SIDEBAR_MAX_ICON = "weibo_sidebar_max.png";
    public static final String EAS_SIDEBAR_RESTORE_ICON = "weibo_sidebar_max.png";
    public static final String EAS_SIDEBAR_CLOSE_ICON = "weibo_sidebar_close.png";
    private WebBrowser browser;
    public static final String EAS_HTTP_Pre_String = "http://";
    private String currentURL = "http://ip:port/easportal/index2weibo.jsp";
    private String billIDStr = "billId=";
    private String userNameStr = "userName=";
    private String questionMarkStr = "?";
    private String ampersandMarkStr = "&";
    private final String defaultURL = "http://t.kingdee.com";
    public static final String EAS_WeiBo_SideBar_Close_Img_String = "weibo_sidebar_close.png";
    public static final String EAS_WeiBo_SideBar_Left_Img_String = "imgWBSidebar_left";
    private static final String addAttention_Btn_String = "addAttentionBtn";
    private static final String cancelAttention_Btn_String = "cancelAttentionBtn";
    private static final String updateBillSummary_Btn_String = "updateBillSummaryBtn";
    private static final String max_Norm_Lab_String = "max_Norm_Lab";
    private static final String close_Lab_String = "closeLab";
    private static final String hide_Lab_String = "hideLab";
    public static final int EAS_Windows_Title_Height = 32;
    public static final int EAS_Windows_Border_Width = 3;
    public static final int EAS_Windows_TooBar_Height = 20;
    public static final int EAS_Windows_Menu_Height = 21;
    public static final int EAS_Windows_Task_Height = 21;
    public static final int EAS_Windows_StatusBar_Height = 21;
    public static final int EAS_WeiBo_Side_Default_Width = 700;
    public static final int EAS_WeiBo_Side_Default_Height = 859;
    public static final int EAS_WeiBo_Side_Flash_Time = 5;
    private Dimension dim;
    private Rectangle rect;
    private static Insets screenInsets;
    private int x;
    private int y;
    private int width;
    private int height;
    private JPanel sideBar;
    private Component winOwner;
    private ControlPanel titleBar;
    private KDWorkButton addAttention;
    private KDWorkButton cancelAttention;
    private KDWorkButton updateBillSummary;
    private JLabel hideLab;
    private JLabel title_Lab;
    private JPanel funBar;
    private JLabel close_Lab;
    private boolean isMax = false;
    private LeftPanel left;
    private String lastURLStr;
    private String lastBillID;
    private static String strTip;
    private static Icon imageIcon;
    JPanel browserPane = null;

    public SideBarArea(Component parent) {
        super(parent);
        this.initComponents();
        this.x = 0;
        this.y = 0;
        this.winOwner = parent;
        this.initOwner(parent);
        this.dim = this.getOwnerWindow().getSize();
        this.rect = this.getOwnerWindow().getBounds();
        System.out.println("dim:" + Double.toString(this.dim.getWidth()) + "//dim h:" + Double.toString(this.dim.getHeight()));
        this.getDialog().setVisible(false);
        this.normWin();
    }

    private void initComponents() {
        Icon icon_Hide = EASResource.getIcon((String)EAS_WeiBo_SideBar_Left_Img_String);
        this.titleBar = new ControlPanel("");
        this.titleBar.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Tree.treeCtrlPaneBorder")));
        this.titleBar.setLayout(this.titleBar);
        JPanel actionPane = new JPanel();
        actionPane.setLayout(new BorderLayout());
        this.addAttention = new KDWorkButton();
        this.addAttention.setName(addAttention_Btn_String);
        this.addAttention.setText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"64_SideBarArea"));
        this.cancelAttention = new KDWorkButton();
        this.cancelAttention.setName(cancelAttention_Btn_String);
        this.cancelAttention.setText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"65_SideBarArea"));
        this.title_Lab = new JLabel();
        this.close_Lab = new JLabel();
        this.close_Lab.setName(close_Lab_String);
        this.close_Lab.setToolTipText(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"66_SideBarArea"));
        this.titleBar.setLayout(new BorderLayout());
        this.titleBar.add((Component)actionPane, "West");
        this.titleBar.add((Component)this.title_Lab, "Center");
        this.titleBar.add((Component)this.close_Lab, "East");
        this.browser = new WebBrowser();
        this.browser.addWebBrowserListener(new WebBrowserListener(){

            public void windowClose(WebBrowserEvent e) {
                SideBarArea.this.closeWin();
            }

            public void documentCompleted(WebBrowserEvent event) {
                SideBarArea.this.currentURL = SideBarArea.this.browser.getURL().toString();
            }

            public void downloadCompleted(WebBrowserEvent event) {
            }

            public void downloadError(WebBrowserEvent event) {
            }

            public void downloadProgress(WebBrowserEvent event) {
            }

            public void downloadStarted(WebBrowserEvent event) {
            }

            public void statusTextChange(WebBrowserEvent event) {
            }

            public void titleChange(WebBrowserEvent event) {
            }

            public void initializationCompleted(WebBrowserEvent event) {
            }
        });
        this.browserPane = new JPanel();
        this.browserPane.setLayout(new BorderLayout(0, 0));
        this.browserPane.add((Component)this.browser, "Center");
        this.browserPane.setBackground(Color.white);
        this.left = new LeftPanel(this.getDialog());
        this.left.setLayout(new BorderLayout());
        JLabel lab1 = new JLabel("");
        JLabel lab3 = new JLabel("");
        this.hideLab = new JLabel();
        this.hideLab.setIcon(icon_Hide);
        this.hideLab.setName(hide_Lab_String);
        this.left.add((Component)lab1, "North");
        this.left.add((Component)this.hideLab, "Center");
        this.left.add((Component)lab3, "South");
        this.getSideBarPane().setLayout(new BorderLayout());
        this.getSideBarPane().add((Component)this.left, "West");
        this.getSideBarPane().add((Component)this.browserPane, "Center");
        this.logger.info((Object)"weibo sidebar init 1 ....");
        SideBarAreaMouseListener weiBo_Close_Lis = new SideBarAreaMouseListener(this.close_Lab);
        this.close_Lab.addMouseListener(weiBo_Close_Lis);
        SideBarAreaMouseListener weiBo_Hide_Lis = new SideBarAreaMouseListener(this.hideLab);
        this.hideLab.addMouseListener(weiBo_Hide_Lis);
        this.logger.info((Object)"weibo sidebar init 2 ....");
        this.logger.info((Object)"weibo sidebar init finished...");
    }

    public boolean gotoURL(String url) {
        if (url != null && !"".equals(url)) {
            try {
                URL Url = null;
                Url = !url.startsWith(EAS_HTTP_Pre_String) ? new URL(EAS_HTTP_Pre_String + url) : new URL(url);
                this.browser.setURL(Url);
                return true;
            }
            catch (MalformedURLException e) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"67_SideBarArea") + this.currentURL + EASResource.getString((String)"com.kingdee.eas.framework.FrameworkCodeSourceRes", (String)"68_SideBarArea")));
                e.printStackTrace();
                this.logger.error((Object)e);
            }
        }
        return false;
    }

    public void initOwner(Component parent) {
        if (this.winOwner == null) {
            this.winOwner = parent;
        }
    }

    public void setLocation(int x, int y) {
        this.getSideBarPane().setLocation(x, y);
    }

    public void setSize(int width, int height) {
        this.getSideBarPane().setSize(width, height);
    }

    public void hideWin() {
        for (int i = 0; i <= this.width; i += 10) {
            try {
                this.getDialog().setLocation(this.x + i, this.y);
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException ex) {
                this.logger.error((Object)ex.toString());
                ex.printStackTrace();
            }
        }
        this.getDialog().setVisible(false);
        if (this.getOwner() instanceof JDialog) {
            this.getOwner().setVisible(true);
        }
    }

    public void closeWin() {
        this.getDialog().setVisible(false);
    }

    public String getCurrentURLStr() {
        String url = this.defaultURL;
        try {
            url = WeiboBizUtil.getGUIBillWeiboUrl((String)this.getBillID(), (String)Integer.toString(this.height), (String)this.getLocal(), (String)this.getDCNumber(), (String)"4");
            this.logger.info((Object)url);
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
            e.printStackTrace();
        }
        return url;
    }

    public void showWiebo() {
        this.refresh();
    }

    public void refresh() {
        String currUrl = this.getCurrentURLStr();
        if (this.lastURLStr != null && this.lastURLStr.equalsIgnoreCase(currUrl)) {
            return;
        }
        if (this.lastBillID != null && this.lastBillID.equalsIgnoreCase(this.getBillID())) {
            return;
        }
        this.gotoURL(currUrl);
        this.browser.repaint();
        this.lastURLStr = currUrl;
        this.lastBillID = this.getBillID();
    }

    @Override
    public void run() {
        this.show();
        this.getDialog().setVisible(true);
        this.logger.info((Object)"weibo run ....");
        for (int i = 0; i <= this.width; i += 10) {
            try {
                this.getDialog().setLocation(this.x + this.width - i, this.y);
                Thread.sleep(5L);
                continue;
            }
            catch (InterruptedException ex) {
                this.logger.error((Object)"weibo error......");
                this.logger.error((Object)ex);
            }
        }
        this.refresh();
        this.left.refresh();
        this.logger.info((Object)"weibo run finished....");
    }

    private void maxWin() {
        this.width = (int)(this.dim.getWidth() - 6.0);
        this.getBrowserHeight();
        this.x = 3;
        this.y = 73;
        this.getDialog().setLocation(this.x, this.y);
        this.getDialog().setSize(this.width, this.height);
        System.out.println("max dia w:" + Integer.toString(this.getDialog().getWidth()) + "//dia h:" + Integer.toString(this.getDialog().getHeight()));
    }

    private void getBrowserHeight() {
        this.height = (int)(this.dim.getHeight() - 21.0 - 20.0 - 64.0 - 21.0 - 21.0);
        int ownerWinHight = this.getOwnerWindow().getHeight();
    }

    private void normWin() {
        this.width = 700;
        this.getBrowserHeight();
        this.x = this.dim != null && this.dim.getWidth() > (double)this.width ? (int)(this.dim.getWidth() - 3.0 - (double)this.width) : 0;
        this.y = 105;
        this.y = (int)(this.rect.getY() + 3.0 + 21.0 + 32.0 + 20.0);
        this.getDialog().setVisible(false);
        this.getDialog().setLocation(this.x, this.y);
        this.getDialog().setSize(this.width, this.height);
        this.getDialog().repaint();
    }

    public void reLocation() {
        if (this.isMax) {
            this.maxWin();
        } else {
            this.normWin();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.logger.info((Object)"updae weibo bill summary...");
        if (e.getSource() == this.updateBillSummary) {
            try {
                WeiboBizUtil.updateBillDigest((String)this.billIDStr, (String)"4");
                this.logger.info((Object)"updae weibo bill summary finished.");
            }
            catch (EASBizException e1) {
                this.logger.error((Object)e1);
                e1.printStackTrace();
            }
            catch (BOSException e1) {
                this.logger.error((Object)e1);
                e1.printStackTrace();
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(700, 859);
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    static {
        strTip = null;
        imageIcon = null;
    }

    public static class LeftPanel
    extends JPanel
    implements LayoutManager,
    ComponentListener,
    WindowFocusListener {
        private static final long serialVersionUID = 1750485595027807275L;
        private JDialog dia;
        private Boolean isHiding = false;
        private Boolean isShowing = false;
        private Boolean start = false;
        private Image background;
        private Point p;

        public LeftPanel() {
        }

        public void updateBackground() {
            try {
                Robot rbt = new Robot();
                Toolkit tk = Toolkit.getDefaultToolkit();
                Dimension dim = tk.getScreenSize();
                this.background = rbt.createScreenCapture(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void refresh() {
            if (this.start.booleanValue()) {
                this.updateBackground();
                this.dia.setLocation(this.p);
                if (this.p.x < 0 || this.p.y < 0) {
                    this.dia.setLocation(0, 0);
                }
                this.repaint();
            }
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            System.out.println("Hidden");
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            System.out.println("moved");
            this.repaint();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            System.out.println("resized");
            this.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            System.out.println("shown");
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            System.out.println("gainedFocus");
            this.refresh();
            this.start = false;
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
        }

        public LeftPanel(JDialog d) {
            this.dia = d;
            this.updateBackground();
            this.setSize(200, 120);
            this.setVisible(true);
            d.addComponentListener(this);
            d.addWindowFocusListener(this);
        }

        @Override
        public void paintComponent(Graphics g) {
            Point pos = this.getLocationOnScreen();
            Point offset = new Point(-pos.x, -pos.y);
            g.drawImage(this.background, offset.x, offset.y, null);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    public static class ControlPanel
    extends JPanel
    implements LayoutManager {
        private static final long serialVersionUID = -4632988822952729635L;
        private String title = "";
        private JLabel label = new JLabel();

        public ControlPanel(String title) {
            this.title = title;
            if (!StringUtil.isEmptyString((String)title)) {
                ToolTipManager.sharedInstance().registerComponent(this.label);
                this.label.setToolTipText(title);
                this.label.setText(title);
            }
            this.add(this.label);
        }

        @Override
        public Component add(Component comp) {
            if (comp instanceof KDWorkButton) {
                KDWorkButton kb = (KDWorkButton)comp;
                kb.setFactType(0);
                kb.setBorder(null);
                kb.setContentAreaFilled(false);
                kb.setOpaque(false);
                MouseListener[] listeners = kb.getMouseListeners();
                if (listeners != null) {
                    for (int i = 0; i < listeners.length; ++i) {
                        if (!(listeners[i] instanceof KingdeeToolBarUI.MouseHandler)) continue;
                        kb.removeMouseListener(listeners[i]);
                    }
                }
            }
            return super.add(comp);
        }

        @Override
        public void paint(Graphics g) {
            Color oldColor = g.getColor();
            Dimension size = this.getSize();
            super.paint(g);
            g.drawImage(ControlPanel.getImage("Tree.treeTitlePic"), 1, 1, 10, 20, null, null);
            g.drawImage(ControlPanel.getImage("Tree.treeTitleBg"), 11, 1, size.width - 12, size.height - 2, null, null);
            g.setColor(UIManager.getColor("Tree.treeTitleColor"));
            g.setFont(KingdeeLookAndFeel.getSystemRenderFont());
            g.setColor(oldColor);
            this.paintChildren(g);
        }

        @Override
        public void addLayoutComponent(String name, Component child) {
        }

        @Override
        public void removeLayoutComponent(Component child) {
        }

        @Override
        public Dimension preferredLayoutSize(Container Container2) {
            return this.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container Container2) {
            return this.preferredLayoutSize(Container2);
        }

        @Override
        public void layoutContainer(Container container) {
            Dimension sbSize = container.getSize();
            Component[] comps = container.getComponents();
            int x = sbSize.width;
            for (int i = comps.length; i > 0; --i) {
                if (comps[i - 1].isVisible()) {
                    comps[i - 1].setBounds(x -= 29, 2, 26, 20);
                }
                if (!(comps[i - 1] instanceof JLabel) || x <= 0) continue;
                comps[i - 1].setBounds(15, 2, x, 20);
            }
        }

        public static Image getImage(Object key) {
            ImageIcon icon = (ImageIcon)UIManager.getIcon(key);
            Image image = icon.getImage();
            if (image == null) {
                SwingLogUtil.info((String)key.toString());
            }
            return image;
        }
    }

    class SideBarAreaMouseListener
    implements MouseListener {
        JLabel source = null;

        public SideBarAreaMouseListener(JLabel s) {
            this.source = s;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this.source.getName() == SideBarArea.max_Norm_Lab_String && !SideBarArea.this.isMax) {
                SideBarArea.this.isMax = true;
                SideBarArea.this.maxWin();
            } else if (this.source.getName() == SideBarArea.max_Norm_Lab_String && SideBarArea.this.isMax) {
                SideBarArea.this.isMax = false;
                SideBarArea.this.normWin();
            }
            if (this.source.getName() == SideBarArea.close_Lab_String) {
                SideBarArea.this.hideWin();
            }
            if (this.source.getName() == SideBarArea.hide_Lab_String) {
                SideBarArea.this.hideWin();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this.source.getName() == SideBarArea.close_Lab_String) {
                SideBarArea.this.close_Lab.setCursor(Cursor.getPredefinedCursor(12));
            }
            if (this.source.getName() == SideBarArea.hide_Lab_String) {
                SideBarArea.this.hideLab.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this.source.getName() == SideBarArea.close_Lab_String) {
                SideBarArea.this.close_Lab.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.source.getName() == SideBarArea.hide_Lab_String) {
                SideBarArea.this.hideLab.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

