/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.tree;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.ILNTreeNodeCtrl;
import com.kingdee.eas.framework.client.tree.ITreeBuilder;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class LNTreeBuilder
implements ITreeBuilder {
    private ILNTreeNodeCtrl ctrl;
    private int initalLevel;
    private int expandLevel;
    private FilterInfo filter;
    private SelectorItemCollection selector;

    public LNTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
    }

    public LNTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
    }

    public LNTreeBuilder(ILNTreeNodeCtrl ctrl, int initalLevel, int expandLevel, FilterInfo filter, SelectorItemCollection selector) {
        this.ctrl = ctrl;
        this.initalLevel = initalLevel;
        this.expandLevel = expandLevel;
        this.filter = filter;
        this.selector = selector;
    }

    @Override
    public void setExpandLevel(int expandLevel) {
        this.expandLevel = expandLevel;
    }

    @Override
    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)((Object)tree.getModel().getRoot());
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        AbstractObjectCollection col = rootNode.getUserObject() != null && rootNode.getUserObject() instanceof TreeBaseInfo ? this.ctrl.getChildren((TreeBaseInfo)rootNode.getUserObject(), this.initalLevel, this.filter, this.selector) : this.ctrl.getChildren(null, this.initalLevel, this.filter, this.selector);
        tree.setShowsRootHandles(true);
        this.buildChildren(tree, rootNode, col, this.initalLevel);
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)((Object)rootNode));
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)((Object)event.getPath().getLastPathComponent());
                    if (LNTreeBuilder.this.filter != null) {
                        LNTreeBuilder.this.getChildren(tree, treeNode, LNTreeBuilder.this.filter);
                    } else {
                        LNTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)((Object)e.getPath().getLastPathComponent());
                    if (LNTreeBuilder.this.filter != null) {
                        LNTreeBuilder.this.getChildren(tree, treeNode, LNTreeBuilder.this.filter);
                    } else {
                        LNTreeBuilder.this.getChildren(tree, treeNode);
                    }
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)((Object)treeNode));
            AbstractObjectCollection col = this.ctrl.getChildren(treeNodeInfo, this.expandLevel);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }

    private void buildChildren(KDTree tree, KDTreeNode parentNode, AbstractObjectCollection col, int level) {
        KDTreeNode beforeTreeNode = parentNode;
        TreeBaseInfo parentNodeInfo = null;
        if (parentNode.getUserObject() instanceof TreeBaseInfo) {
            parentNodeInfo = (TreeBaseInfo)parentNode.getUserObject();
        }
        for (TreeBaseInfo treeNodeInfo : col) {
            if (parentNodeInfo != null && treeNodeInfo.getLongNumber().equals(parentNodeInfo.getLongNumber())) {
                parentNode.setUserObject(treeNodeInfo);
                continue;
            }
            KDTreeNode treeNode = new KDTreeNode(treeNodeInfo);
            if (treeNodeInfo.isIsLeaf() || treeNodeInfo.getLevel() < parentNode.getLevel() + level) {
                treeNode.setVirtual(false);
            } else {
                treeNode.setVirtual(true);
                treeNode.add(new DefaultMutableTreeNode());
            }
            if (beforeTreeNode.getLevel() == 0) {
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)treeNode), (MutableTreeNode)((Object)beforeTreeNode), index);
            } else {
                int curLevel = treeNodeInfo.getLevel();
                for (int beforeLevel = ((TreeBaseInfo)beforeTreeNode.getUserObject()).getLevel(); beforeLevel >= curLevel && beforeTreeNode.getParent() != null; --beforeLevel) {
                    beforeTreeNode = (KDTreeNode)((Object)beforeTreeNode.getParent());
                }
                int index = beforeTreeNode.getChildCount();
                tree.insertNodeInto((MutableTreeNode)((Object)treeNode), (MutableTreeNode)((Object)beforeTreeNode), index);
            }
            beforeTreeNode = treeNode;
        }
    }

    @Override
    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode);
    }

    @Override
    public void refreshTreeNode(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        treeNode.setVirtual(true);
        this.getChildren(tree, treeNode, filter);
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode, FilterInfo filter) throws Exception {
        if (treeNode.isVirtual()) {
            TreeBaseInfo treeNodeInfo = null;
            if (treeNode.getUserObject() != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
                treeNodeInfo = (TreeBaseInfo)treeNode.getUserObject();
            }
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)((Object)treeNode));
            AbstractObjectCollection col = this.selector != null ? this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter, this.selector) : this.ctrl.getChildren(treeNodeInfo, this.expandLevel, filter);
            this.buildChildren(tree, treeNode, col, this.expandLevel);
        }
    }
}

