/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.monitor.client.ActivityTableUI;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUtil;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class WfClientUtils {
    public static String getAction(AssignmentInfo assignment) {
        String action = null;
        action = WfClientUtils.getActionByOperation((IMetaDataPK)new MetaDataPK(assignment.getBizPackage(), assignment.getBizFunction()), assignment.getBizOperation());
        return action;
    }

    public static boolean matchAction(AssignmentInfo assignment, String action) {
        String destAction = WfClientUtils.getActionByOperation((IMetaDataPK)new MetaDataPK(assignment.getBizPackage(), assignment.getBizFunction()), action);
        return action.equals(destAction);
    }

    public static String getActionByOperation(IMetaDataPK functionPk, String operation) {
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction(functionPk);
        return WfClientUtils.getActionByOperation(function, operation);
    }

    public static OperationInfo getOperation(IMetaDataPK functionPk, String operationName) {
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction(functionPk);
        if (function != null) {
            return (OperationInfo)function.getOperation().getObject((Object)operationName);
        }
        return null;
    }

    public static String getActionByOperation(FunctionObjectInfo function, String operation) {
        IObjectValue o = function.getOperation().getObject((Object)operation);
        String name = "";
        for (int i = 0; i < function.getOperation().size(); ++i) {
            if (function.getOperation().get(i).getUiActionRef() == null || !(name = function.getOperation().get(i).getUiActionRef().getActionRefName()).equalsIgnoreCase(operation)) continue;
            return name;
        }
        return "";
    }

    public static void invokeWfInstActivityTable(String assignmentId) throws BOSException {
        WfClientUtils.invokeWfInstActivityTable(assignmentId, null);
    }

    public static void invokeWfInstActivityTable(ProcessInstInfo processInst, IUIObject obj) throws BOSException {
        if (processInst == null) {
            throw new BOSException("WfClientUtils.invokeWfInstActivityTable args processInst can't be null");
        }
        String processInstId = processInst.getProcInstId();
        if (processInstId != null && !processInstId.trim().equals("")) {
            try {
                UIContext uiContext = null;
                uiContext = obj == null ? new UIContext() : new UIContext((Object)obj);
                uiContext.put((Object)"processInstId", (Object)processInstId);
                uiContext.put((Object)"processInstInfo", (Object)processInst);
                String className = ActivityTableUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
            catch (UIException e1) {
                e1.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void invokeWfInstActivityTable(ProcessInstInfo processInst) throws BOSException {
        WfClientUtils.invokeWfInstActivityTable(processInst, null);
    }

    public static void invokeWfInstActivityTable(String assignmentId, IUIObject obj) throws BOSException {
        if (StringUtils.isEmpty((String)assignmentId)) {
            throw new BOSException("WfClientUtils.invokeWfInstActivityTable args assignmentId can't be null");
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = service.getProcessInstInfoByAssign(assignmentId);
        WfClientUtils.invokeWfInstActivityTable(processInstInfo, obj);
    }

    public static void invokeWfInstActivityTableWithBillId(String biillId, IUIObject obj) throws BOSException {
        String assignmentId = MultiApproveUtil.getAssignmentIdByBillId((String)biillId);
        if (assignmentId == null || assignmentId.equals("")) {
            return;
        }
        WfClientUtils.invokeWfInstActivityTable(assignmentId, obj);
    }
}

