/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.jms.TextMessage;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.biz.trans.WfSendingMsgBundle;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.workflow.AbstractWorkflowSendMsgUI;
import com.kingdee.eas.mobile.msg.IMobileAppMsgFacade;
import com.kingdee.eas.mobile.msg.MobileAppMsgFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class WorkflowSendMsgUI
extends AbstractWorkflowSendMsgUI {
    private static final long serialVersionUID = -782532809532844233L;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initWfSendMsgUI();
    }

    protected void initWfSendMsgUI() {
        Collection wfMsgList = (Collection)this.getUIContext().get("wfMsgList");
        if (wfMsgList == null) {
            return;
        }
        int kDComboBoxMaxLength = 0;
        int kDComboBoxMinLength = 3;
        int kDComboBoxMaxHeight = 20;
        for (WfSendingMsgBundle wfMsg : wfMsgList) {
            this.kDComboBoxNextNodeList.addItem((Object)wfMsg);
            if (wfMsg.getName().length() <= kDComboBoxMaxLength) continue;
            kDComboBoxMaxLength = wfMsg.getName().length();
        }
        if (kDComboBoxMaxLength < 3) {
            kDComboBoxMaxLength = 3;
        }
        this.kDComboBoxNextNodeList.setSize(kDComboBoxMaxLength * 20, 20);
        this.kDComboBoxNextNodeList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WorkflowSendMsgUI.this.comboBoxPropertyChanged(e);
            }
        });
        this.kDComboBoxNextNodeList.setSelectedIndex(0);
        this.initMsgLabel();
    }

    protected void initMsgLabel() {
        int contentLength = this.txtContent.getText().length();
        String lable = this.msgLabel.getText();
        String newLable = lable.substring(0, lable.indexOf("[") + 1) + contentLength + lable.substring(lable.indexOf("]"), lable.length());
        this.msgLabel.setText(newLable);
    }

    protected void comboBoxPropertyChanged(ActionEvent e) {
        WfSendingMsgBundle msgBundle = (WfSendingMsgBundle)this.kDComboBoxNextNodeList.getSelectedItem();
        this.txtReceiver.setText(msgBundle.getRecevicers());
        this.txtContent.setText(msgBundle.getContent());
        if (msgBundle.isApproved()) {
            this.sendTypekDCheckBox.setEnabled(true);
            if (this.sendTypekDCheckBox.isSelected()) {
                this.setEnabledApprovedGroup(false);
            } else {
                this.setEnabledApprovedGroup(true);
            }
        } else {
            this.sendTypekDCheckBox.setSelected(false);
            this.sendTypekDCheckBox.setEnabled(false);
            this.setEnabledApprovedGroup(true);
        }
    }

    private void setEnabledApprovedGroup(boolean mark) {
        this.txtReceiver.setEnabled(mark);
        this.btnReceiver.setEnabled(mark);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void msg_inputMethodTextChanged(InputMethodEvent e) throws Exception {
        super.msg_inputMethodTextChanged(e);
    }

    @Override
    public void actionBackCheckBoxChanged_actionPerformed(ActionEvent e) throws Exception {
        if (this.sendTypekDCheckBox.isSelected()) {
            this.txtReceiver.setText(((WfSendingMsgBundle)this.kDComboBoxNextNodeList.getSelectedItem()).getRecevicers());
            this.setEnabledApprovedGroup(false);
        } else {
            this.setEnabledApprovedGroup(true);
        }
    }

    @Override
    public void actionSendMsg_actionPerformed(ActionEvent e) throws Exception {
        if (this.sendTypekDCheckBox.isSelected()) {
            String actInstId = ((WfSendingMsgBundle)this.kDComboBoxNextNodeList.getSelectedItem()).getActvityInstId();
            this.sendApprovalMessage(actInstId);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.base.message.client.MessageCenter", (String)"send_success"));
            this.getUIWindow().close();
        } else {
            super.actionSendMsg_actionPerformed(e);
        }
    }

    protected void sendApprovalMessage(String actInstId) throws BOSException, EASBizException {
        IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
        IMobileAppMsgFacade iMsg = MobileAppMsgFacadeFactory.getRemoteInstance();
        AssignmentInfo[] assignmentInfos = enactmentService.getAssignmentByActInstId(actInstId);
        List list = this.filterSameEmployee(assignmentInfos);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Message message = this.buildMessage((AssignmentInfo)it.next());
            iMsg.mobileAppListener(message);
        }
    }

    private List filterSameEmployee(AssignmentInfo[] assignmentInfos) {
        if (assignmentInfos == null || assignmentInfos.length <= 0) {
            return null;
        }
        ArrayList<AssignmentInfo> list = new ArrayList<AssignmentInfo>();
        for (int i = 0; i < assignmentInfos.length; ++i) {
            if (this.isExist(list, assignmentInfos[i].getEmployeeId())) continue;
            list.add(assignmentInfos[i]);
        }
        return list;
    }

    private boolean isExist(List list, String employeeId) {
        for (AssignmentInfo temp : list) {
            if (!temp.getEmployeeId().equals(employeeId)) continue;
            return true;
        }
        return false;
    }

    protected Message buildMessage(AssignmentInfo info) {
        TextMessage message = new TextMessage();
        String operation = "MultiApproveUIFunction.ActionSubmit";
        String pkgage = "com.kingdee.eas.base.multiapprove.client";
        String function = "MultiApproveUIFunction";
        message.setStringHeader("databaseCenter", SysContext.getSysContext().getDcName());
        message.setStringHeader("solution", SysContext.getSysContext().getSlnName());
        message.setStringHeader("ProcessInstId", info.getProcInstId());
        message.setStringHeader("activityInstId", info.getActInstId());
        message.setStringHeader("processDefHashValue", info.getProcDefHashValue());
        message.setStringHeader("operation", "MultiApproveUIFunction.ActionSubmit");
        message.setStringHeader("function", "MultiApproveUIFunction");
        message.setStringHeader("bizPackage", "com.kingdee.eas.base.multiapprove.client");
        message.setIntHeader("type", 10);
        message.setIntHeader("priority", 10);
        message.setStringHeader("receiver", info.getUserId());
        message.setStringHeader("sourceID", info.getAssignmentId());
        message.setBooleanHeader("isSendMobile", true);
        for (int i = 1; i < 4; ++i) {
            String localString = "L" + i;
            Locale locale = new Locale(localString);
            String title = info.getSubject(locale);
            String content = info.getBody(locale);
            message.setLocaleStringHeader("title", title, locale);
            message.setLocaleStringHeader("body", content, locale);
        }
        return message;
    }
}

