/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.client.workflow;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.agent.AgentUtility;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.ui.dtp.kdtable.CellInfo;
import com.kingdee.bos.ui.dtp.kdtable.ColumnInfo;
import com.kingdee.bos.ui.dtp.kdtable.HeaderInfo;
import com.kingdee.bos.ui.dtp.kdtable.KDTableDesignerHelper;
import com.kingdee.bos.ui.dtp.kdtable.TableInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.workflow.ProcessDefInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.define.ProcessDef;
import com.kingdee.bos.workflow.monitor.client.BasicShowWfDefinePanel;
import com.kingdee.bos.workflow.monitor.client.BasicWorkFlowMonitorPanel;
import com.kingdee.bos.workflow.monitor.client.ProcessRunningListUI;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class WorkflowUtils {
    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public static void dynamicConstructTable(KDTable table, IMetaDataPK queryPK, Locale locale) {
        QueryInfo queryInfo = WorkflowUtils.getQueryInfo(queryPK);
        SelectorInfo selectorInfo = queryInfo.getSelector();
        if (selectorInfo == null) {
            return;
        }
        int size = selectorInfo.size();
        if (size == 0) {
            return;
        }
        QueryFieldInfo[] queryFieldInfos = new QueryFieldInfo[size];
        for (int i = 0; i < size; ++i) {
            queryFieldInfos[i] = selectorInfo.get(i);
        }
        HeaderInfo headerInfo = new HeaderInfo();
        headerInfo.setName("header");
        TableInfo tableInfo = new TableInfo();
        tableInfo.setSelectMode(10);
        tableInfo.addHeader(headerInfo);
        String[] fields = new String[size];
        for (int i = 0; i < size; ++i) {
            String name;
            QueryFieldInfo queryFieldInfo = queryFieldInfos[i];
            String colName = name = queryFieldInfo.getName();
            ColumnInfo column = new ColumnInfo();
            column.setName(colName);
            tableInfo.addColumn(column);
            WorkflowUtils.processCustomDispaly(column, queryFieldInfo);
            CellInfo cell = new CellInfo();
            String cellName = queryFieldInfo.getDisplayName();
            if (StringUtils.isEmpty((String)cellName)) {
                cell.setName(name);
            } else {
                cell.setName(cellName);
            }
            cell.setColSpan(0);
            cell.setRowSpan(0);
            headerInfo.addCell(cell);
            fields[i] = colName;
        }
        String formatXML = KDTableDesignerHelper.getXmlFrom((TableInfo)tableInfo);
        table.setFormatXml(formatXML);
        table.putBindContents("mainQuery", fields);
        table.checkParsed(true);
    }

    private static void processCustomDispaly(ColumnInfo col, QueryFieldInfo queryFieldInfo) {
        String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
        String COL_WIDTH_IN_KDTABLE = "ColWidthInKDTable";
        String DISPLAY_FORMAT = "displayFormat";
        Map exProperties = queryFieldInfo.getExtendedProperties();
        if (exProperties != null) {
            String colFormat;
            Object objectVisible = exProperties.get("isVisibleForKDTable");
            boolean visible = true;
            if (objectVisible instanceof Boolean) {
                visible = (Boolean)objectVisible;
            } else if (objectVisible instanceof String) {
                visible = objectVisible == null ? true : Boolean.valueOf((String)objectVisible);
            }
            col.setHide(!visible);
            Object objectColWidth = exProperties.get("ColWidthInKDTable");
            int colWidth = 100;
            if (objectColWidth instanceof Integer) {
                colWidth = (Integer)objectColWidth;
            } else if (objectColWidth instanceof String) {
                colWidth = Integer.parseInt((String)objectColWidth);
            }
            col.setWidth(colWidth);
            Object objColFormat = exProperties.get("displayFormat");
            if (objColFormat instanceof String && !StringUtils.isEmpty((String)(colFormat = (String)objColFormat))) {
                col.setFormatString(colFormat);
            }
        }
    }

    public static void viewWorkFlowGraph(CoreBaseInfo editData, CoreUIObject uiObject, String wfFunctionName, String wfActionName) throws Exception {
        if (editData == null || uiObject == null) {
            throw new IllegalArgumentException("WorkflowUtils.viewWorkFlowGraph args can't be null, editData : " + editData + " uiObject : " + uiObject + " FunctionName : " + wfFunctionName + " OperationName : " + wfActionName);
        }
        String selectId = null;
        if (editData.getId() != null) {
            selectId = editData.getId().toString();
        }
        IEnactmentService service2 = EnactmentServiceFactory.createRemoteEnactService();
        ArrayList<ProcessInstInfo> openProcInsts = new ArrayList<ProcessInstInfo>();
        ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
        if (procInsts == null || procInsts.length == 0) {
            if (!StringUtils.isEmpty((String)selectId)) {
                procInsts = service2.getAllProcessInstancesByBizobjId(selectId);
                if (procInsts == null || procInsts.length <= 0) {
                    WorkflowUtils.viewSubmitProccessGraph((IObjectValue)editData, uiObject, wfFunctionName, wfActionName);
                } else if (procInsts.length == 1) {
                    WorkflowUtils.showWorkflowDiagram(procInsts[0], uiObject);
                } else {
                    WorkflowUtils.showWorkflowListDiagram(procInsts, uiObject);
                }
            } else {
                WorkflowUtils.viewSubmitProccessGraph((IObjectValue)editData, uiObject, wfFunctionName, wfActionName);
            }
        } else {
            for (int i = 0; i < procInsts.length; ++i) {
                ProcessInstInfo processInstInfo = procInsts[i];
                if (!"open".equalsIgnoreCase(processInstInfo.getState().substring(0, 4))) continue;
                openProcInsts.add(processInstInfo);
            }
            if (openProcInsts.size() == 0 || openProcInsts == null) {
                WorkflowUtils.viewSubmitProccessGraph((IObjectValue)editData, uiObject, wfFunctionName, wfActionName);
            } else if (openProcInsts.size() == 1) {
                WorkflowUtils.showWorkflowDiagram((ProcessInstInfo)openProcInsts.get(0), uiObject);
            } else {
                WorkflowUtils.showWorkflowListDiagram(openProcInsts.toArray(new ProcessInstInfo[0]), uiObject);
            }
        }
    }

    public static void viewSubmitProccessGraph(IObjectValue editData, CoreUIObject uiObject, String wfFunctionName, String wfActionName) throws Exception {
        if (editData == null || editData.getBOSType() == null || uiObject == null) {
            throw new IllegalArgumentException("WorkflowUtils.viewSubmitProccessGraph args can't be null, editData");
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        IObjectValue bizObj = AgentUtility.getNoAgentValue((IObjectValue)editData);
        uiObject.storeFields();
        String procDefID = service.findSubmitProcDef(SysContext.getSysContext().getCurrentUserInfo().getId().toString(), bizObj, wfFunctionName, wfActionName);
        if (procDefID != null) {
            ProcessDefInfo processDefInfo = service.getProcessDefInfo(procDefID);
            Locale currentLocale = SysContext.getSysContext().getLocale();
            ProcessDef processDef = service.getProcessDefByDefineHashValue(processDefInfo.getMd5HashValue());
            String procDefDiagramTitle = "";
            if (processDef != null) {
                procDefDiagramTitle = processDef.getName(currentLocale);
            }
            UIContext uiContext = new UIContext((Object)uiObject);
            uiContext.put((Object)"define", (Object)processDef);
            uiContext.put((Object)"title", (Object)procDefDiagramTitle);
            String className = BasicShowWfDefinePanel.class.getName();
            IUIFactory uiFactory = UIFactory.createUIFactory((String)WorkflowUtils.getEditUIMode(uiObject));
            IUIWindow uiWindow = uiFactory.create(className, (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showInfo((Component)uiObject, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotDef"));
        }
    }

    public static void viewWorkFlowGraph(CoreUIObject parentUiObject, String billId) throws Exception {
        if (StringUtils.isEmpty((String)billId)) {
            throw new IllegalArgumentException("WorkflowUtils.viewWorkFlowGraph args BillID can't be null");
        }
        IEnactmentService service = EnactmentServiceFactory.createRemoteEnactService();
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billId);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo == null) {
            procInsts = service.getAllProcessInstancesByBizobjId(billId);
            if (procInsts == null || procInsts.length <= 0) {
                MsgBox.showInfo((Component)parentUiObject, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_WFHasNotInstance"));
            } else if (procInsts.length == 1) {
                WorkflowUtils.showWorkflowDiagram(procInsts[0], parentUiObject);
            } else {
                UIContext uiContext = new UIContext((Object)parentUiObject);
                uiContext.put((Object)"procInsts", (Object)procInsts);
                String className = ProcessRunningListUI.class.getName();
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
                uiWindow.show();
            }
        } else {
            WorkflowUtils.showWorkflowDiagram(processInstInfo, parentUiObject);
        }
    }

    private static void showWorkflowDiagram(ProcessInstInfo processInstInfo, CoreUIObject parentUiObject) throws Exception {
        UIContext uiContext = new UIContext((Object)parentUiObject);
        uiContext.put((Object)"id", (Object)processInstInfo.getProcInstId());
        uiContext.put((Object)"processInstInfo", (Object)processInstInfo);
        String className = BasicWorkFlowMonitorPanel.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
    }

    private static void showWorkflowListDiagram(ProcessInstInfo[] processInstInfos, CoreUIObject parentUiObject) throws UIException {
        UIContext uiContext = new UIContext((Object)parentUiObject);
        uiContext.put((Object)"procInsts", (Object)processInstInfos);
        String className = ProcessRunningListUI.class.getName();
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(className, (Map)uiContext);
        uiWindow.show();
    }

    public static String getEditUIMode(CoreUIObject ui) {
        IUIWindow win = ui.getUIWindow();
        if (win instanceof KDFrame) {
            return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
        }
        if (win instanceof KDDialog) {
            return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
        }
        return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
    }
}

