/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.config;

import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.ComponentProperty;
import com.kingdee.bos.appframework.databinding.DataBinder;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.ui.util.ResourceBundleHelper;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.bos.util.backport.Collections;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.framework.client.ListUiHelper;
import com.kingdee.eas.framework.client.UITypeHelper;
import com.kingdee.eas.framework.client.popup.MenuSection;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.framework.config.ColumnItemData;
import com.kingdee.eas.framework.config.ITablePreferenceHelper;
import com.kingdee.eas.framework.config.UserCustomConfigItemData;
import com.kingdee.eas.framework.config.UserPreferenceData;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public abstract class AbstractTablePreferencesHelper
implements ITablePreferenceHelper {
    private static Logger logger = Logger.getLogger(AbstractTablePreferencesHelper.class);
    public ResourceBundleHelper resHelper;
    public static String RESNAME = "com.kingdee.eas.framework.config.Preferences";
    public static final String MENUITEM_TABLESETTING = "tableSetting";
    public static final String MENUITEM_SUM_ROW = "sum_row_setting";
    public static final String CURRENT_TABLE = "CurrentTable";
    public static final String HELPER = "helper";
    public static final String PRINTSETTING = "PrintSetting";
    public static final String ROW_HEIGHT = "RowHeight";
    public static final String ROW_FONTSIZE = "RowFontSize";
    public static final String HEAD_HEIGHT = "HeadHeight";
    public static final String HEAD_FONTSIZE = "HeadFontSize";
    public static final String FORECOLOR = "ForeGroundColor";
    public static final String BGCOLOR = "BackGroundColor";
    public static final String SPLIT_CHAR = "\u03b1";
    public static final String OLD_SPLIT_CHAR = ",";
    public Map uiTables = new LinkedHashMap();
    public Map tables = new LinkedHashMap();
    private Set disabledTables = new HashSet();
    private Set forceDisplayKeys = new HashSet();
    private boolean canSetHideColumn = true;
    private boolean canSetFrozeColumn = true;
    private boolean canSetForeColor = true;
    private boolean canSetBGColor = true;
    private boolean canSetRowHeight = true;
    private boolean isCanMoveColumn = true;
    private boolean canRestore = true;
    private boolean canUpgrade = true;
    private boolean canFind = true;
    private boolean isSimpleModel = false;
    public CommonQueryDialog dialog = null;
    public volatile UserPreferenceData defaultUserData = null;
    public CoreUI ui;
    public List hideColumnList = new ArrayList();
    private Map<String, List> hideColumnMap = new HashMap<String, List>();
    protected Context mainOrgContext = null;

    @Override
    public boolean isCanSetFrozeColumn() {
        return this.canSetFrozeColumn;
    }

    @Override
    public void setCanSetFrozeColumn(boolean canSetFrozeColumn) {
        this.canSetFrozeColumn = canSetFrozeColumn;
    }

    @Override
    public void putHideColumn(String columnName) {
        if (columnName == null) {
            return;
        }
        this.hideColumnList.add(columnName);
    }

    @Override
    public List getHideColumn() {
        return this.hideColumnList;
    }

    @Override
    public boolean isCanSetHideColumn() {
        return this.canSetHideColumn;
    }

    @Override
    public void setCanSetHideColumn(boolean canSetHideColumn) {
        this.canSetHideColumn = canSetHideColumn;
    }

    public void setCanSetForeColor(boolean canSetForeColor) {
        this.canSetForeColor = canSetForeColor;
    }

    public void setCanSetBGColor(boolean canSetBGColor) {
        this.canSetBGColor = canSetBGColor;
    }

    public void setCanSetRowHeight(boolean canSetRowHeight) {
        this.canSetRowHeight = canSetRowHeight;
    }

    public boolean isCanSetBGColor() {
        return this.canSetBGColor;
    }

    public boolean isCanSetForeColor() {
        return this.canSetForeColor;
    }

    public boolean isCanSetRowHeight() {
        return this.canSetRowHeight;
    }

    public Set getForceDisplayKeys() {
        return this.forceDisplayKeys;
    }

    public void setSimpleModel(boolean b) {
        this.isSimpleModel = b;
    }

    public boolean isSimpleModel() {
        return this.isSimpleModel;
    }

    @Override
    public Set getDisabledTables() {
        return this.disabledTables;
    }

    @Override
    public void setDefaultUserData(UserPreferenceData defaultUserData) {
        this.defaultUserData = defaultUserData;
    }

    @Override
    public void setCanMoveColumn(boolean isMove) {
        this.isCanMoveColumn = isMove;
    }

    @Override
    public boolean isCanMoveColumn() {
        return this.isCanMoveColumn;
    }

    @Override
    public void setCanRestore(boolean canRestore) {
        this.canRestore = canRestore;
    }

    @Override
    public boolean isCanRestore() {
        return this.canRestore;
    }

    @Override
    public void setCanUpgrade(boolean canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    @Override
    public boolean isCanUpgrade() {
        return this.canUpgrade;
    }

    @Override
    public void setCanFind(boolean canFind) {
        this.canFind = canFind;
    }

    @Override
    public boolean isCanFind() {
        return this.canFind;
    }

    @Override
    public Map<String, List> getHideColumnMap() {
        return this.hideColumnMap;
    }

    @Override
    public void restoreDefault(KDTable t) {
        this.applyConfigFromData(t, this.getTableCurrentSetting((String)this.uiTables.get(t)), false);
        t.reLayoutAndPaint();
    }

    private UserCustomConfigItemData getTableCurrentSetting(String tableName) {
        if (this.defaultUserData == null) {
            this.defaultUserData = this.getUserDataFromUI();
        }
        return this.defaultUserData.getTableCurrentSetting(tableName);
    }

    @Override
    public void applyConfigFromData(KDTable table, UserCustomConfigItemData userData) {
        this.applyConfigFromData(table, userData, true);
    }

    public void applyConfigFromData(KDTable table, UserCustomConfigItemData userData, boolean hasData) {
        if (this.canSetRowHeight) {
            try {
                table.setDefaultRowHeight(Integer.parseInt((String)userData.getGenericData().get(ROW_HEIGHT)));
                table.getStyleAttributes().setFontSize(Integer.parseInt((String)userData.getGenericData().get(ROW_FONTSIZE)));
                int rowCount = table.getHeadRowCount();
                int headHeight = Integer.parseInt((String)userData.getGenericData().get(HEAD_HEIGHT)) / rowCount;
                for (int index = 0; index < rowCount; ++index) {
                    table.getHeadRow(index).setHeight(headHeight);
                    table.getHeadRow(index).getStyleAttributes().setFontSize(Integer.parseInt((String)userData.getGenericData().get(HEAD_FONTSIZE)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.applyToTable(table, userData, hasData);
    }

    public void addMenuToTable(KDTable table) {
        KDMenuItem attachMenuItem;
        PopupMenuManager mgr = this.ui.getPopupMenuManager((JComponent)table);
        if (mgr == null) {
            this.ui.addCommonMenusToTable(table);
        }
        if ((mgr = this.ui.getPopupMenuManager((JComponent)table)) == null) {
            return;
        }
        MenuSection section = mgr.findMenuSection("table");
        if (section == null) {
            mgr.addMenuSection(new MenuSection("table"));
        }
        if (!(section = mgr.findMenuSection("table")).containsMenuItemName(MENUITEM_TABLESETTING)) {
            section.insertAfter((JMenuItem)this.getSettingMenuItem(table));
        }
        if (!section.containsMenuItemName("saveSetting")) {
            section.insertAfter((JMenuItem)this.getSaveMenuItem(table));
            section.insertAfter((JMenuItem)this.getDeleteMenuItem(table));
        }
        if (this.ui instanceof ListUI) {
            this.setDialog(((ListUI)this.ui).initQueryDialog());
        }
        if ((attachMenuItem = this.ui.getAttachMenuItem(table)) != null) {
            if (attachMenuItem.getName() == null) {
                if (!section.containsMenuItem((JMenuItem)attachMenuItem)) {
                    section.insertAfter((JMenuItem)attachMenuItem);
                }
            } else if (!section.containsMenuItemName(attachMenuItem.getName())) {
                section.insertAfter((JMenuItem)attachMenuItem);
            }
        }
    }

    @Override
    public void findAllTables(Component[] components) {
        if (components == null) {
            components = this.ui.getComponents();
            this.tables.clear();
            this.uiTables.clear();
        }
        for (int i = 0; i < components.length; ++i) {
            if (components[i] instanceof KDTable) {
                String uiClassName = this.ui.getMetaDataPK().getFullName();
                String tableName = uiClassName + "." + components[i].getName();
                if (this.disabledTables.contains(components[i])) continue;
                if (components[i] != null) {
                    ((KDTable)components[i]).checkParsed();
                }
                this.tables.put(tableName, components[i]);
                this.uiTables.put(components[i], tableName);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            Container container = (Container)components[i];
            this.findAllTables(container.getComponents());
        }
    }

    private KDMenuItem getSettingMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName(MENUITEM_TABLESETTING);
        item.setAction((Action)this.getActionShowPreference(table));
        item.setText(this.resHelper.getString("UITitle"));
        item.setToolTipText(this.resHelper.getString("UITitle"));
        return item;
    }

    private KDMenuItem getRestoreMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName("restoreSetting");
        item.setAction((Action)this.getActionRestoreDefault(table));
        item.setText(this.resHelper.getString("RestoreDefault"));
        item.setToolTipText(this.resHelper.getString("RestoreDefault"));
        return item;
    }

    private KDMenuItem getSaveMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName("saveSetting");
        item.setAction((Action)this.getActionSave(table));
        item.setText(this.resHelper.getString("SaveCurrentSetting"));
        item.setToolTipText(this.resHelper.getString("SaveCurrentSetting"));
        return item;
    }

    private KDMenuItem getDeleteMenuItem(KDTable table) {
        KDMenuItem item = new KDMenuItem();
        item.setName("deleteSetting");
        item.setAction((Action)this.getActionDelete(table));
        item.setText(this.resHelper.getString("DeleteCurrentSetting"));
        item.setToolTipText(this.resHelper.getString("DeleteCurrentSetting"));
        return item;
    }

    protected List getPermissionList(KDTable tb) {
        List permissionList = new ArrayList();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
        ObjectUuidPK orgPK = null;
        if (this.ui.getUIContext().get(this.ui.getMainType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.ui.getUIContext().get(this.ui.getMainType())).getId());
        }
        try {
            permissionList = this.ui instanceof ListUI ? AbstractTablePreferencesHelper.doFieldPermission(this.ui.getMetaDataPK(), (IObjectPK)userPK, orgPK, tb) : (this.ui instanceof EditUI ? AbstractTablePreferencesHelper.doFieldPermission(UITypeHelper.getType((EditUI)this.ui), (IObjectPK)userPK, (IObjectPK)orgPK, this.ui.getDataBinder()) : null);
        }
        catch (Exception E) {
            E.printStackTrace();
        }
        return permissionList;
    }

    public UserCustomConfigItemData getColumnDataFromTable(KDTable tb, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            itemData = new UserCustomConfigItemData();
        }
        List permissionList = this.getPermissionList(tb);
        int frozenColIndex = tb.getViewManager().getFreezeCol();
        int j = tb.getColumnCount();
        for (int i = 0; i < j; ++i) {
            IColumn col = tb.getColumn(i);
            String key = col.getKey();
            if (permissionList != null && permissionList.contains(key)) continue;
            int width = col.getKDTColumn().getWidth();
            if (width <= 0) {
                width = col.getWidth();
            }
            if (StringUtils.isEmpty((String)key) || width <= 0) continue;
            ColumnItemData columnData = new ColumnItemData();
            columnData.setIndex(i);
            columnData.setKey(key);
            if (tb.getHeadRowCount() == 1) {
                Object v = tb.getHeadRow(0).getCell(i).getValue();
                String title = v == null ? "" : String.valueOf(v);
                columnData.setTitle(title);
            } else {
                columnData.setTitle(this.getColTitle(tb, i));
            }
            columnData.setWidth(width);
            columnData.setAlign(col.getStyleAttributes().getHorizontalAlign());
            columnData.setHidden(col.getStyleAttributes().isHided());
            columnData.setLocked(false);
            if (frozenColIndex == 0) {
                columnData.setLocked(false);
            } else if (i < frozenColIndex) {
                columnData.setLocked(true);
            } else {
                columnData.setLocked(false);
            }
            itemData.getColumnData().put(key, columnData);
        }
        itemData = this.getTotalColumnsFromUITable(tb, itemData);
        return itemData;
    }

    private String getColTitle(KDTable tb, int colIndex) {
        int rowCnt = tb.getHeadRowCount();
        String result = "";
        for (int k = 0; k < rowCnt; ++k) {
            IRow row = tb.getHeadRow(k);
            ICell cell = row.getCell(colIndex);
            Object cellValue = cell.getValue();
            if (cell.getStyleAttributes().isHided()) continue;
            if (cellValue == null) {
                Object value;
                if (cell.getMergeBlock() == null || cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() <= 0) continue;
                if (result != null && result.length() > 0) {
                    result = result + "-";
                }
                if ((value = row.getCell(cell.getMergeBlock().getLeft()).getValue()) == null) continue;
                result = result + String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                continue;
            }
            String tmpValue = String.valueOf(cell.getValue());
            if (cell.getMergeBlock() != null) {
                Object value;
                if (cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() > 0 && (value = row.getCell(cell.getMergeBlock().getLeft()).getValue()) != null) {
                    tmpValue = String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                }
                if (cell.getMergeBlock().getBottom() - cell.getMergeBlock().getTop() > 0 && result != null && result.length() > 0 && cell.getMergeBlock().getTop() != cell.getRowIndex()) {
                    tmpValue = "";
                }
            }
            if (result != null && result.length() > 0 && tmpValue.length() > 0) {
                result = result + "-";
            }
            result = result + tmpValue;
        }
        return result;
    }

    @Override
    public UserCustomConfigItemData getDefaultUserData(KDTable t) {
        return this.getTableCurrentSetting((String)this.uiTables.get(t));
    }

    private boolean containsTabSettingMenuItem(Component[] components) {
        if (components == null) {
            return false;
        }
        int j = components.length;
        for (int i = 0; i < j; ++i) {
            if (!MENUITEM_TABLESETTING.equals(components[i].getName())) continue;
            return true;
        }
        return false;
    }

    public Color getColor(String s) {
        if (s != null) {
            String[] rgb = s.split(SPLIT_CHAR);
            if (rgb.length == 1) {
                rgb = s.split(OLD_SPLIT_CHAR);
            }
            return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
        }
        return null;
    }

    public String getColorString(Color c) {
        String result = "";
        if (c != null) {
            result = result + String.valueOf(c.getRed()) + String.valueOf(SPLIT_CHAR);
            result = result + String.valueOf(c.getGreen()) + String.valueOf(SPLIT_CHAR);
            result = result + String.valueOf(c.getBlue());
        }
        return result;
    }

    public Styles.HorizontalAlignment getAlign(String str) {
        if (str.equalsIgnoreCase("left")) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase("center")) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase("right")) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return this.getAlignFromSource(str);
    }

    private Styles.HorizontalAlignment getAlignFromSource(String str) {
        if (str.equalsIgnoreCase(this.resHelper.getString("left"))) {
            return Styles.HorizontalAlignment.LEFT;
        }
        if (str.equalsIgnoreCase(this.resHelper.getString("center"))) {
            return Styles.HorizontalAlignment.CENTER;
        }
        if (str.equalsIgnoreCase(this.resHelper.getString("right"))) {
            return Styles.HorizontalAlignment.RIGHT;
        }
        return Styles.HorizontalAlignment.LEFT;
    }

    @Override
    public ColumnItemData string2ColumnData(String values) {
        if (values == null) {
            return null;
        }
        String[] value = values.split(SPLIT_CHAR);
        if (value.length == 1) {
            value = values.split(OLD_SPLIT_CHAR);
        }
        if (value.length < 7) {
            return null;
        }
        ColumnItemData data = new ColumnItemData();
        data.setTitle(value[0]);
        data.setWidth(Integer.parseInt(value[1]));
        data.setAlign(this.getAlign(value[2]));
        data.setSorted(Boolean.valueOf(value[3]));
        data.setHidden(Boolean.valueOf(value[4]));
        data.setLocked(Boolean.valueOf(value[5]));
        data.setIndex(Integer.parseInt(value[6]));
        return data;
    }

    @Override
    public String getPrintSetting(KDTable tbl) {
        UserPreferenceData userData = this.getUserDataFromDB();
        UserCustomConfigItemData itemData = null;
        if (userData != null) {
            itemData = (UserCustomConfigItemData)userData.getTables().get((String)this.uiTables.get(tbl));
        }
        if (itemData != null) {
            return (String)itemData.getGenericData().get(PRINTSETTING);
        }
        return null;
    }

    @Override
    public void setPrintSetting(KDTable tbl, String printSetting) {
        UserPreferenceData userData = this.getUserDataFromDB();
        UserCustomConfigItemData itemData = null;
        if (userData == null) {
            userData = this.getUserDataFromUI();
        }
        if (userData != null) {
            itemData = (UserCustomConfigItemData)userData.getTables().get((String)this.uiTables.get(tbl));
        }
        if (itemData != null) {
            itemData.getGenericData().put(PRINTSETTING, printSetting);
            try {
                this.saveDataToDB(userData);
            }
            catch (Exception e) {
                logger.error((Object)("save userconfig error:" + e));
            }
        }
    }

    @Override
    public UserPreferenceData getUserDataFromUI() {
        UserPreferenceData userData = new UserPreferenceData();
        userData.setVersion(UserPreferenceData.VER_2_0_0);
        for (String tableName : this.tables.keySet()) {
            KDTable tb = (KDTable)this.tables.get(tableName);
            UserCustomConfigItemData itemData = null;
            itemData = this.getColumnDataFromTable(tb, itemData);
            itemData = this.getGenricDataFromTable(tb, itemData);
            userData.getTables().put(tableName, itemData);
        }
        return userData;
    }

    public UserCustomConfigItemData getTotalColumnsFromUITable(KDTable tb, UserCustomConfigItemData itemData) {
        if (this.ui instanceof ListUI) {
            if (((ListUI)this.ui).getCurrentListUISumList() != null) {
                itemData.setTotalColumns(((ListUI)this.ui).getCurrentListUISumList());
            }
        } else if (this.ui instanceof EditUI && ((EditUI)this.ui).getCurrentEditUISumList(tb) != null) {
            itemData.setTotalColumns(((EditUI)this.ui).getCurrentEditUISumList(tb));
        }
        return itemData;
    }

    public UserCustomConfigItemData getGenricDataFromTable(KDTable tb, UserCustomConfigItemData itemData) {
        if (itemData == null) {
            itemData = new UserCustomConfigItemData();
        }
        itemData.getGenericData().put(ROW_HEIGHT, String.valueOf(tb.getDefaultRowHeight()));
        itemData.getGenericData().put(ROW_FONTSIZE, String.valueOf(tb.getStyleAttributes().getFontSize()));
        itemData.getGenericData().put(FORECOLOR, this.getColorString(tb.getStyleAttributes().getFontColor()));
        itemData.getGenericData().put(BGCOLOR, this.getColorString(tb.getStyleAttributes().getBackground()));
        int rowCount = tb.getHeadRowCount();
        if (rowCount > 0) {
            int headHeight = 0;
            for (int index = 0; index < rowCount; ++index) {
                headHeight += tb.getHeadRow(index).getHeight();
            }
            if (headHeight > 100) {
                headHeight = 100;
            }
            if (headHeight < 0) {
                headHeight = 0;
            }
            itemData.getGenericData().put(HEAD_HEIGHT, String.valueOf(headHeight));
            itemData.getGenericData().put(HEAD_FONTSIZE, String.valueOf(tb.getHeadRow(0).getStyleAttributes().getFontSize()));
        }
        return itemData;
    }

    private void applyToTable(KDTable table, UserCustomConfigItemData itemData, boolean hasData) {
        ColumnItemData columnData;
        if (itemData == null) {
            return;
        }
        ArrayList<String> hideColumns = new ArrayList<String>();
        boolean isMoveable = table.isColumnMoveable();
        if (!isMoveable) {
            table.setColumnMoveable(true);
        }
        if (this.isCanMoveColumn()) {
            List columnList = Arrays.asList((Object[])itemData.getColumnData().keySet().toArray());
            if (hasData) {
                Collections.reverse((List)columnList);
            }
            for (String key : columnList) {
                int originalIndex;
                int expectIndex;
                columnData = (ColumnItemData)itemData.getColumnData().get(key);
                if (columnData == null || (expectIndex = columnData.getIndex()) == (originalIndex = table.getColumnIndex(key)) || expectIndex < 0 || originalIndex < 0) continue;
                try {
                    KDTMergeBlock mb;
                    KDTCell cell;
                    KDTMergeManager manager = table.getHeadMergeManager();
                    if (manager.hasMultiColumnMerge(expectIndex) && (cell = table.getHead().getRow2(0).getCell(expectIndex)) != null && cell.getMergeBlock() != null && expectIndex == (mb = cell.getMergeBlock()).getLeft()) {
                        expectIndex = mb.getLeft() != 0 ? expectIndex : 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                table.moveColumn(originalIndex, expectIndex);
            }
        }
        int frozeColumnIndex = -1;
        for (String key : itemData.getColumnData().keySet()) {
            IColumn col;
            columnData = (ColumnItemData)itemData.getColumnData().get(key);
            if (columnData == null || (col = table.getColumn(key)) == null || col.getKDTColumn().getWidth() <= 0 && col.getStyleAttributes().isHided()) continue;
            col.setUserObject((Object)columnData);
            col.getStyleAttributes().setHided(columnData.isHidden());
            if (columnData.isHidden()) {
                hideColumns.add(col.getFieldName());
            }
            col.setWidth(columnData.getWidth());
            col.getStyleAttributes().setHorizontalAlign(columnData.getAlign());
            if (!columnData.isLocked() || columnData.getIndex() <= frozeColumnIndex) continue;
            frozeColumnIndex = columnData.getIndex();
        }
        if (this.ui instanceof ListUI) {
            ((ListUI)this.ui).setCurrentListUISumList(itemData.getTotalColumns());
        } else if (this.ui instanceof EditUI) {
            ((EditUI)this.ui).setCurrentEditUISumList(table, itemData.getTotalColumns());
        }
        this.hideColumnMap.put(table.getName(), hideColumns);
        if (table.getViewManager().getFreezeCol() > 0) {
            table.getViewManager().setFreezeView(0, 0);
        } else if (table.getViewManager().getFreezeCol() > 0) {
            table.getViewManager().freeze(0, 0);
        }
        if (frozeColumnIndex >= 0) {
            if (!hasData) {
                table.getViewManager().setFreezeView(0, frozeColumnIndex + 1);
            } else {
                table.getViewManager().freeze(0, frozeColumnIndex + 1);
            }
        }
        table.setColumnMoveable(isMoveable);
        ListUiHelper.regroupTable(table);
    }

    public UserPreferenceData upgradeToVer2_0_0(UserPreferenceData data) {
        data.setVersion(UserPreferenceData.VER_2_0_0);
        for (String tableName : this.tables.keySet()) {
            KDTable tempTab = (KDTable)this.tables.get(tableName);
            UserCustomConfigItemData item = (UserCustomConfigItemData)data.getTables().get(tableName);
            if (tempTab == null || item == null) continue;
            item = this.upgradeToVer2_0_0(item, tempTab);
            data.getTables().put(tableName, item);
        }
        return data;
    }

    private UserCustomConfigItemData upgradeToVer2_0_0(UserCustomConfigItemData item, KDTable table) {
        UserCustomConfigItemData newItem = new UserCustomConfigItemData();
        newItem.getGenericData().putAll(item.getGenericData());
        for (String key : item.getColumnData().keySet()) {
            try {
                int index = Integer.valueOf(key);
                IColumn col = table.getColumn(index);
                if (col == null) continue;
                String colKey = col.getKey();
                if (StringUtils.isEmpty((String)colKey)) {
                    colKey = key;
                }
                newItem.getColumnData().put(colKey, item.getColumnData().get(key));
            }
            catch (Exception e) {
                logger.error((Object)"update UserCustomeConfigItemData error.", (Throwable)e);
            }
        }
        return newItem;
    }

    public static List doFieldPermission(IMetaDataPK metaDataPK, IObjectPK userPK, IObjectPK orgPK, KDTable table) throws Exception {
        ArrayList<String> permissionList = new ArrayList<String>();
        FieldAccessInfo fieldAccess = null;
        FieldPermission fields = PermissionHelper.getQueryFieldPermission((IMetaDataPK)metaDataPK, (IObjectPK)userPK, (IObjectPK)orgPK);
        for (int i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            IColumn col = null;
            String columnName = null;
            if (table != null) {
                for (int j = 0; j < table.getColumnCount(); ++j) {
                    col = table.getColumn(j);
                    if (!fieldName.equals(col.getFieldName())) continue;
                    columnName = table.getColumns().getColumnKey(j);
                    break;
                }
            }
            if (columnName == null || fieldAccess.isViewable() || fieldAccess.isEditable()) continue;
            permissionList.add(columnName);
        }
        return permissionList;
    }

    public static List doFieldPermission(BOSObjectType bizObjectType, IObjectPK userPK, IObjectPK orgPK, DataBinder dataBinder) throws Exception {
        ArrayList<String> permissionList = new ArrayList<String>();
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        Component comp = null;
        if (bizObjectType == null) {
            return permissionList;
        }
        fields = PermissionHelper.getFieldPermission((BOSObjectType)bizObjectType, (IObjectPK)userPK, (IObjectPK)orgPK);
        for (int i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            comp = dataBinder.getComponetByField(fieldName);
            KDTable table = null;
            String columnName = null;
            if (comp == null || !(comp instanceof KDTable)) continue;
            table = (KDTable)comp;
            if (table != null) {
                ComponentProperty comproperty = dataBinder.getDataComponentMap().getComponentProperty(fieldName);
                String propertyName = comproperty.getPropertyName();
                columnName = propertyName.lastIndexOf(".") > 0 ? propertyName.substring(0, propertyName.lastIndexOf(".") - 1) : propertyName;
            }
            if (!fields.isEnableFieldPermission(fieldName) || fieldAccess.isViewable() || fieldAccess.isEditable() || columnName == null) continue;
            permissionList.add(columnName);
        }
        return permissionList;
    }

    @Override
    public void setQuerySolutionInfo(QuerySolutionInfo querySolutionInfo) {
    }

    @Override
    public void setUserPreferenceData(com.kingdee.eas.base.commonquery.UserPreferenceData userPreferenceData) {
    }

    @Override
    public void setDefaultSolution(boolean isDefaultSolution) {
    }

    @Override
    public void setUiQueryName(String uiName, String queryName) {
    }

    @Override
    public void setDialog(CommonQueryDialog dialog) {
    }

    @Override
    public CommonQueryDialog getDialog() {
        return this.dialog;
    }

    @Override
    public void restoreDefaultSolution(KDTable tb) {
    }

    @Override
    public boolean isUiQueryNull() {
        return false;
    }

    @Override
    public boolean isCanSetTable() {
        return false;
    }

    @Override
    public void setCanSetTable(boolean canSetTable) {
    }

    @Override
    public Map getUiTables() {
        return this.uiTables;
    }

    @Override
    public void setMainOrgContext(Context context) {
        this.mainOrgContext = context;
    }
}

